/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Managers;

import io.github.b4n9z.deathPulse.DeathPulse;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TransactionManager {
    private static final Map<UUID, String> activeTransactions = new HashMap<UUID, String>();

    public static String generateTransactionId(CommandSender sender) {
        return sender instanceof Player ? String.valueOf(((Player)sender).getUniqueId()) + "-" + System.currentTimeMillis() : "CONSOLE-" + System.currentTimeMillis();
    }

    public static void openTransaction(DeathPulse plugin, CommandSender sender, String transactionId) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            activeTransactions.put(player.getUniqueId(), transactionId);
        }
        plugin.getServer().getScheduler().runTaskLater((Plugin)plugin, () -> {
            if (TransactionManager.isValidTransaction(sender, transactionId)) {
                TransactionManager.closeTransaction(sender);
            }
        }, 1200L);
    }

    public static boolean isValidTransaction(CommandSender sender, String transactionId) {
        if (!(sender instanceof Player)) {
            return true;
        }
        UUID playerId = ((Player)sender).getUniqueId();
        String storedId = activeTransactions.get(playerId);
        return storedId != null && storedId.equals(transactionId);
    }

    public static void closeTransaction(CommandSender sender) {
        if (sender instanceof Player) {
            activeTransactions.remove(((Player)sender).getUniqueId());
        }
    }
}

