/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Managers;

import io.github.b4n9z.deathPulse.DeathPulse;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class HealthItemManager {
    private final DeathPulse plugin;
    private ItemStack healthItem;

    public HealthItemManager(DeathPulse plugin) {
        this.plugin = plugin;
        this.createHealthItem();
    }

    private void createHealthItem() {
        ItemStack item = new ItemStack(Material.valueOf((String)this.plugin.getConfigManager().getHealthItemMaterial()));
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfigManager().getHealthItemName()));
        List lore = this.plugin.getConfigManager().getHealthItemLore().stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList());
        meta.setLore(lore);
        meta.setUnbreakable(true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_PLACED_ON});
        try {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)this.plugin, "healthItem"), PersistentDataType.BYTE, (Object)1);
        item.setItemMeta(meta);
        this.healthItem = item;
    }

    public boolean isHealthItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        PersistentDataContainer pdc = Objects.requireNonNull(item.getItemMeta()).getPersistentDataContainer();
        return pdc.has(new NamespacedKey((Plugin)this.plugin, "healthItem"), PersistentDataType.BYTE);
    }

    public ItemStack getHealthItem() {
        return this.healthItem.clone();
    }

    public int getHealthPerItem() {
        return (int)this.plugin.getConfigManager().getHealthItemHealthPerItem();
    }
}

