/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Managers;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DebtDataManager {
    private final Plugin plugin;
    private final File dataFolder;
    private final Map<UUID, Integer> playerDebtCache = new HashMap<UUID, Integer>();
    private final ReentrantLock lock = new ReentrantLock();

    public DebtDataManager(Plugin plugin) {
        this.plugin = plugin;
        this.dataFolder = new File(plugin.getDataFolder(), "debt_data");
        if (!this.dataFolder.exists() && !this.dataFolder.mkdirs()) {
            throw new RuntimeException("Failed to create data directory: " + this.dataFolder.getAbsolutePath());
        }
    }

    private File getPlayerFile(UUID playerUUID) {
        return new File(this.dataFolder, playerUUID.toString() + ".dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadDebt(UUID playerUUID) {
        this.lock.lock();
        try {
            int n;
            if (this.playerDebtCache.containsKey(playerUUID)) {
                int n2 = this.playerDebtCache.get(playerUUID);
                return n2;
            }
            File file = this.getPlayerFile(playerUUID);
            if (!file.exists()) {
                this.playerDebtCache.put(playerUUID, 0);
                int n3 = 0;
                return n3;
            }
            DataInputStream dis = new DataInputStream(new FileInputStream(file));
            try {
                int debt = dis.readInt();
                this.playerDebtCache.put(playerUUID, debt);
                n = debt;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        dis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Bukkit.getLogger().severe("Failed to load debt data for " + String.valueOf(playerUUID));
                    int n4 = 0;
                    return n4;
                }
            }
            dis.close();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void saveDebt(UUID playerUUID, int debt) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            this.lock.lock();
            try {
                File file = this.getPlayerFile(playerUUID);
                try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
                    dos.writeInt(debt);
                }
                catch (IOException e) {
                    Bukkit.getLogger().severe("Failed to save debt data for " + String.valueOf(playerUUID));
                }
            }
            finally {
                this.lock.unlock();
            }
        });
    }

    public void setDebt(UUID playerUUID, int debt) {
        this.lock.lock();
        try {
            this.playerDebtCache.put(playerUUID, debt);
        }
        finally {
            this.lock.unlock();
        }
        this.saveDebt(playerUUID, debt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDebt(UUID playerUUID) {
        this.lock.lock();
        try {
            Integer debt = this.playerDebtCache.get(playerUUID);
            if (debt == null) {
                debt = this.loadDebt(playerUUID);
            }
            int n = debt;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDebt(UUID playerUUID, int amount) {
        if (amount <= 0) {
            return;
        }
        int newDebt = this.getDebt(playerUUID) + amount;
        this.setDebt(playerUUID, newDebt);
    }

    public int reduceDebt(UUID playerUUID, int amount) {
        int currentDebt = this.getDebt(playerUUID);
        int newDebt = currentDebt - amount;
        if (newDebt < 0) {
            int leftover = -newDebt;
            this.setDebt(playerUUID, 0);
            return leftover;
        }
        this.setDebt(playerUUID, newDebt);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDebtData(UUID playerUUID) {
        if (this.lock.tryLock()) {
            try {
                this.playerDebtCache.remove(playerUUID);
                File file = this.getPlayerFile(playerUUID);
                if (file.exists()) {
                    boolean bl = file.delete();
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllDebtData() {
        if (this.lock.tryLock()) {
            try {
                this.playerDebtCache.clear();
                File[] files = this.dataFolder.listFiles((dir, name) -> name.endsWith(".dat"));
                if (files != null) {
                    int count = files.length;
                    int deleted = 0;
                    for (File file : files) {
                        if (!file.delete()) continue;
                        ++deleted;
                    }
                    boolean bl = deleted == count;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }
}

