/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class ConfigManager {
    private final Plugin plugin;
    private int configVersion;
    private int firstTimeSetup;
    private int checkDayPeriod;
    private Map<World, Long> worldsList;
    private List<String> invalidWorlds;
    private List<String> tickErrorWorlds;
    private int hpStart;
    private boolean hpMaxEnabled;
    private int hpMaxAmount;
    private boolean dropHealthItem;
    private boolean hpMinEnabled;
    private int hpMinAmount;
    private int hpMinBanTime;
    private int hpAfterBan;
    private String healthItemMaterial;
    private String healthItemName;
    private List<String> healthItemLore;
    private double healthItemHealthPerItem;
    private List<String> healthItemCannotToCraft;
    private List<String> priority;
    private boolean ignoredEnabled;
    private boolean ignoredMustDifference;
    private List<String> ignoredCause;
    private List<String> ignoredCauseExclude;
    private boolean ignoredDayEnabled;
    private boolean ignoredDayMustDifference;
    private boolean ignoredDayDeActiveIncreaseCause;
    private boolean ignoredDayDeActiveDecreaseCause;
    private boolean ignoredDayDeActiveIncreaseDay;
    private boolean ignoredDayDeActiveDecreaseDay;
    private String ignoredDayType;
    private List<Integer> ignoredDays;
    private List<String> ignoredDayCause;
    private List<String> ignoredDayCauseExclude;
    private boolean increaseEnabled;
    private boolean increaseMustDifference;
    private Map<String, Integer> increaseCause;
    private List<String> increaseCauseName;
    private List<String> increaseCauseExclude;
    private boolean increaseDayEnabled;
    private boolean increaseDayMustDifference;
    private boolean increaseDayDeActiveIgnoreCause;
    private boolean increaseDayDeActiveDecreaseCause;
    private boolean increaseDayDeActiveIgnoreDay;
    private boolean increaseDayDeActiveDecreaseDay;
    private String increaseDayType;
    private List<Integer> increaseDays;
    private Map<String, Integer> increaseDayCause;
    private List<String> increaseDayCauseName;
    private List<String> increaseDayCauseExclude;
    private boolean decreaseEnabled;
    private boolean decreaseMustDifference;
    private boolean decreaseDebt;
    private Map<String, Integer> decreaseCause;
    private List<String> decreaseCauseName;
    private List<String> decreaseCauseExclude;
    private boolean decreaseDayEnabled;
    private boolean decreaseDayMustDifference;
    private boolean decreaseDayDeActiveIgnoreCause;
    private boolean decreaseDayDeActiveIncreaseCause;
    private boolean decreaseDayDeActiveIgnoreDay;
    private boolean decreaseDayDeActiveIncreaseDay;
    private String decreaseDayType;
    private List<Integer> decreaseDays;
    private Map<String, Integer> decreaseDayCause;
    private List<String> decreaseDayCauseName;
    private List<String> decreaseDayCauseExclude;
    private boolean seasonEnabled;
    private String seasonType;
    private int seasonDay;
    private boolean resetWorldDay;
    private final Map<String, Boolean> permissionAllPlayer = new HashMap<String, Boolean>();
    private static final String PERM_PREFIX = "dp.";
    private boolean defaultDeathMessageEnabled;
    private String notificationPlayerMaxHealth;
    private String notificationPlayerMinHealth;
    private String notificationPlayerBanReason;
    private String notificationPlayerKicked;
    private String notificationPlayerIgnored;
    private String notificationPlayerIgnoredSameWay;
    private String notificationPlayerIncrease;
    private String notificationPlayerIncreaseSameWay;
    private String notificationPlayerDecrease;
    private String notificationPlayerDecreaseSameWay;
    private String notificationPlayerDebtPaidOff;
    private String notificationPlayerDebtReduced;
    private String notificationPlayerDebtAdded;
    private String ignoredDayWarning;
    private String increaseDayWarning;
    private String decreaseDayWarning;
    private String seasonChangeWarning;
    private String notificationLogServerMaxHealth;
    private String notificationLogServerMinHealth;
    private String notificationLogServerIncrease;
    private String notificationLogServerDecrease;
    private String notificationLogServerBanReason;
    private List<String> cachedConfigPaths = null;

    public ConfigManager(Plugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.plugin.getConfig().options().copyDefaults(true);
        this.plugin.saveConfig();
    }

    public void loadConfig() {
        try {
            this.configVersion = this.plugin.getConfig().getInt("config-version", 0);
            this.firstTimeSetup = this.plugin.getConfig().getInt("firstTimeSetup", 0);
            this.checkDayPeriod = this.plugin.getConfig().getInt("checkDayPeriod", 30);
            ConfigurationSection worldSettings = this.plugin.getConfig().getConfigurationSection("worldDaySettings");
            HashMap<String, Long> worldTicks = new HashMap<String, Long>();
            if (worldSettings != null) {
                for (String string : worldSettings.getKeys(false)) {
                    long ticks = this.plugin.getConfig().getLong("worldDaySettings." + string);
                    worldTicks.put(string, ticks);
                }
            }
            if (worldTicks.isEmpty()) {
                worldTicks.put("world", 24000L);
            }
            this.invalidWorlds = new ArrayList<String>();
            this.tickErrorWorlds = new ArrayList<String>();
            this.worldsList = new HashMap<World, Long>();
            for (Map.Entry entry : worldTicks.entrySet()) {
                World worldBukkit = Bukkit.getWorld((String)((String)entry.getKey()));
                if (worldBukkit != null) {
                    this.worldsList.put(worldBukkit, (Long)entry.getValue());
                    if ((Long)entry.getValue() > 0L) continue;
                    this.tickErrorWorlds.add((String)entry.getKey());
                    continue;
                }
                this.invalidWorlds.add((String)entry.getKey());
            }
            this.hpStart = this.plugin.getConfig().getInt("hp.start", 20);
            this.hpMaxEnabled = this.plugin.getConfig().getBoolean("hp.maxHP.enabled", false);
            this.hpMaxAmount = this.plugin.getConfig().getInt("hp.maxHP.amount", 140);
            this.dropHealthItem = this.plugin.getConfig().getBoolean("hp.maxHP.dropHealthItem", true);
            this.hpMinEnabled = this.plugin.getConfig().getBoolean("hp.minHP.enabled", false);
            this.hpMinAmount = this.plugin.getConfig().getInt("hp.minHP.amount", 2);
            this.hpMinBanTime = this.plugin.getConfig().getInt("hp.minHP.banTime", 24);
            this.hpAfterBan = this.plugin.getConfig().getInt("hp.afterBan", 2);
            this.healthItemMaterial = this.plugin.getConfig().getString("healthItem.material", "NETHER_STAR");
            this.healthItemName = this.plugin.getConfig().getString("healthItem.name", "Health Token");
            this.healthItemLore = this.plugin.getConfig().getStringList("healthItem.lore");
            this.healthItemHealthPerItem = this.plugin.getConfig().getDouble("healthItem.healthPerItem", 2.0);
            this.healthItemCannotToCraft = this.plugin.getConfig().getStringList("healthItem.cannotToCraft");
            this.priority = this.plugin.getConfig().getStringList("priority");
            this.ignoredEnabled = this.plugin.getConfig().getBoolean("ignore.enabled", false);
            this.ignoredMustDifference = this.plugin.getConfig().getBoolean("ignore.must_difference", false);
            this.ignoredCause = new ArrayList<String>();
            this.ignoredCauseExclude = new ArrayList<String>();
            List ignoredCauseList = this.plugin.getConfig().getStringList("ignore.cause");
            for (Object cause : ignoredCauseList) {
                String[] parts = ((String)cause).split("::");
                if (parts.length > 2) {
                    this.plugin.getLogger().warning("Invalid cause format: " + (String)cause);
                    continue;
                }
                String string = parts[0].trim();
                if (parts.length == 2 && parts[1].trim().equals("EXCLUDE")) {
                    this.ignoredCauseExclude.add(string);
                    continue;
                }
                this.ignoredCause.add(string);
            }
            this.ignoredDayEnabled = this.plugin.getConfig().getBoolean("ignore.day.enabled", false);
            this.ignoredDayMustDifference = this.plugin.getConfig().getBoolean("ignore.day.must_difference", false);
            this.ignoredDayDeActiveIncreaseCause = this.plugin.getConfig().getBoolean("ignore.day.deActiveIncrease", false);
            this.ignoredDayDeActiveDecreaseCause = this.plugin.getConfig().getBoolean("ignore.day.deActiveDecrease", false);
            this.ignoredDayDeActiveIncreaseDay = this.plugin.getConfig().getBoolean("ignore.day.deActiveIncreaseDay", false);
            this.ignoredDayDeActiveDecreaseDay = this.plugin.getConfig().getBoolean("ignore.day.deActiveDecreaseDay", false);
            this.ignoredDayType = this.plugin.getConfig().getString("ignore.day.type", "minecraft");
            this.ignoredDays = this.plugin.getConfig().getIntegerList("ignore.day.days");
            this.ignoredDayCause = new ArrayList<String>();
            this.ignoredDayCauseExclude = new ArrayList<String>();
            List ignoredDayCauseList = this.plugin.getConfig().getStringList("ignore.day.cause");
            for (String cause : ignoredDayCauseList) {
                String[] parts = cause.split("::");
                if (parts.length > 2) {
                    this.plugin.getLogger().warning("Invalid cause format: " + cause);
                    continue;
                }
                String string = parts[0].trim();
                if (parts.length == 2 && parts[1].trim().equals("EXCLUDE")) {
                    this.ignoredDayCauseExclude.add(string);
                    continue;
                }
                this.ignoredDayCause.add(string);
            }
            this.increaseEnabled = this.plugin.getConfig().getBoolean("increase.enabled", true);
            this.increaseMustDifference = this.plugin.getConfig().getBoolean("increase.must_difference", true);
            if (this.increaseCause != null) {
                this.increaseCause.clear();
            }
            if (this.increaseCauseName != null) {
                this.increaseCauseName.clear();
            }
            this.increaseCauseName = new ArrayList<String>();
            this.increaseCause = new HashMap<String, Integer>();
            this.increaseCauseExclude = new ArrayList<String>();
            List increaseCauseList = this.plugin.getConfig().getStringList("increase.cause");
            for (Object cause : increaseCauseList) {
                String[] parts = ((String)cause).split("::");
                if (parts.length != 2) {
                    this.plugin.getLogger().warning("Invalid cause format: " + (String)cause);
                    continue;
                }
                String string = parts[0].trim();
                if (!parts[1].trim().equals("EXCLUDE")) {
                    int causeAmount;
                    block41: {
                        try {
                            causeAmount = Integer.parseInt(parts[1].trim());
                            if (causeAmount >= 0) break block41;
                            causeAmount = 0;
                        }
                        catch (NumberFormatException e) {
                            this.plugin.getLogger().warning("Invalid amount in cause: " + (String)cause);
                            continue;
                        }
                    }
                    this.increaseCauseName.add(string);
                    this.increaseCause.put(string, causeAmount);
                    continue;
                }
                this.increaseCauseExclude.add(string);
            }
            this.increaseDayEnabled = this.plugin.getConfig().getBoolean("increase.day.enabled", false);
            this.increaseDayMustDifference = this.plugin.getConfig().getBoolean("increase.day.must_difference", false);
            this.increaseDayDeActiveIgnoreCause = this.plugin.getConfig().getBoolean("increase.day.deActiveIgnore", false);
            this.increaseDayDeActiveDecreaseCause = this.plugin.getConfig().getBoolean("increase.day.deActiveDecrease", false);
            this.increaseDayDeActiveIgnoreDay = this.plugin.getConfig().getBoolean("increase.day.deActiveIgnoreDay", false);
            this.increaseDayDeActiveDecreaseDay = this.plugin.getConfig().getBoolean("increase.day.deActiveDecreaseDay", false);
            this.increaseDayType = this.plugin.getConfig().getString("increase.day.type", "minecraft");
            this.increaseDays = this.plugin.getConfig().getIntegerList("increase.day.days");
            if (this.increaseDayCause != null) {
                this.increaseDayCause.clear();
            }
            if (this.increaseDayCauseName != null) {
                this.increaseDayCauseName.clear();
            }
            this.increaseDayCauseName = new ArrayList<String>();
            this.increaseDayCause = new HashMap<String, Integer>();
            this.increaseDayCauseExclude = new ArrayList<String>();
            List increaseDayCauseList = this.plugin.getConfig().getStringList("increase.day.cause");
            for (Object cause : increaseDayCauseList) {
                String[] parts = ((String)cause).split("::");
                if (parts.length != 2) {
                    this.plugin.getLogger().warning("Invalid cause format: " + (String)cause);
                    continue;
                }
                String string = parts[0].trim();
                if (!parts[1].trim().equals("EXCLUDE")) {
                    int causeAmount;
                    block42: {
                        try {
                            causeAmount = Integer.parseInt(parts[1].trim());
                            if (causeAmount >= 0) break block42;
                            causeAmount = 0;
                        }
                        catch (NumberFormatException e) {
                            this.plugin.getLogger().warning("Invalid amount in cause: " + (String)cause);
                            continue;
                        }
                    }
                    this.increaseDayCauseName.add(string);
                    this.increaseDayCause.put(string, causeAmount);
                    continue;
                }
                this.increaseDayCauseExclude.add(string);
            }
            this.decreaseEnabled = this.plugin.getConfig().getBoolean("decrease.enabled", false);
            this.decreaseMustDifference = this.plugin.getConfig().getBoolean("decrease.must_difference", false);
            this.decreaseDebt = this.plugin.getConfig().getBoolean("decrease.debt", false);
            if (this.decreaseCause != null) {
                this.decreaseCause.clear();
            }
            if (this.decreaseCauseName != null) {
                this.decreaseCauseName.clear();
            }
            this.decreaseCauseName = new ArrayList<String>();
            this.decreaseCause = new HashMap<String, Integer>();
            this.decreaseCauseExclude = new ArrayList<String>();
            List decreaseCauseList = this.plugin.getConfig().getStringList("decrease.cause");
            for (String cause : decreaseCauseList) {
                String[] parts = cause.split("::");
                if (parts.length != 2) {
                    this.plugin.getLogger().warning("Invalid cause format: " + cause);
                }
                String string = parts[0];
                if (!parts[1].trim().equals("EXCLUDE")) {
                    int causeAmount;
                    block43: {
                        try {
                            causeAmount = Integer.parseInt(parts[1]);
                            if (causeAmount >= 0) break block43;
                            causeAmount = 0;
                        }
                        catch (NumberFormatException e) {
                            this.plugin.getLogger().warning("Invalid amount in cause: " + cause);
                            continue;
                        }
                    }
                    this.decreaseCauseName.add(string);
                    this.decreaseCause.put(string, causeAmount);
                    continue;
                }
                this.decreaseCauseExclude.add(string);
            }
            this.decreaseDayEnabled = this.plugin.getConfig().getBoolean("decrease.day.enabled", false);
            this.decreaseDayMustDifference = this.plugin.getConfig().getBoolean("decrease.day.must_difference", false);
            this.decreaseDayDeActiveIgnoreCause = this.plugin.getConfig().getBoolean("decrease.day.deActiveIgnore", false);
            this.decreaseDayDeActiveIncreaseCause = this.plugin.getConfig().getBoolean("decrease.day.deActiveIncrease", false);
            this.decreaseDayDeActiveIgnoreDay = this.plugin.getConfig().getBoolean("decrease.day.deActiveIgnoreDay", false);
            this.decreaseDayDeActiveIncreaseDay = this.plugin.getConfig().getBoolean("decrease.day.deActiveIncreaseDay", false);
            this.decreaseDayType = this.plugin.getConfig().getString("decrease.day.type", "minecraft");
            this.decreaseDays = this.plugin.getConfig().getIntegerList("decrease.day.days");
            if (this.decreaseDayCause != null) {
                this.decreaseDayCause.clear();
            }
            if (this.decreaseDayCauseName != null) {
                this.decreaseDayCauseName.clear();
            }
            this.decreaseDayCauseName = new ArrayList<String>();
            this.decreaseDayCause = new HashMap<String, Integer>();
            this.decreaseDayCauseExclude = new ArrayList<String>();
            List decreaseDayCauseList = this.plugin.getConfig().getStringList("decrease.day.cause");
            for (String cause : decreaseDayCauseList) {
                String[] parts = cause.split("::");
                if (parts.length != 2) {
                    this.plugin.getLogger().warning("Invalid cause format: " + cause);
                    continue;
                }
                String string = parts[0];
                if (!parts[1].trim().equals("EXCLUDE")) {
                    int causeAmount;
                    block44: {
                        try {
                            causeAmount = Integer.parseInt(parts[1]);
                            if (causeAmount >= 0) break block44;
                            causeAmount = 0;
                        }
                        catch (NumberFormatException e) {
                            this.plugin.getLogger().warning("Invalid amount in cause: " + cause);
                            continue;
                        }
                    }
                    this.decreaseDayCauseName.add(string);
                    this.decreaseDayCause.put(string, causeAmount);
                    continue;
                }
                this.decreaseDayCauseExclude.add(string);
            }
            this.seasonEnabled = this.plugin.getConfig().getBoolean("season.enabled", false);
            this.seasonType = this.plugin.getConfig().getString("season.type", "real");
            this.seasonDay = this.plugin.getConfig().getInt("season.day", 30);
            this.resetWorldDay = this.plugin.getConfig().getBoolean("season.resetWorldDay", false);
            this.permissionAllPlayer.put("reload", this.plugin.getConfig().getBoolean("permissionsAllPlayer.reload", false));
            this.permissionAllPlayer.put("setConfig", this.plugin.getConfig().getBoolean("permissionsAllPlayer.setConfig", false));
            this.permissionAllPlayer.put("setMaxHealth", this.plugin.getConfig().getBoolean("permissionsAllPlayer.setMaxHealth", false));
            this.permissionAllPlayer.put("viewHealth", this.plugin.getConfig().getBoolean("permissionsAllPlayer.viewHealth", false));
            this.permissionAllPlayer.put("viewDeathData", this.plugin.getConfig().getBoolean("permissionsAllPlayer.viewDeathData", true));
            this.permissionAllPlayer.put("viewDebtData", this.plugin.getConfig().getBoolean("permissionsAllPlayer.viewDebtData", true));
            this.permissionAllPlayer.put("resetHealth", this.plugin.getConfig().getBoolean("permissionsAllPlayer.resetHealth", false));
            this.permissionAllPlayer.put("matchHealth", this.plugin.getConfig().getBoolean("permissionsAllPlayer.matchHealth", false));
            this.permissionAllPlayer.put("removeDeathData", this.plugin.getConfig().getBoolean("permissionsAllPlayer.removeDeathData", false));
            this.permissionAllPlayer.put("removeDebtData", this.plugin.getConfig().getBoolean("permissionsAllPlayer.removeDebtData", false));
            this.permissionAllPlayer.put("transferHealth", this.plugin.getConfig().getBoolean("permissionsAllPlayer.transferHealth", true));
            this.permissionAllPlayer.put("withdrawHealth", this.plugin.getConfig().getBoolean("permissionsAllPlayer.withdrawHealth", true));
            this.permissionAllPlayer.put("help", this.plugin.getConfig().getBoolean("permissionsAllPlayer.help", true));
            this.defaultDeathMessageEnabled = this.plugin.getConfig().getBoolean("notifications.defaultDeathMessage", false);
            this.notificationPlayerMaxHealth = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.maxHealth")).replace("&", "\u00a7");
            this.notificationPlayerMinHealth = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.minHealth")).replace("&", "\u00a7");
            this.notificationPlayerBanReason = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.banReason")).replace("&", "\u00a7");
            this.notificationPlayerKicked = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.kicked")).replace("&", "\u00a7");
            this.notificationPlayerIgnored = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.ignored")).replace("&", "\u00a7");
            this.notificationPlayerIgnoredSameWay = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.ignoredSameWay")).replace("&", "\u00a7");
            this.notificationPlayerIncrease = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.increased")).replace("&", "\u00a7");
            this.notificationPlayerIncreaseSameWay = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.increaseSameWay")).replace("&", "\u00a7");
            this.notificationPlayerDecrease = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.decreased")).replace("&", "\u00a7");
            this.notificationPlayerDecreaseSameWay = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.decreaseSameWay")).replace("&", "\u00a7");
            this.notificationPlayerDebtPaidOff = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.debtPaidOff")).replace("&", "\u00a7");
            this.notificationPlayerDebtReduced = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.debtReduced")).replace("&", "\u00a7");
            this.notificationPlayerDebtAdded = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.debtAdded")).replace("&", "\u00a7");
            this.ignoredDayWarning = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.warning.ignoredDay")).replace("&", "\u00a7");
            this.increaseDayWarning = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.warning.increaseDay")).replace("&", "\u00a7");
            this.decreaseDayWarning = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.warning.decreaseDay")).replace("&", "\u00a7");
            this.seasonChangeWarning = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.player.warning.seasonChange")).replace("&", "\u00a7");
            this.notificationLogServerMaxHealth = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.logServer.maxHealth")).replace("&", "\u00a7");
            this.notificationLogServerMinHealth = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.logServer.minHealth")).replace("&", "\u00a7");
            this.notificationLogServerIncrease = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.logServer.increased")).replace("&", "\u00a7");
            this.notificationLogServerDecrease = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.logServer.decreased")).replace("&", "\u00a7");
            this.notificationLogServerBanReason = Objects.requireNonNull(this.plugin.getConfig().getString("notifications.logServer.banReason")).replace("&", "\u00a7");
            this.cachedConfigPaths = null;
            this.validateConfig();
        }
        catch (Exception e) {
            Bukkit.getServer().getConsoleSender().sendMessage("\u00a7cFailed to load config:\u00a7a " + e.getMessage());
        }
    }

    private void validateConfig() throws Exception {
        if (this.checkDayPeriod <= 0) {
            throw new Exception("checkDayPeriod should be greater than 0:\u00a7e " + this.checkDayPeriod);
        }
        if (!this.invalidWorlds.isEmpty()) {
            throw new Exception("The following worlds are configured but don't exist:\u00a7e " + String.join((CharSequence)", ", this.invalidWorlds));
        }
        if (!this.tickErrorWorlds.isEmpty()) {
            throw new Exception("The following worlds are configured but have an invalid tick rate:\u00a7e " + String.join((CharSequence)", ", this.tickErrorWorlds));
        }
        if (this.hpStart <= 0) {
            throw new Exception("hp.start should be greater than 0:\u00a7e " + this.hpStart);
        }
        if (this.hpMaxEnabled && this.hpMaxAmount <= 0) {
            throw new Exception("hp.maxHP.amount should be greater than 0:\u00a7e " + this.hpMaxAmount);
        }
        if (this.hpMinEnabled && this.hpMinAmount <= 0) {
            throw new Exception("hp.minHP.amount should be greater than 0:\u00a7e " + this.hpMinAmount);
        }
        if (this.hpMinEnabled && this.hpStart < this.hpMinAmount || this.hpMaxEnabled && this.hpStart > this.hpMaxAmount) {
            throw new Exception("hp.start should be between hp.minHP.amount and hp.maxHP.amount:\u00a7e " + this.hpStart);
        }
        if (!this.hpMinEnabled && this.hpMinBanTime <= 0) {
            throw new Exception("hp.minHP.banTime should be greater than 0:\u00a7e " + this.hpMinBanTime);
        }
        if (this.healthItemHealthPerItem <= 0.0) {
            throw new Exception("healthItem.healthPerItem should be greater than 0:\u00a7e " + this.healthItemHealthPerItem);
        }
        if (!(this.priority.contains("IGNORE") || this.priority.contains("INCREASE") || this.priority.contains("DECREASE"))) {
            throw new Exception("priority should contain IGNORE, INCREASE or DECREASE:\u00a7e " + String.valueOf(this.priority));
        }
        if (this.ignoredEnabled && this.ignoredCause.isEmpty()) {
            throw new Exception("ignore.cause should not be empty.");
        }
        if (this.ignoredDayEnabled && !this.ignoredDayType.equals("real") && !this.ignoredDayType.equals("minecraft")) {
            throw new Exception("ignore.day.type should be real or minecraft:\u00a7e " + this.ignoredDayType);
        }
        if (this.ignoredDayEnabled && this.ignoredDays.isEmpty()) {
            throw new Exception("ignore.day.days should not be empty.");
        }
        if (this.ignoredDayEnabled && this.ignoredDayCause.isEmpty()) {
            throw new Exception("ignore.day.cause should not be empty.");
        }
        if (this.increaseEnabled && this.increaseCause.isEmpty()) {
            throw new Exception("increase.cause should not be empty.");
        }
        if (this.increaseDayEnabled && !this.increaseDayType.equals("real") && !this.increaseDayType.equals("minecraft")) {
            throw new Exception("increase.day.type should be real or minecraft:\u00a7e " + this.increaseDayType);
        }
        if (this.increaseDayEnabled && this.increaseDays.isEmpty()) {
            throw new Exception("increase.day.days should not be empty.");
        }
        if (this.increaseDayEnabled && this.increaseDayCause.isEmpty()) {
            throw new Exception("increase.day.cause should not be empty.");
        }
        if (this.decreaseEnabled && this.decreaseCause.isEmpty()) {
            throw new Exception("decrease.cause should not be empty.");
        }
        if (this.decreaseDayEnabled && !this.decreaseDayType.equals("real") && !this.decreaseDayType.equals("minecraft")) {
            throw new Exception("decrease.day.type should be real or minecraft:\u00a7e " + this.decreaseDayType);
        }
        if (this.decreaseDayEnabled && this.decreaseDays.isEmpty()) {
            throw new Exception("decrease.day.days should not be empty.");
        }
        if (this.decreaseDayEnabled && this.decreaseDayCause.isEmpty()) {
            throw new Exception("decrease.day.cause should not be empty.");
        }
        if (this.ignoredDayDeActiveIncreaseCause && this.increaseDayDeActiveIgnoreCause) {
            throw new Exception("ignore.day.deActiveIncrease and increase.day.deActiveIgnore should not be true at the same time.");
        }
        if (this.ignoredDayDeActiveDecreaseCause && this.decreaseDayDeActiveIgnoreCause) {
            throw new Exception("ignore.day.deActiveDecrease and decrease.day.deActiveIgnore should not be true at the same time.");
        }
        if (this.increaseDayDeActiveDecreaseCause && this.decreaseDayDeActiveIncreaseCause) {
            throw new Exception("increase.day.deActiveDecrease and decrease.day.deActiveIncrease should not be true at the same time.");
        }
        if (this.ignoredDayDeActiveIncreaseDay && this.increaseDayDeActiveIgnoreDay) {
            throw new Exception("ignore.day.deActiveIncreaseDay and increase.day.deActiveIgnoreDay should not be true at the same time.");
        }
        if (this.ignoredDayDeActiveDecreaseDay && this.decreaseDayDeActiveIgnoreDay) {
            throw new Exception("ignore.day.deActiveDecreaseDay and decrease.day.deActiveIgnoreDay should not be true at the same time.");
        }
        if (this.increaseDayDeActiveDecreaseDay && this.decreaseDayDeActiveIncreaseDay) {
            throw new Exception("increase.day.deActiveDecreaseDay and decrease.day.deActiveIncreaseDay should not be true at the same time.");
        }
        if (this.resetWorldDay && !this.seasonEnabled) {
            throw new Exception("season.enabled should be true when resetWorldDay is true:\u00a7e false");
        }
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public int getFirstTimeSetup() {
        return this.firstTimeSetup;
    }

    public void setFirstTimeSetup(int firstTimeSetup) {
        this.plugin.getConfig().set("firstTimeSetup", (Object)firstTimeSetup);
        this.firstTimeSetup = firstTimeSetup;
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
        this.loadConfig();
    }

    public long getCheckDayPeriod() {
        return this.checkDayPeriod;
    }

    public List<World> getConfiguredWorlds() {
        return new ArrayList<World>(this.worldsList.keySet());
    }

    public long getTicksPerDay(World worldName) {
        return this.worldsList.get(worldName);
    }

    public int getHPStart() {
        return this.hpStart;
    }

    public boolean isMaxHPEnabled() {
        return this.hpMaxEnabled;
    }

    public int getMaxHPAmount() {
        return this.hpMaxAmount;
    }

    public boolean isDropHealthItem() {
        return this.dropHealthItem;
    }

    public boolean isMinHPEnabled() {
        return this.hpMinEnabled;
    }

    public int getMinHPAmount() {
        return this.hpMinAmount;
    }

    public int getMinHPBanTime() {
        return this.hpMinBanTime;
    }

    public int getHPAfterBan() {
        return this.hpAfterBan;
    }

    public boolean isMaxHPEnabledAndMoreThanMax(double newMaxHealth) {
        return this.hpMaxEnabled && newMaxHealth > (double)this.hpMaxAmount;
    }

    public boolean isMinHPEnabledAndLessThanMin(double newMaxHealth) {
        return this.hpMinEnabled && newMaxHealth < (double)this.hpMinAmount;
    }

    public boolean isMinHPDisabledAndSameOrLessThanZero(double newMaxHealth) {
        return !this.hpMinEnabled && newMaxHealth <= 0.0;
    }

    public String getHealthItemMaterial() {
        return this.healthItemMaterial;
    }

    public String getHealthItemName() {
        return this.healthItemName;
    }

    public List<String> getHealthItemLore() {
        return this.healthItemLore;
    }

    public double getHealthItemHealthPerItem() {
        return this.healthItemHealthPerItem;
    }

    public List<String> getHealthItemCannotToCraft() {
        return this.healthItemCannotToCraft;
    }

    public boolean isItemCannotCraftUsingHealthItem(String item) {
        return this.healthItemCannotToCraft.contains(item);
    }

    public List<String> getPriority() {
        return this.priority;
    }

    public boolean isIgnoredEnabled() {
        return this.ignoredEnabled;
    }

    public boolean isIgnoredMustDifference() {
        return this.ignoredMustDifference;
    }

    public List<String> getIgnoredCause() {
        return this.ignoredCause;
    }

    public List<String> getIgnoredCauseExclude() {
        return this.ignoredCauseExclude;
    }

    public boolean isIgnoredDayEnabled() {
        return this.ignoredDayEnabled;
    }

    public boolean isIgnoredDayMustDifference() {
        return this.ignoredDayMustDifference;
    }

    public boolean isIgnoredDayDeActiveIncreaseCause() {
        return this.ignoredDayDeActiveIncreaseCause;
    }

    public boolean isIgnoredDayDeActiveDecreaseCause() {
        return this.ignoredDayDeActiveDecreaseCause;
    }

    public boolean isIgnoredDayDeActiveIncreaseDay() {
        return this.ignoredDayDeActiveIncreaseDay;
    }

    public boolean isIgnoredDayDeActiveDecreaseDay() {
        return this.ignoredDayDeActiveDecreaseDay;
    }

    public String getIgnoredDayType() {
        return this.ignoredDayType;
    }

    public List<Integer> getIgnoredDays() {
        return this.ignoredDays;
    }

    public List<String> getIgnoredDayCause() {
        return this.ignoredDayCause;
    }

    public List<String> getIgnoredDayCauseExclude() {
        return this.ignoredDayCauseExclude;
    }

    public boolean isIncreaseEnabled() {
        return this.increaseEnabled;
    }

    public boolean isIncreaseMustDifference() {
        return this.increaseMustDifference;
    }

    public Map<String, Integer> getIncreaseCause() {
        return this.increaseCause;
    }

    public boolean isIncreaseCauseValid(String cause) {
        return this.increaseCause.containsKey(cause) && !this.increaseCauseExclude.contains(cause);
    }

    public List<String> getIncreaseCauseName() {
        return this.increaseCauseName;
    }

    public List<String> getIncreaseCauseExclude() {
        return this.increaseCauseExclude;
    }

    public Integer getIncreaseCauseAmount(String cause) {
        return this.increaseCause.get(cause);
    }

    public boolean isIncreaseDayEnabled() {
        return this.increaseDayEnabled;
    }

    public boolean isIncreaseDayMustDifference() {
        return this.increaseDayMustDifference;
    }

    public boolean isIncreaseDayDeActiveIgnoredCause() {
        return this.increaseDayDeActiveIgnoreCause;
    }

    public boolean isIncreaseDayDeActiveDecreaseCause() {
        return this.increaseDayDeActiveDecreaseCause;
    }

    public boolean isIncreaseDayDeActiveIgnoredDay() {
        return this.increaseDayDeActiveIgnoreDay;
    }

    public boolean isIncreaseDayDeActiveDecreaseDay() {
        return this.increaseDayDeActiveDecreaseDay;
    }

    public String getIncreaseDayType() {
        return this.increaseDayType;
    }

    public List<Integer> getIncreaseDays() {
        return this.increaseDays;
    }

    public Map<String, Integer> getIncreaseDayCause() {
        return this.increaseDayCause;
    }

    public boolean isIncreaseDayCauseValid(String cause) {
        return this.increaseDayCause.containsKey(cause) && !this.increaseDayCauseExclude.contains(cause);
    }

    public List<String> getIncreaseDayCauseExclude() {
        return this.increaseDayCauseExclude;
    }

    public List<String> getIncreaseDayCauseName() {
        return this.increaseDayCauseName;
    }

    public Integer getIncreaseDayCauseAmount(String cause) {
        return this.increaseDayCause.get(cause);
    }

    public boolean isDecreaseEnabled() {
        return this.decreaseEnabled;
    }

    public boolean isDecreaseMustDifference() {
        return this.decreaseMustDifference;
    }

    public boolean isDecreaseDebt() {
        return this.decreaseDebt;
    }

    public Map<String, Integer> getDecreaseCause() {
        return this.decreaseCause;
    }

    public boolean isDecreaseCauseValid(String cause) {
        return this.decreaseCause.containsKey(cause) && !this.decreaseCauseExclude.contains(cause);
    }

    public List<String> getDecreaseCauseName() {
        return this.decreaseCauseName;
    }

    public List<String> getDecreaseCauseExclude() {
        return this.decreaseCauseExclude;
    }

    public Integer getDecreaseCauseAmount(String cause) {
        return this.decreaseCause.get(cause);
    }

    public boolean isDecreaseDayEnabled() {
        return this.decreaseDayEnabled;
    }

    public boolean isDecreaseDayMustDifference() {
        return this.decreaseDayMustDifference;
    }

    public boolean isDecreaseDayDeActiveIgnoredCause() {
        return this.decreaseDayDeActiveIgnoreCause;
    }

    public boolean isDecreaseDayDeActiveIncreaseCause() {
        return this.decreaseDayDeActiveIncreaseCause;
    }

    public boolean isDecreaseDayDeActiveIgnoredDay() {
        return this.decreaseDayDeActiveIgnoreDay;
    }

    public boolean isDecreaseDayDeActiveIncreaseDay() {
        return this.decreaseDayDeActiveIncreaseDay;
    }

    public String getDecreaseDayType() {
        return this.decreaseDayType;
    }

    public List<Integer> getDecreaseDays() {
        return this.decreaseDays;
    }

    public Map<String, Integer> getDecreaseDayCause() {
        return this.decreaseDayCause;
    }

    public boolean isDecreaseDayCauseValid(String cause) {
        return this.decreaseDayCause.containsKey(cause) && !this.decreaseDayCauseExclude.contains(cause);
    }

    public List<String> getDecreaseDayCauseExclude() {
        return this.decreaseDayCauseExclude;
    }

    public List<String> getDecreaseDayCauseName() {
        return this.decreaseDayCauseName;
    }

    public Integer getDecreaseDayCauseAmount(String cause) {
        return this.decreaseDayCause.get(cause);
    }

    public boolean isIgnoredCause(String deathCause) {
        return this.ignoredEnabled && (this.ignoredCause.contains("ALL") || this.ignoredCause.contains(deathCause)) && !this.ignoredCauseExclude.contains(deathCause);
    }

    public boolean isIncreaseCause(String deathCause) {
        return this.increaseEnabled && (this.isIncreaseCauseValid("ALL") || this.isIncreaseCauseValid(deathCause)) && !this.increaseCauseExclude.contains(deathCause);
    }

    public boolean isDecreaseCause(String deathCause) {
        return this.decreaseEnabled && (this.isDecreaseCauseValid("ALL") || this.isDecreaseCauseValid(deathCause)) && !this.decreaseCauseExclude.contains(deathCause);
    }

    public boolean isSeasonEnabled() {
        return this.seasonEnabled;
    }

    public String getSeasonType() {
        return this.seasonType;
    }

    public int getSeasonDay() {
        return this.seasonDay;
    }

    public boolean isResetWorldDay() {
        return this.resetWorldDay;
    }

    public boolean canUse(CommandSender sender, String perm) {
        if (!this.permissionAllPlayer.containsKey(perm)) {
            this.plugin.getLogger().warning("Unknown permission key used in canUse(): " + perm);
        }
        if (this.permissionAllPlayer.getOrDefault(perm, false).booleanValue()) {
            return true;
        }
        return sender.hasPermission(PERM_PREFIX + perm) || sender.hasPermission("dp.admin");
    }

    public boolean isDefaultDeathMessageEnabled() {
        return this.defaultDeathMessageEnabled;
    }

    public String getNotificationPlayerMaxHealth() {
        return this.notificationPlayerMaxHealth;
    }

    public String getNotificationPlayerMinHealth() {
        return this.notificationPlayerMinHealth;
    }

    public String getNotificationPlayerBanReason() {
        return this.notificationPlayerBanReason;
    }

    public String getNotificationPlayerKicked() {
        return this.notificationPlayerKicked;
    }

    public String getNotificationPlayerIgnored() {
        return this.notificationPlayerIgnored;
    }

    public String getNotificationPlayerIgnoredSameWay() {
        return this.notificationPlayerIgnoredSameWay;
    }

    public String getNotificationPlayerIncrease() {
        return this.notificationPlayerIncrease;
    }

    public String getNotificationPlayerIncreaseSameWay() {
        return this.notificationPlayerIncreaseSameWay;
    }

    public String getNotificationPlayerDecrease() {
        return this.notificationPlayerDecrease;
    }

    public String getNotificationPlayerDecreaseSameWay() {
        return this.notificationPlayerDecreaseSameWay;
    }

    public String getNotificationPlayerDebtPaidOff() {
        return this.notificationPlayerDebtPaidOff;
    }

    public String getNotificationPlayerDebtReduced() {
        return this.notificationPlayerDebtReduced;
    }

    public String getNotificationPlayerDebtAdded() {
        return this.notificationPlayerDebtAdded;
    }

    public String getIgnoredDayWarning() {
        return this.ignoredDayWarning;
    }

    public String getIncreaseDayWarning() {
        return this.increaseDayWarning;
    }

    public String getDecreaseDayWarning() {
        return this.decreaseDayWarning;
    }

    public String getSeasonChangeWarning() {
        return this.seasonChangeWarning;
    }

    public String getNotificationConsoleMaxHealth() {
        return this.notificationLogServerMaxHealth;
    }

    public String getNotificationConsoleMinHealth() {
        return this.notificationLogServerMinHealth;
    }

    public String getNotificationConsoleIncrease() {
        return this.notificationLogServerIncrease;
    }

    public String getNotificationConsoleDecrease() {
        return this.notificationLogServerDecrease;
    }

    public String getNotificationConsoleBanReason() {
        return this.notificationLogServerBanReason;
    }

    public List<String> getAllConfigPaths() {
        if (this.cachedConfigPaths == null) {
            this.cachedConfigPaths = this.getConfigPaths(this.plugin.getConfig().getValues(true), "");
        }
        return this.cachedConfigPaths;
    }

    private List<String> getConfigPaths(Map<String, Object> map, String prefix) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Map) {
                Map subMap = (Map)val;
                paths.addAll(this.getConfigPaths(subMap, prefix + key + "."));
                continue;
            }
            if (this.plugin.getConfig().isConfigurationSection(prefix + key)) continue;
            paths.add(prefix + key);
        }
        return paths;
    }

    public boolean isValidUUID(String str) {
        try {
            UUID.fromString(str);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

