/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Listeners;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.HealthManager;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerDeathListener
implements Listener {
    private final DeathPulse plugin;

    public PlayerDeathListener(DeathPulse plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity().getPlayer();
        Player killer = event.getEntity().getKiller();
        if (player == null) {
            return;
        }
        World world = player.getWorld();
        UUID playerUUID = player.getUniqueId();
        String deathCause = Objects.requireNonNull(player.getLastDamageCause()).getCause().name();
        String season = "Season" + this.plugin.getDayManager().getSeason(world, "season");
        if (killer != null) {
            switch (deathCause) {
                case "ENTITY_ATTACK": {
                    String string = "PLAYER_ATTACK";
                    break;
                }
                case "ENTITY_SWEEP_ATTACK": {
                    String string = "PLAYER_SWEEP_ATTACK";
                    break;
                }
                case "PROJECTILE": {
                    String string = "PLAYER_PROJECTILE";
                    break;
                }
                case "ENTITY_EXPLOSION": {
                    String string = "PLAYER_EXPLOSION";
                    break;
                }
                default: {
                    String string = deathCause = deathCause;
                }
            }
        }
        if (!this.plugin.getConfigManager().isDefaultDeathMessageEnabled()) {
            this.plugin.sendColoredMessageToConsole(event.getDeathMessage());
            event.setDeathMessage(null);
        }
        boolean status = false;
        for (String deathType : this.plugin.getConfigManager().getPriority()) {
            if (deathType.equalsIgnoreCase("IGNORE")) {
                status = this.runIgnored(player, playerUUID, world, season, deathCause);
            } else if (deathType.equalsIgnoreCase("INCREASE")) {
                status = this.runIncrease(player, playerUUID, world, season, deathCause);
            } else if (deathType.equalsIgnoreCase("DECREASE")) {
                status = this.runDecrease(player, playerUUID, world, season, deathCause);
            }
            if (!status) continue;
            break;
        }
    }

    public boolean isIgnoredDay(World world, String deathCause) {
        return this.plugin.getConfigManager().isIgnoredDayEnabled() && this.plugin.getDayManager().isMultipleDay(world, "ignored") && (this.plugin.getConfigManager().getIgnoredDayCause().contains("ALL") || this.plugin.getConfigManager().getIgnoredDayCause().contains(deathCause)) && !this.plugin.getConfigManager().getIgnoredDayCauseExclude().contains(deathCause);
    }

    private boolean isIncreaseDay(World world, String deathCause) {
        return this.plugin.getConfigManager().isIncreaseDayEnabled() && this.plugin.getDayManager().isMultipleDay(world, "increase") && (this.plugin.getConfigManager().isIncreaseDayCauseValid("ALL") || this.plugin.getConfigManager().isIncreaseDayCauseValid(deathCause)) && !this.plugin.getConfigManager().getIncreaseDayCauseExclude().contains(deathCause);
    }

    private boolean isDecreaseDay(World world, String deathCause) {
        return this.plugin.getConfigManager().isDecreaseDayEnabled() && this.plugin.getDayManager().isMultipleDay(world, "decrease") && (this.plugin.getConfigManager().isDecreaseDayCauseValid("ALL") || this.plugin.getConfigManager().isDecreaseDayCauseValid(deathCause)) && !this.plugin.getConfigManager().getDecreaseDayCauseExclude().contains(deathCause);
    }

    private boolean runIgnored(Player player, UUID playerUUID, World world, String season, String deathCause) {
        if (this.plugin.getDayManager().isMultipleDay(world, "increase") && this.plugin.getConfigManager().isIncreaseDayDeActiveIgnoredCause()) {
            return false;
        }
        if (this.plugin.getDayManager().isMultipleDay(world, "decrease") && this.plugin.getConfigManager().isDecreaseDayDeActiveIgnoredCause()) {
            return false;
        }
        if (this.plugin.getConfigManager().isIgnoredCause(deathCause) || this.isIgnoredDay(world, deathCause)) {
            String msgPlayer;
            String deathCauseMessage = deathCause + "[" + season + "][Ignored]";
            boolean isIgnoredDay = false;
            if (this.isIgnoredDay(world, deathCause)) {
                if (this.plugin.getDayManager().isMultipleDay(world, "increase") && this.plugin.getConfigManager().isIncreaseDayDeActiveIgnoredDay()) {
                    return false;
                }
                if (this.plugin.getDayManager().isMultipleDay(world, "decrease") && this.plugin.getConfigManager().isDecreaseDayDeActiveIgnoredDay()) {
                    return false;
                }
                isIgnoredDay = true;
                int currentDay = this.plugin.getDayManager().getCurrentDay(world, this.plugin.getDayManager().getTypeDays("ignored"));
                String deathCounter = this.plugin.getConfigManager().isIgnoredDayMustDifference() ? "" : "_" + this.plugin.getDeathDataManager().getNextDeathCounter(playerUUID, currentDay);
                deathCauseMessage = "ignoredDay_" + currentDay + deathCounter + "(" + season + ")";
                deathCauseMessage = deathCause + "[" + deathCauseMessage + "]";
            }
            boolean isNewDeathType = true;
            if (isIgnoredDay) {
                if (this.plugin.getConfigManager().isIgnoredDayMustDifference()) {
                    isNewDeathType = this.plugin.getDeathDataManager().logDeath(playerUUID, deathCauseMessage);
                }
            } else if (this.plugin.getConfigManager().isIgnoredMustDifference()) {
                isNewDeathType = this.plugin.getDeathDataManager().logDeath(playerUUID, deathCauseMessage);
            }
            if (isNewDeathType) {
                msgPlayer = this.plugin.getConfigManager().getNotificationPlayerIgnored().replace("{cause}", deathCauseMessage);
                player.sendMessage(msgPlayer);
                return true;
            }
            msgPlayer = this.plugin.getConfigManager().getNotificationPlayerIgnoredSameWay();
            player.sendMessage(msgPlayer);
            return false;
        }
        return false;
    }

    private boolean runIncrease(Player player, UUID playerUUID, World world, String season, String deathCause) {
        if (this.plugin.getDayManager().isMultipleDay(world, "ignored") && this.plugin.getConfigManager().isIgnoredDayDeActiveIncreaseCause()) {
            return false;
        }
        if (this.plugin.getDayManager().isMultipleDay(world, "decrease") && this.plugin.getConfigManager().isDecreaseDayDeActiveIncreaseCause()) {
            return false;
        }
        if (this.plugin.getConfigManager().isIncreaseCause(deathCause) || this.isIncreaseDay(world, deathCause)) {
            int increaseAmount = this.plugin.getConfigManager().isIncreaseCauseValid(deathCause) ? this.plugin.getConfigManager().getIncreaseCauseAmount(deathCause).intValue() : this.plugin.getConfigManager().getIncreaseCauseAmount("ALL").intValue();
            String deathCauseMessage = deathCause + "[" + season + "][Increase]";
            boolean isIncreaseDay = false;
            if (this.isIncreaseDay(world, deathCause)) {
                if (this.plugin.getDayManager().isMultipleDay(world, "ignored") && this.plugin.getConfigManager().isIgnoredDayDeActiveIncreaseDay()) {
                    return false;
                }
                if (this.plugin.getDayManager().isMultipleDay(world, "decrease") && this.plugin.getConfigManager().isDecreaseDayDeActiveIncreaseDay()) {
                    return false;
                }
                isIncreaseDay = true;
                increaseAmount = this.plugin.getConfigManager().isIncreaseDayCauseValid(deathCause) ? this.plugin.getConfigManager().getIncreaseDayCauseAmount(deathCause).intValue() : this.plugin.getConfigManager().getIncreaseDayCauseAmount("ALL").intValue();
                int currentDay = this.plugin.getDayManager().getCurrentDay(world, this.plugin.getDayManager().getTypeDays("increase"));
                String deathCounter = this.plugin.getConfigManager().isIncreaseDayMustDifference() ? "" : "_" + this.plugin.getDeathDataManager().getNextDeathCounter(playerUUID, currentDay);
                deathCauseMessage = "increaseDay_" + currentDay + deathCounter + "(" + season + ")";
                deathCauseMessage = deathCause + "[" + deathCauseMessage + "]";
            }
            double newMaxHealth = HealthManager.getMaxHealth(player) + (double)increaseAmount;
            boolean isNewDeathType = true;
            if (isIncreaseDay) {
                if (this.plugin.getConfigManager().isIncreaseDayMustDifference()) {
                    isNewDeathType = this.plugin.getDeathDataManager().logDeath(playerUUID, deathCauseMessage);
                }
            } else if (this.plugin.getConfigManager().isIncreaseMustDifference()) {
                isNewDeathType = this.plugin.getDeathDataManager().logDeath(playerUUID, deathCauseMessage);
            }
            if (isNewDeathType) {
                if (this.plugin.getConfigManager().isDecreaseDebt() && this.plugin.getDebtDataManager().getDebt(playerUUID) > 0) {
                    int leftOver = this.plugin.getDebtDataManager().reduceDebt(playerUUID, increaseAmount);
                    newMaxHealth = HealthManager.getMaxHealth(player) + (double)leftOver;
                    if (leftOver > 0 || this.plugin.getDebtDataManager().getDebt(playerUUID) <= 0) {
                        player.sendMessage(this.plugin.getConfigManager().getNotificationPlayerDebtPaidOff().replace("{debtPaid}", "" + (increaseAmount - leftOver)));
                        increaseAmount = leftOver;
                    } else {
                        player.sendMessage(this.plugin.getConfigManager().getNotificationPlayerDebtReduced().replace("{debtPaid}", "" + increaseAmount).replace("{debtLeft}", "" + this.plugin.getDebtDataManager().getDebt(playerUUID)));
                        increaseAmount = 0;
                    }
                }
                String msgPlayer = this.plugin.getConfigManager().getNotificationPlayerIncrease().replace("{increase}", String.valueOf(increaseAmount)).replace("{cause}", deathCauseMessage);
                String msgServer = this.plugin.getConfigManager().getNotificationConsoleIncrease().replace("{name}", player.getName()).replace("{increase}", String.valueOf(increaseAmount)).replace("{cause}", deathCauseMessage);
                if (this.plugin.getConfigManager().isMaxHPEnabledAndMoreThanMax(newMaxHealth)) {
                    double excessHealth = newMaxHealth - (double)this.plugin.getConfigManager().getMaxHPAmount();
                    int healthItemsToDrop = (int)Math.floor(excessHealth / this.plugin.getConfigManager().getHealthItemHealthPerItem());
                    if (healthItemsToDrop > 0 && this.plugin.getConfigManager().isDropHealthItem()) {
                        ItemStack healthItem = this.plugin.getHealthItemManager().getHealthItem();
                        healthItem.setAmount(healthItemsToDrop);
                        player.getWorld().dropItemNaturally(player.getLocation(), healthItem);
                    }
                    newMaxHealth = this.plugin.getConfigManager().getMaxHPAmount();
                    msgPlayer = this.plugin.getConfigManager().getNotificationPlayerMaxHealth();
                    msgServer = this.plugin.getConfigManager().getNotificationConsoleMaxHealth();
                }
                HealthManager.setMaxHealth(newMaxHealth, player);
                player.sendMessage(msgPlayer);
                this.plugin.sendColoredMessageToConsole(msgServer);
                return true;
            }
            String msgPlayer = this.plugin.getConfigManager().getNotificationPlayerIncreaseSameWay();
            player.sendMessage(msgPlayer);
            return false;
        }
        return false;
    }

    private boolean runDecrease(Player player, UUID playerUUID, World world, String season, String deathCause) {
        if (this.plugin.getDayManager().isMultipleDay(world, "ignored") && this.plugin.getConfigManager().isIgnoredDayDeActiveDecreaseCause()) {
            return false;
        }
        if (this.plugin.getDayManager().isMultipleDay(world, "increase") && this.plugin.getConfigManager().isIncreaseDayDeActiveDecreaseCause()) {
            return false;
        }
        if (this.plugin.getConfigManager().isDecreaseCause(deathCause) || this.isDecreaseDay(world, deathCause)) {
            int decreaseAmount = this.plugin.getConfigManager().isDecreaseCauseValid(deathCause) ? this.plugin.getConfigManager().getDecreaseCauseAmount(deathCause).intValue() : this.plugin.getConfigManager().getDecreaseCauseAmount("ALL").intValue();
            String deathCauseMessage = deathCause + "[" + season + "][Decrease]";
            boolean isDecreaseDay = false;
            if (this.isDecreaseDay(world, deathCause)) {
                if (this.plugin.getDayManager().isMultipleDay(world, "ignored") && this.plugin.getConfigManager().isIgnoredDayDeActiveDecreaseDay()) {
                    return false;
                }
                if (this.plugin.getDayManager().isMultipleDay(world, "increase") && this.plugin.getConfigManager().isIncreaseDayDeActiveDecreaseDay()) {
                    return false;
                }
                isDecreaseDay = true;
                decreaseAmount = this.plugin.getConfigManager().isDecreaseDayCauseValid(deathCause) ? this.plugin.getConfigManager().getDecreaseDayCauseAmount(deathCause).intValue() : this.plugin.getConfigManager().getDecreaseDayCauseAmount("ALL").intValue();
                int currentDay = this.plugin.getDayManager().getCurrentDay(world, this.plugin.getDayManager().getTypeDays("decrease"));
                String deathCounter = this.plugin.getConfigManager().isDecreaseDayMustDifference() ? "" : "_" + this.plugin.getDeathDataManager().getNextDeathCounter(playerUUID, currentDay);
                deathCauseMessage = "decreaseDay_" + currentDay + deathCounter + "(" + season + ")";
                deathCauseMessage = deathCause + "[" + deathCauseMessage + "]";
            }
            double newMaxHealth = HealthManager.getMaxHealth(player) - (double)decreaseAmount;
            boolean isNewDeathType = true;
            if (isDecreaseDay) {
                if (this.plugin.getConfigManager().isDecreaseDayMustDifference()) {
                    isNewDeathType = this.plugin.getDeathDataManager().logDeath(playerUUID, deathCauseMessage);
                }
            } else if (this.plugin.getConfigManager().isDecreaseMustDifference()) {
                isNewDeathType = this.plugin.getDeathDataManager().logDeath(playerUUID, deathCauseMessage);
            }
            if (isNewDeathType) {
                String msgPlayer = this.plugin.getConfigManager().getNotificationPlayerDecrease().replace("{decrease}", String.valueOf(decreaseAmount)).replace("{cause}", deathCauseMessage);
                String msgServer = this.plugin.getConfigManager().getNotificationConsoleDecrease().replace("{name}", player.getName()).replace("{decrease}", String.valueOf(decreaseAmount)).replace("{cause}", deathCauseMessage);
                int debt = 0;
                if (this.plugin.getConfigManager().isMinHPEnabledAndLessThanMin(newMaxHealth)) {
                    if (this.plugin.getConfigManager().isDecreaseDebt()) {
                        if (newMaxHealth < 0.0) {
                            debt = (int)(-newMaxHealth + (double)this.plugin.getConfigManager().getMinHPAmount());
                        }
                        if (newMaxHealth >= 0.0) {
                            debt = (int)((double)this.plugin.getConfigManager().getMinHPAmount() - newMaxHealth);
                        }
                        if (debt > 0) {
                            player.sendMessage(this.plugin.getConfigManager().getNotificationPlayerDebtAdded().replace("{debtAdded}", "" + debt).replace("{debtLeft}", "" + this.plugin.getDebtDataManager().getDebt(playerUUID)));
                        }
                        this.plugin.getDebtDataManager().addDebt(playerUUID, debt);
                    }
                    newMaxHealth = this.plugin.getConfigManager().getMinHPAmount();
                    msgPlayer = this.plugin.getConfigManager().getNotificationPlayerMinHealth();
                    msgServer = this.plugin.getConfigManager().getNotificationConsoleMinHealth();
                } else if (this.plugin.getConfigManager().isMinHPDisabledAndSameOrLessThanZero(newMaxHealth)) {
                    if (this.plugin.getConfigManager().isDecreaseDebt()) {
                        debt = (int)(-newMaxHealth + (double)this.plugin.getConfigManager().getHPAfterBan());
                        player.sendMessage(this.plugin.getConfigManager().getNotificationPlayerDebtAdded().replace("{debtAdded}", "" + debt).replace("{debtLeft}", "" + this.plugin.getDebtDataManager().getDebt(playerUUID)));
                        this.plugin.getDebtDataManager().addDebt(playerUUID, debt);
                    }
                    newMaxHealth = this.plugin.getConfigManager().getHPAfterBan();
                    HealthManager.setMaxHealth(newMaxHealth, player);
                    if (this.plugin.getConfigManager().getMinHPBanTime() == 0) {
                        this.plugin.getBanManager().banPlayerPermanently(player);
                    } else {
                        this.plugin.getBanManager().banPlayer(player, (long)this.plugin.getConfigManager().getMinHPBanTime() * 60L * 60L * 1000L);
                    }
                    return true;
                }
                HealthManager.setMaxHealth(newMaxHealth, player);
                player.sendMessage(msgPlayer);
                this.plugin.sendColoredMessageToConsole(msgServer);
                return true;
            }
            String msgPlayer = this.plugin.getConfigManager().getNotificationPlayerDecreaseSameWay();
            player.sendMessage(msgPlayer);
            return false;
        }
        return false;
    }
}

