/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.HealthManager;
import io.github.b4n9z.deathPulse.Managers.TransactionManager;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TransferHealthCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public TransferHealthCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        TransactionManager.closeTransaction(sender);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "transferHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
            if (args.length != 3) {
                sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b transferHealth\u00a7f <player> <amount>");
                return true;
            }
            String targetPlayer = args[1];
            double amount = Double.parseDouble(args[2]);
            this.confirmTransferHealth(player, targetPlayer, amount);
        }
        return true;
    }

    private void confirmTransferHealth(Player player, String target, double amount) {
        Player playerTarget = Bukkit.getPlayer((String)target);
        if (playerTarget == null) {
            player.sendMessage("\u00a7cPlayer not found.");
            return;
        }
        String transactionId = TransactionManager.generateTransactionId((CommandSender)player);
        TransactionManager.openTransaction(this.plugin, (CommandSender)player, transactionId);
        UUID targetUUID = playerTarget.getUniqueId();
        TextComponent message = new TextComponent("\u00a7fAre\u00a7b you\u00a7f sure\u00a7b you\u00a7f want to transfer\u00a7d " + amount + "\u00a7e Health\u00a7f to\u00a7b " + target + "\u00a7f? ");
        TextComponent yes = new TextComponent("[YES]");
        yes.setColor(ChatColor.GREEN);
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse confirmTransferHealth " + String.valueOf(targetUUID) + " " + amount + " " + transactionId));
        TextComponent no = new TextComponent("[NO]");
        no.setColor(ChatColor.RED);
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse cancelTransferHealth " + transactionId));
        TextComponent newline = new TextComponent("\n");
        message.addExtra((BaseComponent)newline);
        message.addExtra((BaseComponent)yes);
        message.addExtra(" ");
        message.addExtra((BaseComponent)no);
        player.spigot().sendMessage((BaseComponent)message);
    }

    public boolean confirmedTransferHealth(CommandSender sender, String[] args) {
        Player player;
        if (sender instanceof Player) {
            player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "transferHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else {
            sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
            return false;
        }
        if (args.length != 4) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b confirmTransferHealth\u00a7f <playerUUID> <amount> <transactionID>");
            return false;
        }
        if (!this.plugin.getConfigManager().isValidUUID(args[1])) {
            return false;
        }
        UUID playerUUID = UUID.fromString(args[1]);
        Player playerTarget = Bukkit.getPlayer((UUID)playerUUID);
        double amount = Double.parseDouble(args[2]);
        String transactionId = args[3];
        if (playerTarget == null) {
            player.sendMessage("\u00a7cPlayer not found.");
            return false;
        }
        if (!TransactionManager.isValidTransaction((CommandSender)player, transactionId)) {
            player.sendMessage("\u00a7cThis confirmation has expired or is invalid. Please try again.");
            return false;
        }
        String targetName = playerTarget.getName();
        try {
            double oldHealthTarget = HealthManager.getMaxHealth(playerTarget);
            double oldHealthPlayer = HealthManager.getMaxHealth(player);
            double newHealthTarget = oldHealthTarget + amount;
            double newHealthPlayer = oldHealthPlayer - amount;
            if (this.plugin.getConfigManager().isMaxHPEnabled() && newHealthTarget > (double)this.plugin.getConfigManager().getMaxHPAmount()) {
                player.sendMessage("\u00a7fHealth target\u00a7c exceeds\u00a7f the max limit if you transfer \u00a7c" + amount + "\u00a7f to \u00a7b" + targetName + " (\u00a7cMax:" + this.plugin.getConfigManager().getMaxHPAmount() + "\u00a7f).");
                TransactionManager.closeTransaction((CommandSender)player);
                return false;
            }
            if (this.plugin.getConfigManager().isMinHPEnabled() && newHealthPlayer < (double)this.plugin.getConfigManager().getMinHPAmount()) {
                player.sendMessage("\u00a7fYour Health amount is\u00a7c under\u00a7f the min limit if you transfer \u00a7c" + amount + "\u00a7f to \u00a7b" + targetName + " (\u00a7cMin:" + this.plugin.getConfigManager().getMinHPAmount() + "\u00a7f).");
                TransactionManager.closeTransaction((CommandSender)player);
                return false;
            }
            HealthManager.setMaxHealth(newHealthPlayer, player);
            player.sendMessage("\u00a7bYour\u00a7f health has been set to\u00a7d " + newHealthPlayer + "\u00a7f after transferring\u00a7d " + amount + "\u00a7f health to\u00a7b " + playerTarget.getName());
            HealthManager.setMaxHealth(newHealthTarget, playerTarget);
            TransactionManager.closeTransaction((CommandSender)player);
            playerTarget.sendMessage("\u00a7bYou\u00a7f get transferred health from\u00a7b " + player.getName() + "\u00a7f. Your health has been set to\u00a7d " + newHealthTarget);
            player.sendMessage("\u00a7fTransferred\u00a7d " + amount + "\u00a7f Health to\u00a7b " + playerTarget.getName());
            return true;
        }
        catch (Exception e) {
            player.sendMessage("\u00a7cFailed to transfer health.");
            return false;
        }
    }

    public boolean cancelTransferHealth(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "transferHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else {
            sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
            return false;
        }
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b cancelTransferHealth\u00a7f <transactionID>");
            return false;
        }
        String transactionId = args[1];
        if (!transactionId.isEmpty() && TransactionManager.isValidTransaction(sender, transactionId)) {
            TransactionManager.closeTransaction(sender);
            sender.sendMessage("\u00a7bHealth transfer\u00a7f has been\u00a7c cancelled\u00a7f.");
        } else {
            sender.sendMessage("\u00a7cNo active transaction to cancel or invalid transaction ID.");
        }
        return true;
    }
}

