/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.HealthManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class SetMaxHealthCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public SetMaxHealthCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double newHealth;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "setMaxHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length != 3) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b setMaxHealth\u00a7f <player> <amount>");
            return true;
        }
        String targetPlayerName = args[1];
        Player targetPlayer = Bukkit.getPlayer((String)targetPlayerName);
        try {
            newHealth = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid health amount.");
            return true;
        }
        if (this.plugin.getConfigManager().isMaxHPEnabled() && newHealth > (double)this.plugin.getConfigManager().getMaxHPAmount()) {
            sender.sendMessage("\u00a7fHealth amount\u00a7c exceeds\u00a7f the max limit (\u00a7c" + this.plugin.getConfigManager().getMaxHPAmount() + "\u00a7f).");
            return true;
        }
        if (this.plugin.getConfigManager().isMinHPEnabled() && newHealth < (double)this.plugin.getConfigManager().getMinHPAmount()) {
            sender.sendMessage("\u00a7fHealth amount is\u00a7c under\u00a7f the min limit (\u00a7c" + this.plugin.getConfigManager().getMinHPAmount() + "\u00a7f).");
            return true;
        }
        if (targetPlayer == null) {
            if (this.plugin.getConfigManager().isValidUUID(targetPlayerName)) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(targetPlayerName));
                if (!offlinePlayer.hasPlayedBefore()) {
                    sender.sendMessage("\u00a7cPlayer not found.");
                    return false;
                }
                HealthManager.setOfflinePlayerMaxHealth(newHealth, offlinePlayer);
                sender.sendMessage("\u00a7fSet\u00a7b " + offlinePlayer.getName() + "'s\u00a7f health to\u00a7d " + newHealth);
            }
        } else {
            HealthManager.setMaxHealth(newHealth, targetPlayer);
            targetPlayer.sendMessage("\u00a7bYour\u00a7f health has been set to\u00a7d " + newHealth + "\u00a7b by an admin.");
            sender.sendMessage("\u00a7fSet\u00a7b " + targetPlayer.getName() + "'s\u00a7f health to\u00a7d " + newHealth);
        }
        return true;
    }
}

