/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class SetConfigCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public SetConfigCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Object parsedValue;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "setConfig")) {
                sender.sendMessage("\u00a7cYou do not have permission to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length < 3) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b setConfig\u00a7f <path> <value>");
            return true;
        }
        String path = args[1];
        String value = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)).trim();
        if (value.startsWith("add ") || value.startsWith("remove ")) {
            String[] parts = value.split(" ", 2);
            if (parts.length < 2) {
                sender.sendMessage("\u00a7cYou must provide a value to add/remove.");
                return true;
            }
            String action = parts[0];
            String item = parts[1];
            List list = this.plugin.getConfig().getStringList(path);
            if (action.equalsIgnoreCase("add")) {
                if (!list.contains(item)) {
                    list.add(item);
                    this.plugin.getConfig().set(path, (Object)list);
                    this.plugin.saveConfig();
                    sender.sendMessage("\u00a7aAdded\u00a7f " + item + "\u00a7a to list at\u00a7f " + path);
                } else {
                    sender.sendMessage("\u00a7eItem already exists in the list.");
                }
            } else if (action.equalsIgnoreCase("remove")) {
                if (list.remove(item)) {
                    this.plugin.getConfig().set(path, (Object)list);
                    this.plugin.saveConfig();
                    sender.sendMessage("\u00a7aRemoved\u00a7f " + item + "\u00a7a from list at\u00a7f " + path);
                } else {
                    sender.sendMessage("\u00a7eItem not found in the list.");
                }
            }
            return true;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            parsedValue = Boolean.parseBoolean(value);
        } else if (value.matches("-?\\d+")) {
            parsedValue = Integer.parseInt(value);
        } else if (value.startsWith("\"") && value.endsWith("\"")) {
            parsedValue = value.substring(1, value.length() - 1).trim() + " ";
        } else {
            sender.sendMessage("\u00a7cInvalid value format. Use quotes for strings.");
            return true;
        }
        if (!this.plugin.getConfig().contains(path)) {
            sender.sendMessage("\u00a7cPath not found in config: \u00a7f" + path);
            return true;
        }
        this.plugin.getConfig().set(path, parsedValue);
        this.plugin.saveConfig();
        sender.sendMessage("\u00a7aConfig updated: \u00a7f" + path + " = " + String.valueOf(parsedValue));
        return true;
    }
}

