/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.HealthManager;
import io.github.b4n9z.deathPulse.Managers.TransactionManager;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class ResetHealthCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public ResetHealthCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "resetHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b resetHealth\u00a7f <player|allPlayer>");
            return true;
        }
        if (args[1].equalsIgnoreCase("allPlayer")) {
            this.requestResetHealthAll(sender);
        } else {
            Player targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                if (this.plugin.getConfigManager().isValidUUID(args[1])) {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                    if (!offlinePlayer.hasPlayedBefore()) {
                        sender.sendMessage("\u00a7cPlayer not found.");
                        return true;
                    }
                    this.requestResetHealth(sender, offlinePlayer);
                }
            } else {
                this.requestResetHealth(sender, (OfflinePlayer)targetPlayer);
            }
        }
        return true;
    }

    private void requestResetHealth(CommandSender sender, OfflinePlayer target) {
        String transactionId = TransactionManager.generateTransactionId(sender);
        TransactionManager.openTransaction(this.plugin, sender, transactionId);
        TextComponent message = new TextComponent("\u00a7fAre\u00a7b you\u00a7f sure you want to reset health for\u00a7b " + target.getName() + "\u00a7f? ");
        TextComponent yes = new TextComponent("[YES]");
        yes.setColor(ChatColor.GREEN);
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse confirmResetHealth " + String.valueOf(target.getUniqueId()) + " " + transactionId));
        TextComponent no = new TextComponent("[NO]");
        no.setColor(ChatColor.RED);
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse cancelResetHealth " + transactionId));
        message.addExtra("\n");
        message.addExtra((BaseComponent)yes);
        message.addExtra(" ");
        message.addExtra((BaseComponent)no);
        sender.spigot().sendMessage((BaseComponent)message);
    }

    private void requestResetHealthAll(CommandSender sender) {
        String transactionId = TransactionManager.generateTransactionId(sender);
        TransactionManager.openTransaction(this.plugin, sender, transactionId);
        TextComponent message = new TextComponent("\u00a7fAre\u00a7b you\u00a7f sure you want to reset health for\u00a7e ALL players\u00a7f? ");
        TextComponent yes = new TextComponent("[YES]");
        yes.setColor(ChatColor.GREEN);
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse confirmResetHealth allPlayer " + transactionId));
        TextComponent no = new TextComponent("[NO]");
        no.setColor(ChatColor.RED);
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse cancelResetHealth " + transactionId));
        message.addExtra("\n");
        message.addExtra((BaseComponent)yes);
        message.addExtra(" ");
        message.addExtra((BaseComponent)no);
        sender.spigot().sendMessage((BaseComponent)message);
    }

    public boolean confirmResetHealth(CommandSender sender, String[] args) {
        int startHealth;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "resetHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length != 3) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b resetHealth\u00a7f <player|allPlayer> <transactionID>");
            return true;
        }
        String target = args[1];
        String transactionId = args[2];
        if (!TransactionManager.isValidTransaction(sender, transactionId)) {
            sender.sendMessage("\u00a7cThis confirmation has expired or is invalid.");
            return false;
        }
        try {
            startHealth = this.plugin.getConfigManager().getHPStart();
        }
        catch (NumberFormatException e) {
            sender.sendMessage("\u00a7cInvalid health amount.");
            TransactionManager.closeTransaction(sender);
            return true;
        }
        if (target.equalsIgnoreCase("allPlayer")) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                HealthManager.setMaxHealth(startHealth, onlinePlayer);
                onlinePlayer.sendMessage("\u00a7bYour\u00a7f health has been reset to\u00a7d " + startHealth + "\u00a7b by an admin.");
            }
            for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                HealthManager.setOfflinePlayerMaxHealth(startHealth, offlinePlayer);
            }
            sender.sendMessage("\u00a7bAll players'\u00a7f health has been reset to\u00a7d " + startHealth);
        } else {
            try {
                UUID uuid = UUID.fromString(target);
                Player online = Bukkit.getPlayer((UUID)uuid);
                if (online != null) {
                    HealthManager.setMaxHealth(startHealth, online);
                    online.sendMessage("\u00a7bYour\u00a7f health has been reset to\u00a7d " + startHealth + "\u00a7b by an admin.");
                    sender.sendMessage("\u00a7fSet\u00a7b " + online.getName() + "'s\u00a7f health to\u00a7d " + startHealth);
                } else {
                    OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)uuid);
                    if (!off.hasPlayedBefore()) {
                        sender.sendMessage("\u00a7cPlayer not found.");
                        TransactionManager.closeTransaction(sender);
                        return true;
                    }
                    HealthManager.setOfflinePlayerMaxHealth(startHealth, off);
                    sender.sendMessage("\u00a7fSet\u00a7b " + off.getName() + "'s\u00a7f health to\u00a7d " + startHealth);
                }
            }
            catch (IllegalArgumentException ex) {
                sender.sendMessage("\u00a7cInvalid player UUID.");
                TransactionManager.closeTransaction(sender);
                return true;
            }
        }
        TransactionManager.closeTransaction(sender);
        return true;
    }

    public boolean cancelResetHealth(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "resetHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b resetHealth\u00a7f <player|allPlayer>");
            return true;
        }
        String transactionId = args[1];
        if (!transactionId.isEmpty() && TransactionManager.isValidTransaction(sender, transactionId)) {
            TransactionManager.closeTransaction(sender);
            sender.sendMessage("\u00a7bReset health\u00a7f has been\u00a7c cancelled.");
        } else {
            sender.sendMessage("\u00a7cNo active transaction to cancel or invalid transaction ID.");
        }
        return true;
    }
}

