/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.TransactionManager;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class RemoveDebtDataCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public RemoveDebtDataCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        TransactionManager.closeTransaction(sender);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "dp.removeDebtData")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b removeDebtData\u00a7f <player|allPlayer>");
            return false;
        }
        String target = args[1];
        if (target.equalsIgnoreCase("allPlayer")) {
            this.confirmRemoveAll(sender);
        } else {
            Player targetPlayer = Bukkit.getPlayer((String)target);
            if (targetPlayer == null) {
                if (this.plugin.getConfigManager().isValidUUID(target)) {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(target));
                    if (!offlinePlayer.hasPlayedBefore()) {
                        sender.sendMessage("\u00a7cPlayer not found.");
                        return true;
                    }
                    this.confirmRemoveSingle(sender, offlinePlayer);
                }
            } else {
                this.confirmRemoveSingle(sender, (OfflinePlayer)targetPlayer);
            }
        }
        return true;
    }

    private void confirmRemoveSingle(CommandSender sender, OfflinePlayer player) {
        String transactionId = TransactionManager.generateTransactionId(sender);
        TransactionManager.openTransaction(this.plugin, sender, transactionId);
        TextComponent message = new TextComponent("\u00a7fAre\u00a7b you\u00a7f sure\u00a7b you\u00a7f want to remove\u00a7e debt data\u00a7f for\u00a7b " + player.getName() + "\u00a7f? ");
        TextComponent yes = new TextComponent("[YES]");
        yes.setColor(ChatColor.GREEN);
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse confirmRemoveDebtData " + String.valueOf(player.getUniqueId()) + " " + transactionId));
        TextComponent no = new TextComponent("[NO]");
        no.setColor(ChatColor.RED);
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse cancelRemoveDebtData " + transactionId));
        TextComponent newline = new TextComponent("\n");
        message.addExtra((BaseComponent)newline);
        message.addExtra((BaseComponent)yes);
        message.addExtra(" ");
        message.addExtra((BaseComponent)no);
        sender.spigot().sendMessage((BaseComponent)message);
    }

    private void confirmRemoveAll(CommandSender sender) {
        String transactionId = TransactionManager.generateTransactionId(sender);
        TransactionManager.openTransaction(this.plugin, sender, transactionId);
        TextComponent message = new TextComponent("\u00a7fAre\u00a7b you\u00a7f sure\u00a7b you\u00a7f want to remove\u00a7e debt data\u00a7f for\u00a7b all players\u00a7f? ");
        TextComponent yes = new TextComponent("[YES]");
        yes.setColor(ChatColor.GREEN);
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse confirmRemoveAllDebtData " + transactionId));
        TextComponent no = new TextComponent("[NO]");
        no.setColor(ChatColor.RED);
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse cancelRemoveDebtData " + transactionId));
        TextComponent newline = new TextComponent("\n");
        message.addExtra((BaseComponent)newline);
        message.addExtra((BaseComponent)yes);
        message.addExtra(" ");
        message.addExtra((BaseComponent)no);
        sender.spigot().sendMessage((BaseComponent)message);
    }

    public boolean confirmRemoveDebtData(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "removeDebtData")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        }
        if (args.length != 3) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b confirmRemoveDebtData\u00a7f <playerUUID> <transactionID>");
            return false;
        }
        String transactionId = args[2];
        if (!TransactionManager.isValidTransaction(sender, transactionId)) {
            sender.sendMessage("\u00a7cThis confirmation has expired or is invalid. Please try again.");
            return false;
        }
        UUID playerUUID = UUID.fromString(args[1]);
        boolean success = this.plugin.getDebtDataManager().removeDebtData(playerUUID);
        if (success) {
            sender.sendMessage("\u00a7bDebt data\u00a7f for player\u00a7b " + Bukkit.getOfflinePlayer((UUID)playerUUID).getName() + "\u00a7f has been\u00a7c removed\u00a7f.");
        } else {
            sender.sendMessage("\u00a7cFailed to remove\u00a7b debt data\u00a7f for player\u00a7b " + Bukkit.getOfflinePlayer((UUID)playerUUID).getName() + "\u00a7f. \u00a7cPlease try again.");
        }
        TransactionManager.closeTransaction(sender);
        return true;
    }

    public boolean confirmRemoveAllDebtData(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "removeDebtData")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        }
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b confirmRemoveAllDebtData\u00a7f <transactionID>");
            return false;
        }
        String transactionId = args[1];
        if (!TransactionManager.isValidTransaction(sender, transactionId)) {
            sender.sendMessage("\u00a7cThis confirmation has expired or is invalid. Please try again.");
            return false;
        }
        boolean success = this.plugin.getDebtDataManager().removeAllDebtData();
        if (success) {
            sender.sendMessage("\u00a7bDebt data\u00a7f for\u00a7b all players\u00a7f has been\u00a7c removed\u00a7f.");
        } else {
            sender.sendMessage("\u00a7cFailed to remove\u00a7b debt data\u00a7f for\u00a7b all players\u00a7f.\u00a7c Please try again.");
        }
        TransactionManager.closeTransaction(sender);
        return true;
    }

    public boolean cancelRemoveDebtData(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "removeDebtData")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        }
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b cancelRemoveDebtData\u00a7f <transactionID>");
            return false;
        }
        String transactionId = args[1];
        if (!transactionId.isEmpty() && TransactionManager.isValidTransaction(sender, transactionId)) {
            TransactionManager.closeTransaction(sender);
            sender.sendMessage("\u00a7bDebt data\u00a7f removal has been\u00a7c cancelled\u00a7f.");
        } else {
            sender.sendMessage("\u00a7cNo active transaction to cancel or invalid transaction ID.");
        }
        return true;
    }
}

