/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.HealthManager;
import io.github.b4n9z.deathPulse.Managers.TransactionManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MatchHealthCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public MatchHealthCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "matchHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b matchHealth\u00a7f <player|allPlayer>");
            return true;
        }
        if (args[1].equalsIgnoreCase("allPlayer")) {
            this.requestMatchHealthAll(sender);
        } else {
            Player targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                if (this.plugin.getConfigManager().isValidUUID(args[1])) {
                    OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                    if (!offlinePlayer.hasPlayedBefore()) {
                        sender.sendMessage("\u00a7cPlayer not found.");
                        return true;
                    }
                    this.requestMatchHealthSingle(sender, offlinePlayer);
                } else {
                    sender.sendMessage("\u00a7cInvalid player name or UUID.");
                }
            } else {
                this.requestMatchHealthSingle(sender, (OfflinePlayer)targetPlayer);
            }
        }
        return true;
    }

    private void requestMatchHealthSingle(CommandSender sender, OfflinePlayer target) {
        String transactionId = TransactionManager.generateTransactionId(sender);
        TransactionManager.openTransaction(this.plugin, sender, transactionId);
        TextComponent message = new TextComponent("\u00a7fAre\u00a7b you\u00a7f sure you want to match health for\u00a7b " + target.getName() + "\u00a7f? ");
        TextComponent yes = new TextComponent("[YES]");
        yes.setColor(ChatColor.GREEN);
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse confirmMatchHealth " + String.valueOf(target.getUniqueId()) + " " + transactionId));
        TextComponent no = new TextComponent("[NO]");
        no.setColor(ChatColor.RED);
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse cancelMatchHealth " + transactionId));
        message.addExtra("\n");
        message.addExtra((BaseComponent)yes);
        message.addExtra(" ");
        message.addExtra((BaseComponent)no);
        sender.spigot().sendMessage((BaseComponent)message);
    }

    private void requestMatchHealthAll(CommandSender sender) {
        String transactionId = TransactionManager.generateTransactionId(sender);
        TransactionManager.openTransaction(this.plugin, sender, transactionId);
        TextComponent message = new TextComponent("\u00a7fAre\u00a7b you\u00a7f sure you want to match health for\u00a7e ALL players\u00a7f? ");
        TextComponent yes = new TextComponent("[YES]");
        yes.setColor(ChatColor.GREEN);
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse confirmMatchHealth allPlayer " + transactionId));
        TextComponent no = new TextComponent("[NO]");
        no.setColor(ChatColor.RED);
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/deathpulse cancelMatchHealth " + transactionId));
        message.addExtra("\n");
        message.addExtra((BaseComponent)yes);
        message.addExtra(" ");
        message.addExtra((BaseComponent)no);
        sender.spigot().sendMessage((BaseComponent)message);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean confirmMatchHealth(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "matchHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length != 3) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b confirmMatchHealth\u00a7f <playerUUID|allPlayer> <transactionID>");
            return false;
        }
        String target = args[1];
        String transactionId = args[2];
        if (!TransactionManager.isValidTransaction(sender, transactionId)) {
            sender.sendMessage("\u00a7cThis confirmation has expired or is invalid.");
            return false;
        }
        if (target.equalsIgnoreCase("allPlayer")) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                this.matchPlayerHealth(onlinePlayer, sender);
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                    if (!offlinePlayer.hasPlayedBefore() || offlinePlayer.isOnline()) continue;
                    this.matchOfflinePlayerHealth(offlinePlayer, sender);
                }
                if (sender instanceof Player) {
                    sender.sendMessage("\u00a7bAll players'\u00a7f health has been matched (async) based on their\u00a7e death data\u00a7f.");
                }
            });
        } else {
            Player targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                if (!this.plugin.getConfigManager().isValidUUID(args[1])) {
                    sender.sendMessage("\u00a7cInvalid player name or UUID.");
                    TransactionManager.closeTransaction(sender);
                    return true;
                }
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                if (!offlinePlayer.hasPlayedBefore()) {
                    sender.sendMessage("\u00a7cPlayer not found.");
                    TransactionManager.closeTransaction(sender);
                    return true;
                }
                this.matchOfflinePlayerHealth(offlinePlayer, sender);
            } else {
                this.matchPlayerHealth(targetPlayer, sender);
            }
        }
        TransactionManager.closeTransaction(sender);
        return true;
    }

    public boolean cancelMatchHealth(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!this.plugin.getConfigManager().canUse((CommandSender)player, "matchHealth")) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
        } else if (!(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage("\u00a7fThis command\u00a7c can only be run\u00a7f by a player or from the console.");
            return false;
        }
        if (args.length != 2) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b cancelMatchHealth\u00a7f <transactionID>");
            return false;
        }
        String transactionId = args[1];
        if (!transactionId.isEmpty() && TransactionManager.isValidTransaction(sender, transactionId)) {
            TransactionManager.closeTransaction(sender);
            sender.sendMessage("\u00a7bMatch health\u00a7f has been\u00a7c cancelled.");
        } else {
            sender.sendMessage("\u00a7cNo active transaction to cancel or invalid transaction ID.");
        }
        return true;
    }

    private void matchPlayerHealth(Player player, CommandSender sender) {
        UUID playerUUID = player.getUniqueId();
        Set<String> deathData = this.plugin.getDeathDataManager().loadPlayerDeaths(playerUUID);
        if (deathData.isEmpty()) {
            HealthManager.setMaxHealth(this.plugin.getConfigManager().getHPStart(), player);
            sender.sendMessage("\u00a7b" + player.getName() + "\u00a7c has no recorded\u00a7e death data.");
        } else {
            int matchedHealth = this.calculateHealthFromDeathData(deathData);
            if (matchedHealth <= 0) {
                if (this.plugin.getConfigManager().getMinHPBanTime() == 0) {
                    this.plugin.getBanManager().banPlayerPermanently(player);
                } else {
                    this.plugin.getBanManager().banPlayer(player, (long)this.plugin.getConfigManager().getMinHPBanTime() * 60L * 60L * 1000L);
                }
                sender.sendMessage("\u00a7fBanned\u00a7b " + player.getName() + "\u00a7f because their health is\u00a7c 0\u00a7f or less.");
            } else {
                HealthManager.setMaxHealth(matchedHealth, player);
                player.sendMessage("\u00a7bYour\u00a7f health has been matched to\u00a7d " + matchedHealth + "\u00a7f based on your\u00a7e death data.");
                sender.sendMessage("\u00a7fSet\u00a7b " + player.getName() + "\u00a7f health to\u00a7d " + matchedHealth + "\u00a7f based on their\u00a7e death data.");
            }
        }
    }

    private void matchOfflinePlayerHealth(OfflinePlayer player, CommandSender sender) {
        UUID playerUUID = player.getUniqueId();
        Set<String> deathData = this.plugin.getDeathDataManager().loadPlayerDeaths(playerUUID);
        int matchedHealth = deathData.isEmpty() ? this.plugin.getConfigManager().getHPStart() : this.calculateHealthFromDeathData(deathData);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (matchedHealth <= 0) {
                if (this.plugin.getConfigManager().getMinHPBanTime() == 0) {
                    this.plugin.getBanManager().banOfflinePlayerPermanently(player);
                } else {
                    this.plugin.getBanManager().banOfflinePlayer(player, (long)this.plugin.getConfigManager().getMinHPBanTime() * 60L * 60L * 1000L);
                }
                sender.sendMessage("\u00a7fBanned\u00a7b " + player.getName() + "\u00a7f because their health is\u00a7c 0\u00a7f or less (offline).");
            } else {
                HealthManager.setOfflinePlayerMaxHealth(matchedHealth, player);
                sender.sendMessage("\u00a7fSet\u00a7b " + player.getName() + "\u00a7f health to\u00a7b " + matchedHealth + "\u00a7f based on their\u00a7e death data.");
            }
        });
    }

    private boolean isValidDay(String deathCause, int day, String typeDeath) {
        String keyword = typeDeath + "Day_";
        int startIndex = deathCause.indexOf(keyword);
        if (startIndex == -1) {
            return false;
        }
        int endIndex = deathCause.indexOf(95, startIndex += keyword.length());
        if (endIndex == -1) {
            endIndex = deathCause.indexOf(93, startIndex);
        }
        if (endIndex == -1) {
            return false;
        }
        try {
            int deathDay = Integer.parseInt(deathCause.substring(startIndex, endIndex));
            return day != 0 && deathDay % day == 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isCauseMatch(Set<String> causes, String deathCause, String suffix, String typeDeath) {
        if (!(deathCause.endsWith(suffix) || typeDeath.equalsIgnoreCase("IncreaseDay") || typeDeath.equalsIgnoreCase("DecreaseDay"))) {
            return false;
        }
        String baseCause = this.splitCause(deathCause);
        if (causes.contains("ALL")) {
            switch (typeDeath) {
                case "Increase": {
                    return !this.plugin.getConfigManager().getIncreaseCauseExclude().contains(baseCause);
                }
                case "IncreaseDay": {
                    return !this.plugin.getConfigManager().getIncreaseDayCauseExclude().contains(baseCause);
                }
                case "Decrease": {
                    return !this.plugin.getConfigManager().getDecreaseCauseExclude().contains(baseCause);
                }
                case "DecreaseDay": {
                    return !this.plugin.getConfigManager().getDecreaseDayCauseExclude().contains(baseCause);
                }
            }
        }
        return causes.contains(baseCause);
    }

    private String splitCause(String deathCause) {
        int bracketIndex = deathCause.indexOf(91);
        return bracketIndex != -1 ? deathCause.substring(0, bracketIndex) : deathCause;
    }

    private int calculateHealthFromDeathData(Set<String> deathData) {
        HashSet<String> increaseCause = new HashSet<String>(this.plugin.getConfigManager().getIncreaseCauseName());
        HashSet<String> increaseDayCause = new HashSet<String>(this.plugin.getConfigManager().getIncreaseDayCauseName());
        HashSet<String> decreaseCause = new HashSet<String>(this.plugin.getConfigManager().getDecreaseCauseName());
        HashSet<String> decreaseDayCause = new HashSet<String>(this.plugin.getConfigManager().getDecreaseDayCauseName());
        long increaseHealth = 0L;
        long increaseDaysHealth = 0L;
        long decreaseHealth = 0L;
        long decreaseDaysHealth = 0L;
        block0: for (String deathCause : deathData) {
            String causeDeath = this.splitCause(deathCause);
            if (this.plugin.getConfigManager().isIncreaseEnabled() && this.isCauseMatch(increaseCause, deathCause, "[Increase]", "Increase")) {
                increaseHealth += (long)this.plugin.getConfigManager().getIncreaseCauseAmount(causeDeath).intValue();
            }
            if (this.plugin.getConfigManager().isIncreaseDayEnabled() && this.isCauseMatch(increaseDayCause, deathCause, "[Increase]", "IncreaseDay")) {
                for (int day : this.plugin.getConfigManager().getIncreaseDays()) {
                    if (!this.isValidDay(deathCause, day, "increase")) continue;
                    increaseDaysHealth += (long)this.plugin.getConfigManager().getIncreaseDayCauseAmount(causeDeath).intValue();
                    break;
                }
            }
            if (this.plugin.getConfigManager().isDecreaseEnabled() && this.isCauseMatch(decreaseCause, deathCause, "[Decrease]", "Decrease")) {
                decreaseHealth += (long)this.plugin.getConfigManager().getDecreaseCauseAmount(causeDeath).intValue();
            }
            if (!this.plugin.getConfigManager().isDecreaseDayEnabled() || !this.isCauseMatch(decreaseDayCause, deathCause, "[Decrease]", "DecreaseDay")) continue;
            for (int day : this.plugin.getConfigManager().getDecreaseDays()) {
                if (!this.isValidDay(deathCause, day, "decrease")) continue;
                decreaseDaysHealth += (long)this.plugin.getConfigManager().getDecreaseDayCauseAmount(causeDeath).intValue();
                continue block0;
            }
        }
        int totalHealth = (int)((long)this.plugin.getConfigManager().getHPStart() + increaseHealth + increaseDaysHealth - decreaseHealth - decreaseDaysHealth);
        if (this.plugin.getConfigManager().isMaxHPEnabled()) {
            totalHealth = Math.min(totalHealth, this.plugin.getConfigManager().getMaxHPAmount());
        }
        if (this.plugin.getConfigManager().isMinHPEnabled()) {
            totalHealth = Math.max(totalHealth, this.plugin.getConfigManager().getMinHPAmount());
        }
        return totalHealth;
    }
}

