/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Listeners;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.HealthManager;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;

public class HealthItemListener
implements Listener {
    private final DeathPulse plugin;

    public HealthItemListener(DeathPulse plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (!this.plugin.getHealthItemManager().isHealthItem(item)) {
            return;
        }
        event.setCancelled(true);
        double healthPerItem = this.plugin.getConfigManager().getHealthItemHealthPerItem();
        if (this.plugin.getConfigManager().isMaxHPEnabledAndMoreThanMax(HealthManager.getMaxHealth(player) + healthPerItem)) {
            player.sendMessage(this.plugin.getConfigManager().getNotificationPlayerMaxHealth());
            return;
        }
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
        double newHealth = HealthManager.getMaxHealth(player) + healthPerItem;
        if (this.plugin.getConfigManager().isDecreaseDebt() && this.plugin.getDebtDataManager().getDebt(playerUUID) > 0) {
            int leftOver = this.plugin.getDebtDataManager().reduceDebt(playerUUID, (int)healthPerItem);
            newHealth = HealthManager.getMaxHealth(player) + (double)leftOver;
            if (leftOver > 0 || this.plugin.getDebtDataManager().getDebt(playerUUID) <= 0) {
                player.sendMessage(this.plugin.getConfigManager().getNotificationPlayerDebtPaidOff().replace("{debtPaid}", "" + (healthPerItem - (double)leftOver)));
                healthPerItem = leftOver;
            } else {
                player.sendMessage(this.plugin.getConfigManager().getNotificationPlayerDebtReduced().replace("{debtPaid}", "" + healthPerItem).replace("{debtLeft}", "" + this.plugin.getDebtDataManager().getDebt(playerUUID)));
                healthPerItem = 0.0;
            }
        }
        HealthManager.setMaxHealth(newHealth, player);
        player.setHealth(Math.min(player.getHealth() + (double)this.plugin.getHealthItemManager().getHealthPerItem(), newHealth));
        String msgPlayer = this.plugin.getConfigManager().getNotificationPlayerIncrease().replace("{increase}", String.valueOf(healthPerItem)).replace("{cause}", "Health Item");
        String msgServer = this.plugin.getConfigManager().getNotificationConsoleIncrease().replace("{name}", player.getName()).replace("{increase}", String.valueOf(healthPerItem)).replace("{cause}", "Health Item");
        player.sendMessage(msgPlayer);
        this.plugin.sendColoredMessageToConsole(msgServer);
    }

    @EventHandler
    public void onItemBurn(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Item)) {
            return;
        }
        Item item = (Item)entity;
        if (event.getCause() == EntityDamageEvent.DamageCause.VOID || event.getCause() == EntityDamageEvent.DamageCause.WORLD_BORDER) {
            return;
        }
        if (this.plugin.getHealthItemManager().isHealthItem(item.getItemStack())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        CraftingInventory inventory = event.getInventory();
        for (ItemStack item : inventory.getMatrix()) {
            ItemStack result;
            if (item == null || !this.plugin.getHealthItemManager().isHealthItem(item) || (result = inventory.getResult()) == null || !this.plugin.getConfigManager().isItemCannotCraftUsingHealthItem(result.getType().toString())) continue;
            inventory.setResult(null);
            break;
        }
    }
}

