/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.HealthManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class WithdrawHealthCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public WithdrawHealthCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!(player.isOp() || player.hasPermission("dp.withdrawHealth") || this.plugin.getConfigManager().isPermissionAllPlayerWithdrawHealth())) {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
                return false;
            }
            if (args.length != 2) {
                sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b withdrawHealth\u00a7f <amount>");
                return true;
            }
            PlayerInventory inventory = player.getInventory();
            if (inventory.firstEmpty() == -1) {
                sender.sendMessage("\u00a7cYour inventory is full.");
                return true;
            }
            double currentHealth = HealthManager.getMaxHealth(player);
            double amountItem = Double.parseDouble(args[1]);
            double amountHealth = this.plugin.getConfigManager().getHealthItemHealthPerItem() * amountItem;
            if (amountHealth >= currentHealth) {
                sender.sendMessage("\u00a7cYou don't have enough health.");
                return true;
            }
            HealthManager.setMaxHealth(currentHealth - amountHealth, player);
            ItemStack healthItem = this.plugin.getHealthItemManager().getHealthItem();
            healthItem.setAmount((int)amountItem);
            inventory.addItem(new ItemStack[]{healthItem});
            player.sendMessage("\u00a7fYou\u00a7b withdrew\u00a7f " + amountItem + "\u00a7b health\u00a7f items.");
            return true;
        }
        return true;
    }
}

