/*
 * Decompiled with CFR 0.152.
 */
package io.github.b4n9z.deathPulse.Commands;

import io.github.b4n9z.deathPulse.DeathPulse;
import io.github.b4n9z.deathPulse.Managers.HealthManager;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ViewDeathDataCommand
implements CommandExecutor {
    private final DeathPulse plugin;

    public ViewDeathDataCommand(DeathPulse plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length != 1) {
            sender.sendMessage("\u00a7fUsage:\u00a7c /DeathPulse\u00a7b viewDeathData");
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (player.isOp() || player.hasPermission("dp.viewDeathData") || this.plugin.getConfigManager().isPermissionAllPlayerViewDeathData()) {
                double currentHealth = HealthManager.getHealth(player);
                double maxPlayerHealth = HealthManager.getMaxHealth(player);
                sender.sendMessage("\u00a7b" + player.getName() + "\u00a7f currently has\u00a7d " + currentHealth + "\u00a7f health out of\u00a7d " + maxPlayerHealth + "\u00a7f max health.");
                UUID targetUUID = player.getUniqueId();
                Set<String> deathData = this.plugin.getDeathDataManager().loadPlayerDeaths(targetUUID);
                if (deathData.isEmpty()) {
                    sender.sendMessage("\u00a7b" + player.getName() + "\u00a7c you have no recorded\u00a7f death data.");
                } else {
                    sender.sendMessage("\u00a7b" + player.getName() + "'s\u00a7f death data:\u00a7e");
                    for (String deathCause : deathData) {
                        sender.sendMessage("- " + deathCause);
                    }
                }
            } else {
                sender.sendMessage("\u00a7fYou\u00a7c do not have permission\u00a7f to use this command.");
            }
        }
        return true;
    }
}

