/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.utils.gui;

import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.config.BorderConfig;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.configuration.file.YamlConfiguration;

public class GUIFileManager {
    private final BorderPlus plugin;

    public GUIFileManager(BorderPlus plugin) {
        this.plugin = plugin;
    }

    public void checkAndCreateGUIs() {
        for (String worldKey : this.plugin.getBorderConfig().getWorldSettingsMap().keySet()) {
            File collectiveGuiFile;
            BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldKey);
            String guiFileName = worldSettings.getGuiName();
            String collectiveGuiFileName = worldSettings.getCollectiveGuiName();
            File guiFile = new File(this.plugin.getDataFolder(), guiFileName);
            if (!guiFile.exists()) {
                this.createDefaultGUIFile(guiFileName, worldKey);
            }
            if (collectiveGuiFileName == null || collectiveGuiFileName.isEmpty() || (collectiveGuiFile = new File(this.plugin.getDataFolder(), collectiveGuiFileName)).exists()) continue;
            this.createDefaultCollectiveGUIFile(collectiveGuiFileName, worldKey);
        }
    }

    private void createDefaultCollectiveGUIFile(String guiFileName, String worldName) {
        try {
            File file = new File(this.plugin.getDataFolder(), guiFileName);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                config.set("menus.collective_menu.title", (Object)"   &#58126b\u25c2 &#721c8a&lPiggy Bank &#58126b\u25b8");
                config.set("menus.collective_menu.size", (Object)36);
                this.addDefaultCollectiveMenuItems(config, worldName);
                config.save(file);
                BorderPlus.logInfo("New Collective GUI file created: " + guiFileName);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error creating Collective GUI file: " + guiFileName);
            e.printStackTrace();
        }
    }

    private void addDefaultCollectiveMenuItems(YamlConfiguration config, String worldName) {
        HashMap<String, Object> centerItem = new HashMap<String, Object>();
        centerItem.put("material", "ENDER_CHEST");
        centerItem.put("display_name", "&eWorld Expansion Progress");
        centerItem.put("lore", Arrays.asList("", "", "   &7Contributed: &a%borderplus_collective_progress_" + worldName + "%&7%", "   %progress_bar_" + worldName + "%", "", "    &9&lLeaders", "  &e1st place: &b%borderplus_collective_top_name_1%", "  &e2nd place: &b%borderplus_collective_top_name_2%", "  &e3rd place: &b%borderplus_collective_top_name_3%", "", "   &aYour contribution: &7%borderplus_collective_player_contribution%", "", " &#168032\u22c5 &#32a852Click the buttons below", " &#168032  below to contribute", ""));
        centerItem.put("slot", 13);
        config.set("menus.collective_menu.items.center_item", centerItem);
        HashMap<String, Object> contribute1 = new HashMap<String, Object>();
        contribute1.put("material", "IRON_INGOT");
        contribute1.put("display_name", "&aContribute 1 resource");
        contribute1.put("lore", Arrays.asList("", "   &7Click to contribute", "   &a1 &7resource to the piggy bank.", ""));
        contribute1.put("slot", 20);
        contribute1.put("contribution_amount", 1);
        contribute1.put("economy", false);
        HashMap<String, Object> rotation1 = new HashMap<String, Object>();
        rotation1.put("rotate_material", true);
        rotation1.put("materials", Arrays.asList("NETHERITE_INGOT", "COAL", "REDSTONE", "LAPIS_LAZULI", "QUARTZ", "BLAZE_ROD", "GHAST_TEAR", "ENDER_PEARL", "NETHER_STAR", "ENCHANTED_GOLDEN_APPLE", "TOTEM_OF_UNDYING", "ELYTRA", "TRIDENT", "CONDUIT"));
        contribute1.put("rotation", rotation1);
        config.set("menus.collective_menu.items.contribute_1", contribute1);
        HashMap<String, Object> contribute100 = new HashMap<String, Object>();
        contribute100.put("material", "EMERALD");
        contribute100.put("display_name", "&aContribute 100 coins");
        contribute100.put("lore", Arrays.asList("", "   &7Click to contribute", "   &a100 coins &7to the piggy bank.", ""));
        contribute100.put("slot", 31);
        contribute100.put("contribution_amount", 100);
        contribute100.put("economy", true);
        contribute100.put("cost", 100.0);
        HashMap<String, Object> rotation100 = new HashMap<String, Object>();
        rotation100.put("rotate_material", false);
        rotation100.put("costs", Arrays.asList(100.0, 250.0, 500.0, 1000.0, 2500.0));
        contribute100.put("rotation", rotation100);
        config.set("menus.collective_menu.items.contribute_100", contribute100);
        HashMap<String, Object> contributeXp = new HashMap<String, Object>();
        contributeXp.put("material", "EXPERIENCE_BOTTLE");
        contributeXp.put("display_name", "&a&lContribute 5 XP Levels");
        contributeXp.put("lore", Arrays.asList("", "   &7Click to contribute", "   &a5 XP levels &7to the piggy bank.", "   &7(uses your experience bar)", ""));
        contributeXp.put("slot", 22);
        contributeXp.put("economy", false);
        contributeXp.put("use_xp_levels", true);
        contributeXp.put("xp_cost", 5);
        contributeXp.put("contribution_amount", 5);
        config.set("menus.collective_menu.items.contribute_xp", contributeXp);
        HashMap<String, Object> contributeCustom = new HashMap<String, Object>();
        contributeCustom.put("material", "DIAMOND");
        contributeCustom.put("display_name", "&aContribute 5 resources");
        contributeCustom.put("lore", Arrays.asList("", "   &7Click to contribute", "   &a5 &7resources to the piggy bank.", ""));
        contributeCustom.put("slot", 24);
        contributeCustom.put("contribution_amount", 5);
        contributeCustom.put("economy", false);
        HashMap<String, Object> rotationCustom = new HashMap<String, Object>();
        rotationCustom.put("rotate_material", true);
        rotationCustom.put("materials", Arrays.asList("PHANTOM_MEMBRANE", "SHULKER_SHELL", "NAUTILUS_SHELL", "PRISMARINE_CRYSTALS", "PRISMARINE_SHARD", "SPONGE", "WET_SPONGE", "HONEYCOMB", "HONEY_BOTTLE", "BEE_NEST", "HEART_OF_THE_SEA", "TURTLE_EGG", "BRAIN_CORAL", "BUBBLE_CORAL", "FIRE_CORAL", "HORN_CORAL", "TUBE_CORAL", "KELP", "SEAGRASS", "SEA_PICKLE", "CONDUIT", "ELYTRA"));
        rotationCustom.put("amounts", Arrays.asList(1, 3, 5, 10, 15, 25));
        contributeCustom.put("rotation", rotationCustom);
        config.set("menus.collective_menu.items.contribute_custom", contributeCustom);
    }

    private void createDefaultGUIFile(String guiFileName, String worldName) {
        try {
            File file = new File(this.plugin.getDataFolder(), guiFileName);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                config.set("menus.border_menu.title", (Object)"   &#58126b\u25c2 &#721c8a&lBorder Expansion &#58126b\u25b8");
                config.set("menus.border_menu.size", (Object)36);
                this.addDefaultMenuItems(config, worldName);
                config.save(file);
                BorderPlus.logInfo("New GUI file created: " + guiFileName);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error creating GUI file: " + guiFileName);
            e.printStackTrace();
        }
    }

    private void addDefaultMenuItems(YamlConfiguration config, String worldName) {
        HashMap<String, Object> diamondItem = new HashMap<String, Object>();
        diamondItem.put("material", "DIAMOND");
        diamondItem.put("required_material", "DIAMOND");
        diamondItem.put("economy", false);
        diamondItem.put("required_amount", 100);
        diamondItem.put("cost", 0.0);
        diamondItem.put("weight", 500);
        diamondItem.put("display_name", "&#7289DA &lDiamond Expansion");
        diamondItem.put("lore", Arrays.asList("", "   &7Spend &b&l100 diamonds&7 to", "   &7increase the world border", "   &7by &b&l500 blocks", "", " &#168032\u22c5 &#32a852click &7- to expand the border", ""));
        diamondItem.put("slot", 10);
        diamondItem.put("sound", "BLOCK_ANVIL_LAND");
        HashMap<String, Object> diamondRotation = new HashMap<String, Object>();
        diamondRotation.put("rotate_material", true);
        diamondRotation.put("materials", Arrays.asList("NETHERITE_INGOT", "COAL", "REDSTONE", "LAPIS_LAZULI", "QUARTZ", "BLAZE_ROD", "GHAST_TEAR", "ENDER_PEARL", "NETHER_STAR", "ENCHANTED_GOLDEN_APPLE", "TOTEM_OF_UNDYING", "ELYTRA", "TRIDENT", "CONDUIT"));
        diamondItem.put("rotation", diamondRotation);
        config.set("menus.border_menu.items.increase_diamond_20", diamondItem);
        HashMap<String, Object> goldItem = new HashMap<String, Object>();
        goldItem.put("material", "GOLD_INGOT");
        goldItem.put("required_material", "GOLD_INGOT");
        goldItem.put("economy", false);
        goldItem.put("required_amount", 50);
        goldItem.put("cost", 0.0);
        goldItem.put("weight", 500);
        goldItem.put("display_name", "&#7289DA &lGold Expansion");
        goldItem.put("lore", Arrays.asList("", "   &7Spend &6&l50 gold ingots&7 to", "   &7increase the world border", "   &7by &6&l500 blocks", "", " &#168032\u22c5 &#32a852click &7- to expand the border", ""));
        goldItem.put("slot", 13);
        goldItem.put("sound", "ENTITY_PLAYER_LEVELUP");
        HashMap<String, Object> goldRotation = new HashMap<String, Object>();
        goldRotation.put("rotate_material", false);
        goldRotation.put("amounts", Arrays.asList(500, 750, 1000, 1500, 2000));
        goldItem.put("rotation", goldRotation);
        config.set("menus.border_menu.items.increase_gold_50", goldItem);
        HashMap<String, Object> ironItem = new HashMap<String, Object>();
        ironItem.put("material", "IRON_INGOT");
        ironItem.put("required_material", "IRON_INGOT");
        ironItem.put("economy", false);
        ironItem.put("required_amount", 100);
        ironItem.put("cost", 0.0);
        ironItem.put("weight", 500);
        ironItem.put("display_name", "&f&lIron Expansion");
        ironItem.put("lore", Arrays.asList("", "   &7Spend &f&l100 iron ingots&7 to", "   &7increase the world border", "   &7by &f&l100 blocks", "", " &#168032\u22c5 &#32a852click &7- to expand the border", ""));
        ironItem.put("slot", 16);
        ironItem.put("sound", "ENTITY_EXPERIENCE_ORB_PICKUP");
        HashMap<String, Object> ironRotation = new HashMap<String, Object>();
        ironRotation.put("rotate_material", true);
        ironRotation.put("materials", Arrays.asList("PHANTOM_MEMBRANE", "SHULKER_SHELL", "NAUTILUS_SHELL", "PRISMARINE_CRYSTALS", "PRISMARINE_SHARD", "SPONGE", "WET_SPONGE", "HONEYCOMB", "HONEY_BOTTLE", "BEE_NEST", "HEART_OF_THE_SEA", "TURTLE_EGG", "BRAIN_CORAL", "BUBBLE_CORAL", "FIRE_CORAL", "HORN_CORAL", "TUBE_CORAL", "KELP", "SEAGRASS", "SEA_PICKLE", "CONDUIT", "ELYTRA"));
        ironItem.put("rotation", ironRotation);
        config.set("menus.border_menu.items.increase_iron_100", ironItem);
        HashMap<String, Object> emeraldItem = new HashMap<String, Object>();
        emeraldItem.put("material", "EMERALD");
        emeraldItem.put("required_material", "EMERALD");
        emeraldItem.put("economy", true);
        emeraldItem.put("required_amount", 1000);
        emeraldItem.put("cost", 1000.0);
        emeraldItem.put("weight", 1000);
        emeraldItem.put("display_name", "&a&lEmerald Border Expansion");
        emeraldItem.put("lore", Arrays.asList("", "   &7Spend &61000 coins&7 to", "   &7increase the world border", "   &7by &a&l1000 blocks", "", " &#168032\u22c5 &#32a852click &7- to expand the border", ""));
        emeraldItem.put("slot", 31);
        emeraldItem.put("sound", "BLOCK_GRASS_BREAK");
        HashMap<String, Object> emeraldRotation = new HashMap<String, Object>();
        emeraldRotation.put("rotate_material", false);
        emeraldRotation.put("costs", Arrays.asList(1000.0, 2500.0, 5000.0, 10000.0, 25000.0));
        emeraldItem.put("rotation", emeraldRotation);
        config.set("menus.border_menu.items.increase_economy_1000", emeraldItem);
        HashMap<String, Object> xpItem = new HashMap<String, Object>();
        xpItem.put("material", "EXPERIENCE_BOTTLE");
        xpItem.put("economy", false);
        xpItem.put("use_xp_levels", true);
        xpItem.put("xp_cost", 5);
        xpItem.put("weight", 100);
        xpItem.put("display_name", "&a&lXP Level Expansion");
        xpItem.put("lore", Arrays.asList("", "   &7Spend &a&l5 XP levels&7 to", "   &7increase the world border", "   &7by &a&l100 blocks", "   &7(uses your experience bar)", "", " &#168032\u22c5 &#32a852click &7- to expand the border", ""));
        xpItem.put("slot", 22);
        xpItem.put("sound", "ENTITY_PLAYER_LEVELUP");
        config.set("menus.border_menu.items.increase_xp_5", xpItem);
    }
}

