/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.config;

import ca.tweetzy.skulls.Skulls;
import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.config.BorderConfig;
import com.bobobo.plugins.borderplus.inventory.CustomInventoryHolder;
import com.bobobo.plugins.borderplus.utils.color.ColorParser;
import com.bobobo.plugins.borderplus.utils.gui.GUIItem;
import com.bobobo.plugins.borderplus.utils.gui.WorldGUI;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class GUIConfig {
    private final BorderPlus plugin;
    private final Map<String, WorldGUI> guiMap = new HashMap<String, WorldGUI>();
    private final HeadDatabaseAPI headDatabaseAPI;

    public GUIConfig(BorderPlus plugin) {
        this.plugin = plugin;
        this.headDatabaseAPI = Bukkit.getPluginManager().isPluginEnabled("HeadDatabase") ? new HeadDatabaseAPI() : null;
        this.loadConfigs();
    }

    public void loadConfigs() {
        for (String worldKey : this.plugin.getBorderConfig().getWorldSettingsMap().keySet()) {
            BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldKey);
            String worldName = worldSettings.getWorldName();
            String guiFileName = worldSettings.getGuiName();
            String collectiveGuiFileName = worldSettings.getCollectiveGuiName();
            this.loadConfigForWorld(worldName, guiFileName);
            if (collectiveGuiFileName == null || collectiveGuiFileName.isEmpty()) continue;
            this.loadCollectiveConfigForWorld(worldName, collectiveGuiFileName);
        }
    }

    public void reloadGUIForWorld(String worldName, String guiFileName) {
        BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldName);
        if (worldSettings == null) {
            return;
        }
        if (guiFileName.equals(worldSettings.getGuiName())) {
            this.loadConfigForWorld(worldName, guiFileName);
        } else if (guiFileName.equals(worldSettings.getCollectiveGuiName())) {
            this.loadCollectiveConfigForWorld(worldName, guiFileName);
        }
    }

    private void loadCollectiveConfigForWorld(String worldName, String guiFileName) {
        if (!this.validateConfigParameters(worldName, guiFileName)) {
            return;
        }
        BorderPlus.logInfo("Loading Collective GUI for world: " + worldName + " with file: " + guiFileName);
        String sectionPath = "menus.collective_menu.items";
        YamlConfiguration config = this.loadConfigFile(guiFileName, worldName, sectionPath);
        if (config == null) {
            return;
        }
        String title = config.getString("menus.collective_menu.title", "\u041a\u043e\u043f\u0438\u043b\u043a\u0430 \u0434\u043b\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f \u0433\u0440\u0430\u043d\u0438\u0446\u044b");
        int size = config.getInt("menus.collective_menu.size", 27);
        CustomInventoryHolder inventoryHolder = new CustomInventoryHolder(title, size, "collective_" + worldName);
        WorldGUI worldGUI = new WorldGUI("collective_" + worldName, inventoryHolder);
        worldGUI.setTitle(title);
        this.guiMap.put("collective_" + worldName, worldGUI);
        Inventory inventory = inventoryHolder.getInventory();
        for (String key : config.getConfigurationSection("menus.collective_menu.items").getKeys(false)) {
            String path = "menus.collective_menu.items." + key;
            String materialString = config.getString(path + ".material");
            Object slotsTag = config.get(path + ".slots", null);
            List<Integer> slots = slotsTag == null ? Collections.singletonList(config.getInt(path + ".slot", 13)) : this.parseSlots(slotsTag);
            Material material = Material.getMaterial((String)materialString);
            if (material == null) {
                this.plugin.getLogger().warning("Invalid material: " + materialString + " in " + guiFileName + " for item: " + key);
                continue;
            }
            ItemStack itemStack = new ItemStack(material);
            this.setItemMeta(itemStack, config, path);
            List loreList = config.getStringList(path + ".lore");
            String displayName = config.getString(path + ".display_name", "");
            boolean isDecor = !config.contains(path + ".contribution_amount") && !config.contains(path + ".use_xp_levels");
            List commands = config.getStringList(path + ".commands");
            boolean useXPLevels = config.getBoolean(path + ".use_xp_levels", false);
            int xpCost = config.getInt(path + ".xp_cost", 0);
            GUIItem guiItem = new GUIItem(key, null, 0, displayName, itemStack.getType(), false, 0.0, useXPLevels, xpCost, 0, null, loreList, isDecor, commands);
            if (config.contains(path + ".contribution_amount") || config.getBoolean(path + ".use_xp_levels", false)) {
                int contributionAmount = config.getInt(path + ".contribution_amount", 0);
                boolean useEconomy = config.getBoolean(path + ".economy", false);
                double cost = config.getDouble(path + ".cost", 0.0);
                useXPLevels = config.getBoolean(path + ".use_xp_levels", false);
                xpCost = config.getInt(path + ".xp_cost", 0);
                if (useXPLevels && contributionAmount == 0) {
                    contributionAmount = xpCost;
                }
                guiItem.setRequiredMaterial(useXPLevels ? null : itemStack.getType());
                guiItem.setRequiredAmount(contributionAmount);
                guiItem.setUseEconomy(useEconomy);
                guiItem.setCost(cost);
                guiItem.setUseXPLevels(useXPLevels);
                guiItem.setXpCost(xpCost);
            }
            for (int s : slots) {
                this.put(s, itemStack.clone(), guiItem, inventoryHolder, worldGUI);
            }
        }
    }

    private void loadConfigForWorld(String worldName, String guiFileName) {
        if (!this.validateConfigParameters(worldName, guiFileName)) {
            return;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("worldName", worldName);
        placeholders.put("guiFileName", guiFileName);
        BorderPlus.logInfo("Loading GUI for world: " + worldName + " with file: " + guiFileName);
        String sectionPath = "menus.border_menu.items";
        YamlConfiguration config = this.loadConfigFile(guiFileName, worldName, sectionPath);
        if (config == null) {
            return;
        }
        String title = config.getString("menus.border_menu.title", "\u041c\u0435\u043d\u044e \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u043c\u0438\u0440\u0430");
        int size = config.getInt("menus.border_menu.size", 27);
        CustomInventoryHolder customInventoryHolder = new CustomInventoryHolder(title, size, worldName);
        WorldGUI worldGUI = new WorldGUI(worldName, customInventoryHolder);
        worldGUI.setTitle(title);
        this.guiMap.put(worldName, worldGUI);
        for (String key : config.getConfigurationSection("menus.border_menu.items").getKeys(false)) {
            ItemStack itemStack;
            Sound soundEffect;
            boolean isDecor;
            Material requiredMaterial;
            int weight;
            int xpCost;
            boolean useXPLevels;
            double cost;
            boolean useEconomy;
            int requiredAmount;
            String path;
            block24: {
                path = "menus.border_menu.items." + key;
                String materialString = config.getString(path + ".material");
                String requiredMaterialString = config.getString(path + ".required_material", null);
                requiredAmount = config.getInt(path + ".required_amount", 0);
                useEconomy = config.getBoolean(path + ".economy", false);
                cost = config.getDouble(path + ".cost", 0.0);
                useXPLevels = config.getBoolean(path + ".use_xp_levels", false);
                xpCost = config.getInt(path + ".xp_cost", 0);
                weight = config.getInt(path + ".weight", 0);
                requiredMaterial = requiredMaterialString == null ? null : Material.getMaterial((String)requiredMaterialString);
                isDecor = requiredMaterial == null && requiredAmount == 0 && !useEconomy && cost == 0.0 && !useXPLevels && xpCost == 0 && weight == 0;
                String soundString = config.getString(path + ".sound", "ENTITY_PLAYER_LEVELUP");
                soundEffect = Sound.valueOf((String)soundString);
                itemStack = null;
                if (this.headDatabaseAPI != null && materialString != null && materialString.startsWith("hdb-")) {
                    String headId = materialString.split("-", 2)[1];
                    itemStack = this.headDatabaseAPI.getItemHead(headId);
                    if (itemStack == null) {
                        this.plugin.getLogger().severe("Failed to retrieve head with ID: " + headId + " from HeadDatabase.");
                        continue;
                    }
                } else if (materialString != null && materialString.startsWith("base64-")) {
                    String base64 = materialString.split("-", 2)[1];
                    itemStack = new ItemStack(Material.PLAYER_HEAD);
                    SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                    boolean success = false;
                    int versionCode = this.getServerVersionCode();
                    if (versionCode >= 11600) {
                        try {
                            PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID(), (String)"CustomHead");
                            profile.getProperties().add(new ProfileProperty("textures", base64));
                            skullMeta.setPlayerProfile(profile);
                            itemStack.setItemMeta((ItemMeta)skullMeta);
                            success = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.plugin.getLogger().warning("Failed to set custom head texture for the item: " + key);
                        }
                    } else {
                        try {
                            Field profileField = skullMeta.getClass().getDeclaredField("profile");
                            profileField.setAccessible(true);
                            Object gameProfile = this.createGameProfile(base64);
                            if (gameProfile != null) {
                                profileField.set(skullMeta, gameProfile);
                                itemStack.setItemMeta((ItemMeta)skullMeta);
                                success = true;
                            } else {
                                this.plugin.getLogger().warning("Failed to create GameProfile for the item: " + key);
                            }
                        }
                        catch (IllegalAccessException | NoSuchFieldException e) {
                            e.printStackTrace();
                            this.plugin.getLogger().warning("Failed to set custom head texture for the item: " + key);
                        }
                    }
                    if (!success) {
                        this.plugin.getLogger().warning("Failed to set custom head texture for item: " + key);
                    }
                } else if (materialString != null && materialString.startsWith("skull-")) {
                    String skullId = materialString.split("-", 2)[1];
                    try {
                        ItemStack skullItem = Skulls.getAPI().getSkullItem(Integer.parseInt(skullId));
                        if (skullItem != null) {
                            itemStack = skullItem;
                            break block24;
                        }
                        this.plugin.getLogger().severe("Failed to retrieve head with ID: " + skullId + " via Skulls API.");
                    }
                    catch (NumberFormatException e) {
                        this.plugin.getLogger().severe("Invalid ID format for skull: " + skullId);
                    }
                } else {
                    Material material = Material.getMaterial((String)materialString);
                    if (material == null) {
                        this.plugin.getLogger().log(Level.SEVERE, "Material not found for key: " + key);
                        continue;
                    }
                    itemStack = new ItemStack(material);
                }
            }
            this.setItemMeta(itemStack, config, path);
            Object slotsTag = config.get(path + ".slots", null);
            List<Integer> slots = slotsTag == null ? Collections.singletonList(config.getInt(path + ".slot")) : this.parseSlots(slotsTag);
            List lore = config.getStringList(path + ".lore");
            List commands = config.getStringList(path + ".commands");
            String displayName = config.getString(path + ".display_name", "");
            GUIItem guiItem = new GUIItem(key, requiredMaterial, requiredAmount, displayName, itemStack.getType(), useEconomy, cost, useXPLevels, xpCost, weight, soundEffect, lore, isDecor, commands);
            for (int s : slots) {
                this.put(s, itemStack.clone(), guiItem, customInventoryHolder, worldGUI);
            }
        }
        placeholders = new HashMap();
        placeholders.put("worldName", worldName);
        BorderPlus.logInfo("GUI for world: " + worldName + " successfully loaded into guiMap.");
    }

    private int getServerVersionCode() {
        String version = Bukkit.getServer().getBukkitVersion();
        String[] parts = version.split("-")[0].split("\\.");
        if (parts.length >= 2) {
            try {
                int major = Integer.parseInt(parts[0]);
                int minor = Integer.parseInt(parts[1]);
                int patch = parts.length >= 3 ? Integer.parseInt(parts[2]) : 0;
                return major * 10000 + minor * 100 + patch;
            }
            catch (NumberFormatException e) {
                this.plugin.getLogger().severe("Failed to determine the server version.");
            }
        }
        return -1;
    }

    private Object createGameProfile(String base64) {
        try {
            Class<?> gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
            Constructor<?> gameProfileConstructor = gameProfileClass.getConstructor(UUID.class, String.class);
            Object gameProfile = gameProfileConstructor.newInstance(UUID.randomUUID(), "CustomHead");
            Class<?> propertyClass = Class.forName("com.mojang.authlib.properties.Property");
            Constructor<?> propertyConstructor = propertyClass.getConstructor(String.class, String.class);
            Object property = propertyConstructor.newInstance("textures", base64);
            Method getPropertiesMethod = gameProfileClass.getMethod("getProperties", new Class[0]);
            Object properties = getPropertiesMethod.invoke(gameProfile, new Object[0]);
            Method putMethod = properties.getClass().getMethod("put", Object.class, Object.class);
            putMethod.invoke(properties, "textures", property);
            return gameProfile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void loadCollectiveGUI() {
        String guiFileName = "collective_gui.yml";
        File configFile = new File(this.plugin.getDataFolder(), guiFileName);
        if (!configFile.exists()) {
            this.plugin.getLogger().warning("The file " + guiFileName + " for collective GUI was not found.");
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        if (config.getConfigurationSection("menus.collective_menu.items") == null) {
            this.plugin.getLogger().severe("The section 'menus.collective_menu.items' is missing in " + guiFileName);
            return;
        }
        String title = config.getString("menus.collective_menu.title", "\u041a\u043e\u043f\u0438\u043b\u043a\u0430 \u0434\u043b\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f \u0433\u0440\u0430\u043d\u0438\u0446\u044b");
        int size = config.getInt("menus.collective_menu.size", 27);
        CustomInventoryHolder inventoryHolder = new CustomInventoryHolder(title, size, "collective");
        Inventory inventory = inventoryHolder.getInventory();
        for (String key : config.getConfigurationSection("menus.collective_menu.items").getKeys(false)) {
            String path = "menus.collective_menu.items." + key;
            String materialString = config.getString(path + ".material");
            int slot = config.getInt(path + ".slot", 13);
            Material material = Material.getMaterial((String)materialString);
            if (material == null) {
                this.plugin.getLogger().warning("Invalid material: " + materialString + " in collective_gui.yml for item: " + key);
                continue;
            }
            ItemStack itemStack = new ItemStack(material);
            this.setItemMeta(itemStack, config, path);
            inventory.setItem(slot, itemStack);
        }
        this.guiMap.put("collective_gui", new WorldGUI("collective", inventoryHolder));
    }

    private void put(int slot, ItemStack itemStack, GUIItem guiItem, CustomInventoryHolder holder, WorldGUI worldGUI) {
        if (slot < 0 || slot >= holder.getInventory().getSize()) {
            this.plugin.getLogger().warning("Invalid slot " + slot + " for inventory size " + holder.getInventory().getSize());
            return;
        }
        holder.getInventory().setItem(slot, itemStack);
        worldGUI.addItem(slot, guiItem);
    }

    private List<Integer> parseSlots(Object raw) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        if (raw instanceof Integer) {
            out.add((Integer)raw);
            return out;
        }
        if (raw instanceof List) {
            for (Object elem : (List)raw) {
                out.addAll(this.parseSlots(elem));
            }
            return out;
        }
        for (String part : String.valueOf(raw).split(",")) {
            if ((part = part.trim()).isEmpty()) continue;
            if (part.contains("-")) {
                String[] ab = part.split("-");
                int from = Integer.parseInt(ab[0].trim());
                int to = Integer.parseInt(ab[1].trim());
                for (int i = from; i <= to; ++i) {
                    out.add(i);
                }
                continue;
            }
            out.add(Integer.parseInt(part));
        }
        return out;
    }

    public Map<String, WorldGUI> getGuiMap() {
        return this.guiMap;
    }

    public void reloadConfigGUI() {
        this.guiMap.clear();
        this.loadConfigs();
    }

    public WorldGUI getWorldGUI(String worldName) {
        WorldGUI worldGUI = this.guiMap.get(worldName);
        if (worldGUI == null) {
            this.plugin.getLogger().warning(this.plugin.getMessagesConfig().getMessage("gui_not_found", null));
        }
        return worldGUI;
    }

    private boolean validateConfigParameters(String worldName, String guiFileName) {
        if (worldName == null || guiFileName == null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("worldName", worldName != null ? worldName : "null");
            placeholders.put("guiFileName", guiFileName != null ? guiFileName : "null");
            this.plugin.getLogger().warning(this.plugin.getMessagesConfig().getMessage("gui_load_error", placeholders));
            return false;
        }
        return true;
    }

    private void logFileNotFound(String guiFileName, String worldName) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("guiFileName", guiFileName);
        placeholders.put("worldName", worldName);
        this.plugin.getLogger().warning("The file " + (String)placeholders.get("guiFileName") + " for world " + (String)placeholders.get("worldName") + " was not found.");
    }

    private YamlConfiguration loadConfigFile(String guiFileName, String worldName, String sectionPath) {
        File configFile = new File(this.plugin.getDataFolder(), guiFileName);
        if (!configFile.exists()) {
            this.logFileNotFound(guiFileName, worldName);
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        if (config.getConfigurationSection(sectionPath) == null) {
            this.plugin.getLogger().severe("The section '" + sectionPath + "' is missing in " + guiFileName);
            return null;
        }
        return config;
    }

    private void setItemMeta(ItemStack itemStack, YamlConfiguration config, String path) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta != null) {
            meta.displayName(this.parseTextComponent(config.getString(path + ".display_name")));
            List lore = config.getStringList(path + ".lore");
            List loreComponents = lore.stream().filter(Objects::nonNull).map(this::parseTextComponent).collect(Collectors.toList());
            meta.lore(loreComponents);
            itemStack.setItemMeta(meta);
        }
    }

    private Component parseTextComponent(String text) {
        if (text == null) {
            return Component.empty();
        }
        return LegacyComponentSerializer.legacySection().deserialize(ColorParser.hex(text)).decoration(TextDecoration.ITALIC, false);
    }
}

