/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.utils.color;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ColorParser {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([a-fA-F\\d]{6})");

    public static String hex(String message) {
        if (message == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuilder buffer = new StringBuilder(message.length() + 32);
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            String replacement = ColorParser.parseHexColor(hexCode);
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    private static String parseHexColor(String hexCode) {
        char colorChar = '\u00a7';
        return String.valueOf(colorChar) + "x" + colorChar + hexCode.charAt(0) + colorChar + hexCode.charAt(1) + colorChar + hexCode.charAt(2) + colorChar + hexCode.charAt(3) + colorChar + hexCode.charAt(4) + colorChar + hexCode.charAt(5);
    }
}

