/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.listeners;

import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.config.BorderConfig;
import com.bobobo.plugins.borderplus.inventory.CustomInventoryHolder;
import com.bobobo.plugins.borderplus.utils.color.ColorParser;
import com.bobobo.plugins.borderplus.utils.gui.GUIItem;
import com.bobobo.plugins.borderplus.utils.gui.WorldGUI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MenuListener
implements Listener {
    private final BorderPlus plugin;
    private final Map<String, Set<Player>> openCollectiveGUIs = new HashMap<String, Set<Player>>();

    public MenuListener(BorderPlus plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onCollectiveGUIClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder;
        Inventory inventory = event.getClickedInventory();
        if (inventory == null || !((inventoryHolder = event.getView().getTopInventory().getHolder()) instanceof CustomInventoryHolder)) {
            return;
        }
        CustomInventoryHolder holder = (CustomInventoryHolder)inventoryHolder;
        String holderWorldName = holder.getWorldName();
        if (!holderWorldName.startsWith("collective_")) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        String worldName = holderWorldName.replace("collective_", "");
        GUIItem guiItem = this.plugin.getGUIConfig().getWorldGUI(holderWorldName).getGUIItemBySlot(slot);
        if (guiItem == null) {
            return;
        }
        if (this.commands(player, guiItem)) {
            return;
        }
        Material contributionMaterial = guiItem.getRequiredMaterial();
        if (contributionMaterial == null || contributionMaterial == Material.AIR) {
            return;
        }
        int contributionAmount = guiItem.getRequiredAmount();
        if (guiItem.isUseEconomy() && this.plugin.getBorderConfig().isEconomyEnabled()) {
            double cost = guiItem.getCost();
            if (this.ecoFoundFalse(player, cost)) {
                return;
            }
            if (this.WS(player, worldName)) {
                return;
            }
            if (this.plugin.getPlayerPointsAPI() != null) {
                this.plugin.getPlayerPointsAPI().take(player.getUniqueId(), (int)cost);
            } else if (this.plugin.getEconomy() != null) {
                this.plugin.getEconomy().withdrawPlayer((OfflinePlayer)player, cost);
            }
            this.plugin.getSQLiteManager().updateCollectiveContribution(player, worldName, (int)cost);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount_removed", String.valueOf(cost));
            player.sendMessage(this.plugin.getMessagesConfig().getMessage("money_removed", placeholders));
        } else {
            if (this.No_Items(player, contributionMaterial, contributionAmount)) {
                return;
            }
            if (this.WS(player, worldName)) {
                return;
            }
            this.removeItems(player, contributionMaterial, contributionAmount);
            this.plugin.getSQLiteManager().updateCollectiveContribution(player, worldName, contributionAmount);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("amount_removed", String.valueOf(contributionAmount));
            player.sendMessage(this.plugin.getMessagesConfig().getMessage("items_removed", placeholders));
        }
        int totalContributed = this.plugin.getSQLiteManager().getTotalContributed(worldName);
        int totalNeeded = this.plugin.getBorderConfig().getCollectiveGoal(worldName);
        if (totalContributed >= totalNeeded) {
            this.expandWorldBorderForAllPlayers(worldName, player, "border_expanded_piggybank");
            this.plugin.getSQLiteManager().resetCollectiveContributions(worldName);
        }
        this.updateCollectiveGUIForAllPlayers(worldName);
    }

    private boolean No_Items(Player player, Material contributionMaterial, int contributionAmount) {
        if (!player.getInventory().containsAtLeast(new ItemStack(contributionMaterial), contributionAmount)) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("material", contributionMaterial.name());
            placeholders.put("needed", String.valueOf(contributionAmount));
            player.sendMessage(this.plugin.getMessagesConfig().getMessage("insufficient_items", placeholders));
            return true;
        }
        return false;
    }

    private boolean WS(Player player, String worldName) {
        BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldName);
        WorldBorder border = Bukkit.getWorld((String)worldName).getWorldBorder();
        double newSize = border.getSize() + (double)this.plugin.getBorderConfig().getCollectiveExpansionAmount();
        if (worldSettings != null && newSize > (double)worldSettings.getMaxRadius()) {
            player.sendMessage(this.plugin.getMessagesConfig().getMessage("max_radius_reached", null));
            return true;
        }
        return false;
    }

    private void updateCollectiveGUIForAllPlayers(String worldName) {
        int totalNeeded = this.plugin.getBorderConfig().getCollectiveGoal(worldName);
        int totalContributed = this.plugin.getSQLiteManager().getTotalContributed(worldName);
        int progress = (int)((double)totalContributed / (double)totalNeeded * 100.0);
        Set<Player> playersWithOpenGUI = this.openCollectiveGUIs.get(worldName);
        if (playersWithOpenGUI != null && !playersWithOpenGUI.isEmpty()) {
            for (Player player : new HashSet<Player>(playersWithOpenGUI)) {
                if (player.isOnline() && player.getOpenInventory().getTopInventory().getHolder() instanceof CustomInventoryHolder) {
                    this.updateCollectiveGUIForPlayer(player, worldName, totalNeeded, totalContributed, progress);
                    continue;
                }
                playersWithOpenGUI.remove(player);
            }
        }
    }

    private void updateCollectiveGUIForPlayer(Player player, String worldName, int totalNeeded, int totalContributed, int progress) {
        Inventory inventory = player.getOpenInventory().getTopInventory();
        WorldGUI worldGUI = this.plugin.getGUIConfig().getWorldGUI("collective_" + worldName);
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            ItemStack clonedItem;
            ItemMeta meta;
            ItemStack itemStack = inventory.getItem(slot);
            if (itemStack == null || itemStack.getType() == Material.AIR || (meta = (clonedItem = itemStack.clone()).getItemMeta()) == null) continue;
            GUIItem guiItem = worldGUI != null ? worldGUI.getGUIItemBySlot(slot) : null;
            String displayName = this.getDisplayName(guiItem, meta, player);
            meta.displayName(this.parseTextComponent(displayName));
            List<String> lore = this.getLore(guiItem, meta);
            this.FProg(totalNeeded, totalContributed, progress, player, clonedItem, meta, lore);
            inventory.setItem(slot, clonedItem);
        }
    }

    private void FProg(int totalNeeded, int totalContributed, int progress, Player onlinePlayer, ItemStack itemStack, ItemMeta meta, List<String> lore) {
        int finalProgress = progress;
        int finalTotalContributed = totalContributed;
        int finalTotalNeeded = totalNeeded;
        lore = lore.stream().map(line -> line.replace("%borderplus_collective_progress_world%", String.valueOf(finalProgress))).map(line -> line.replace("%progress_bar_world%", this.getProgressBar(finalProgress))).map(line -> line.replace("%total_contributed%", String.valueOf(finalTotalContributed))).map(line -> line.replace("%total_needed%", String.valueOf(finalTotalNeeded))).map(line -> PlaceholderAPI.setPlaceholders((Player)onlinePlayer, (String)line)).map(ColorParser::hex).collect(Collectors.toList());
        List loreComponents = lore.stream().map(this::parseTextComponent).collect(Collectors.toList());
        meta.lore(loreComponents);
        itemStack.setItemMeta(meta);
    }

    private String getProgressBar(int progress) {
        int progressBars = progress / 5;
        return MenuListener.ProgressView(progress, progressBars);
    }

    @NotNull
    public static String ProgressView(int progress, int progressBars) {
        StringBuilder progressBar = new StringBuilder("\u00a77[");
        for (int i = 0; i < 20; ++i) {
            if (i < progressBars) {
                progressBar.append("\u00a7a|");
                continue;
            }
            progressBar.append("\u00a7c|");
        }
        progressBar.append("\u00a77] \u00a7e").append(progress).append("%");
        return progressBar.toString();
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof CustomInventoryHolder)) {
            return;
        }
        CustomInventoryHolder holder = (CustomInventoryHolder)inventoryHolder;
        String worldName = holder.getWorldName();
        if (worldName.startsWith("collective_")) {
            Player player = (Player)event.getPlayer();
            String actualWorldName = worldName.replace("collective_", "");
            this.openCollectiveGUIs.computeIfAbsent(actualWorldName, k -> new HashSet()).add(player);
            Inventory inventory = event.getInventory();
            for (int slot = 0; slot < inventory.getSize(); ++slot) {
                ItemStack clonedItem;
                ItemMeta meta;
                ItemStack itemStack = inventory.getItem(slot);
                if (itemStack == null || itemStack.getType() == Material.AIR || (meta = (clonedItem = itemStack.clone()).getItemMeta()) == null) continue;
                WorldGUI worldGUI = this.plugin.getGUIConfig().getWorldGUI(worldName);
                GUIItem guiItem = worldGUI != null ? worldGUI.getGUIItemBySlot(slot) : null;
                String displayName = this.getDisplayName(guiItem, meta, player);
                meta.displayName(this.parseTextComponent(displayName));
                List<String> lore = this.getLore(guiItem, meta);
                int totalNeeded = this.plugin.getBorderConfig().getCollectiveGoal(actualWorldName);
                int totalContributed = this.plugin.getSQLiteManager().getTotalContributed(actualWorldName);
                int progress = (int)((double)totalContributed / (double)totalNeeded * 100.0);
                this.FProg(totalNeeded, totalContributed, progress, player, clonedItem, meta, lore);
                inventory.setItem(slot, clonedItem);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof CustomInventoryHolder)) {
            return;
        }
        CustomInventoryHolder holder = (CustomInventoryHolder)inventoryHolder;
        String worldName = holder.getWorldName();
        if (worldName.startsWith("collective_")) {
            Player player = (Player)event.getPlayer();
            String actualWorldName = worldName.replace("collective_", "");
            Set<Player> players = this.openCollectiveGUIs.get(actualWorldName);
            if (players != null) {
                players.remove(player);
                if (players.isEmpty()) {
                    this.openCollectiveGUIs.remove(actualWorldName);
                }
            }
            this.plugin.clearPlayerWorldContext(player.getName());
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder;
        Inventory inv = event.getClickedInventory();
        if (inv == null || !((inventoryHolder = event.getView().getTopInventory().getHolder()) instanceof CustomInventoryHolder)) {
            return;
        }
        CustomInventoryHolder holder = (CustomInventoryHolder)inventoryHolder;
        String worldName = holder.getWorldName();
        if (worldName.startsWith("collective_")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        GUIItem guiItem = this.plugin.getGUIConfig().getWorldGUI(worldName).getGUIItemBySlot(slot);
        if (guiItem == null) {
            BorderPlus.logInfo("GUIItem \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043b\u044f \u0441\u043b\u043e\u0442\u0430: " + slot);
            return;
        }
        if (this.commands(player, guiItem)) {
            return;
        }
        if (guiItem.isDecor()) {
            return;
        }
        if ("center_item".equals(guiItem.getId())) {
            return;
        }
        if (!this.checkWorldBorderLimit(player, guiItem.getWeight(), worldName)) {
            return;
        }
        double cost = guiItem.getCost();
        int requiredAmount = guiItem.getRequiredAmount();
        Material requiredMat = guiItem.getRequiredMaterial();
        if (guiItem.isUseEconomy() && this.plugin.getBorderConfig().isEconomyEnabled()) {
            if (this.ecoFoundFalse(player, cost)) {
                return;
            }
            this.expandWorldBorder(player, guiItem.getWeight(), worldName, guiItem.getSoundEffect());
            if (this.plugin.getPlayerPointsAPI() != null) {
                this.plugin.getPlayerPointsAPI().take(player.getUniqueId(), (int)cost);
            } else if (this.plugin.getEconomy() != null) {
                this.plugin.getEconomy().withdrawPlayer((OfflinePlayer)player, cost);
            }
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("amount_removed", String.valueOf(cost));
            player.sendMessage(this.plugin.getMessagesConfig().getMessage("money_removed", ph));
        } else {
            if (this.No_Items(player, requiredMat, requiredAmount)) {
                return;
            }
            this.removeItems(player, requiredMat, requiredAmount);
            this.expandWorldBorder(player, guiItem.getWeight(), worldName, guiItem.getSoundEffect());
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("amount_removed", String.valueOf(requiredAmount));
            player.sendMessage(this.plugin.getMessagesConfig().getMessage("items_removed", ph));
        }
        player.closeInventory();
    }

    public boolean commands(Player player, GUIItem guiItem) {
        List<String> cmds = guiItem.getCommands();
        if (cmds == null || cmds.isEmpty()) {
            return false;
        }
        for (String raw : cmds) {
            if (raw.trim().toUpperCase().startsWith("[MESSAGE]")) {
                String msg = raw.substring(raw.indexOf(93) + 1).trim();
                msg = PlaceholderAPI.setPlaceholders((Player)player, (String)msg);
                player.sendMessage(LegacyComponentSerializer.legacySection().deserialize(ColorParser.hex(msg)).decoration(TextDecoration.ITALIC, false));
                continue;
            }
            String cmd = PlaceholderAPI.setPlaceholders((Player)player, (String)raw).trim();
            boolean asConsole = cmd.startsWith("console:");
            if (asConsole || cmd.startsWith("player:")) {
                cmd = cmd.substring(cmd.indexOf(58) + 1).trim();
            }
            if (cmd.startsWith("/")) {
                cmd = cmd.substring(1);
            }
            if (asConsole) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd);
                continue;
            }
            player.performCommand(cmd);
        }
        return true;
    }

    private boolean ecoFoundFalse(Player player, double cost) {
        boolean hasEnoughFunds = false;
        if (this.plugin.getPlayerPointsAPI() != null) {
            hasEnoughFunds = (double)this.plugin.getPlayerPointsAPI().look(player.getUniqueId()) >= cost;
        } else if (this.plugin.getEconomy() != null) {
            hasEnoughFunds = this.plugin.getEconomy().has((OfflinePlayer)player, cost);
        }
        if (!hasEnoughFunds) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("cost", String.valueOf(cost));
            player.sendMessage(this.plugin.getMessagesConfig().getMessage("insufficient_funds", placeholders));
            return true;
        }
        return false;
    }

    private void expandWorldBorderForAllPlayers(String worldName, Player player, String messageKey) {
        if (Bukkit.getWorld((String)worldName) != null) {
            WorldBorder border = Bukkit.getWorld((String)worldName).getWorldBorder();
            int expansionAmount = this.plugin.getBorderConfig().getCollectiveExpansionAmount();
            double oldSize = border.getSize();
            double newSize = oldSize + (double)expansionAmount;
            BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldName);
            if (worldSettings != null && newSize > (double)worldSettings.getMaxRadius()) {
                player.sendMessage(this.plugin.getMessagesConfig().getMessage("max_radius_reached", null));
                return;
            }
            int duration = this.plugin.getBorderConfig().getWorldBorderExpandDuration();
            border.setSize(newSize, (long)duration);
            this.expandDependentWorlds(worldName, expansionAmount, duration);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                double updatedSize = border.getSize();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("actual_amount", String.valueOf(expansionAmount));
                this.placehol(worldName, border, updatedSize, placeholders);
                placeholders.put("player", player != null ? player.getName() : "Unknown");
                placeholders.put("expanded_worlds_info", this.buildExpandedWorldsInfo(worldName));
                String message = this.plugin.getMessagesConfig().getMessage(messageKey, placeholders);
                Bukkit.getOnlinePlayers().forEach(onlinePlayer -> onlinePlayer.sendMessage(message));
                if (this.plugin.getBorderConfig().isShowTitle()) {
                    String titleMessage = this.plugin.getMessagesConfig().getMessage("title_message", null);
                    String titleNext = this.plugin.getMessagesConfig().getMessage("title_next", placeholders);
                    for (Player onlinePlayer2 : Bukkit.getOnlinePlayers()) {
                        onlinePlayer2.sendTitle(titleMessage, titleNext, 10, 70, 20);
                    }
                }
            }, (long)(duration + 1) * 20L);
        } else {
            Bukkit.getLogger().severe("\u041c\u0438\u0440 " + worldName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043b\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f \u0433\u0440\u0430\u043d\u0438\u0446\u044b.");
        }
    }

    private void expandDependentWorlds(String sourceWorldName, double expansionAmount, int duration) {
        BorderConfig.WorldSettings sourceSettings = this.plugin.getBorderConfig().getWorldSettings(sourceWorldName);
        for (String dependentWorldName : this.plugin.getBorderConfig().getWorldsDependingOn(sourceWorldName)) {
            int maxRadius;
            World world;
            if (dependentWorldName.equals(sourceWorldName) || (world = Bukkit.getWorld((String)dependentWorldName)) == null) continue;
            double ratio = this.getExpansionRatio(sourceSettings, dependentWorldName, world);
            double dependentAmount = expansionAmount * ratio;
            WorldBorder dependentBorder = world.getWorldBorder();
            double newSize = dependentBorder.getSize() + dependentAmount;
            if (newSize > (double)(maxRadius = this.getMaxRadiusForWorld(dependentWorldName))) continue;
            dependentBorder.setSize(newSize, (long)duration);
        }
    }

    private double getExpansionRatio(BorderConfig.WorldSettings sourceSettings, String dependentWorldName, World world) {
        Double ratio;
        if (sourceSettings != null && (ratio = sourceSettings.getExpandWorlds().get(dependentWorldName)) != null) {
            return ratio;
        }
        BorderConfig.WorldSettings settings = this.plugin.getBorderConfig().getWorldSettings(dependentWorldName);
        if (settings != null) {
            return settings.getExpansionRatio(world);
        }
        return world.getEnvironment() == World.Environment.NETHER ? 0.125 : 1.0;
    }

    private int getMaxRadiusForWorld(String worldName) {
        BorderConfig.WorldSettings settings = this.plugin.getBorderConfig().getWorldSettings(worldName);
        return settings != null ? settings.getMaxRadius() : Integer.MAX_VALUE;
    }

    private void removeItems(Player player, Material material, int amount) {
        ItemStack[] items = player.getInventory().getContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getType() != material) continue;
            int itemAmount = items[i].getAmount();
            if (amount <= itemAmount) {
                items[i].setAmount(itemAmount - amount);
                break;
            }
            player.getInventory().clear(i);
            amount -= itemAmount;
        }
    }

    private void expandWorldBorder(Player player, int weight, String worldName, Sound soundEffect) {
        if (Bukkit.getWorld((String)worldName) != null) {
            WorldBorder border = Bukkit.getWorld((String)worldName).getWorldBorder();
            double oldSize = border.getSize();
            double newSize = oldSize + (double)weight;
            int duration = this.plugin.getBorderConfig().getWorldBorderExpandDuration();
            border.setSize(newSize, (long)duration);
            this.expandDependentWorlds(worldName, weight, duration);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                double updatedSize = border.getSize();
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("actual_amount", String.valueOf(weight));
                placeholders.put("player", player.getName());
                this.placehol(worldName, border, updatedSize, placeholders);
                placeholders.put("expanded_worlds_info", this.buildExpandedWorldsInfo(worldName));
                String message = this.plugin.getMessagesConfig().getMessage("border_expanded_one", placeholders);
                Bukkit.getOnlinePlayers().forEach(onlinePlayer -> onlinePlayer.sendMessage(message));
                this.plugin.getSQLiteManager().updateDonation(player, weight);
                if (this.plugin.getBorderConfig().isShowTitle()) {
                    String titleMessage = this.plugin.getMessagesConfig().getMessage("title_message", null);
                    String titleNext = this.plugin.getMessagesConfig().getMessage("title_next", placeholders);
                    for (Player onlinePlayer2 : Bukkit.getOnlinePlayers()) {
                        onlinePlayer2.sendTitle(titleMessage, titleNext, 10, 70, 20);
                        if (soundEffect == null) continue;
                        onlinePlayer2.playSound(onlinePlayer2.getLocation(), soundEffect, 1.0f, 1.0f);
                    }
                }
            }, (long)(duration + 1) * 20L);
        } else {
            player.sendMessage("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043c\u0438\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u0443.");
        }
    }

    private void placehol(String worldName, WorldBorder border, double updatedSize, Map<String, String> placeholders) {
        BorderConfig.WorldSettings ws = this.plugin.getBorderConfig().getWorldSettings(worldName);
        placeholders.put("borderplus_world_name", ws != null ? ws.getDisplayName() : worldName);
        placeholders.put("minX", String.format("%.2f", border.getCenter().getX() - updatedSize / 2.0));
        placeholders.put("maxX", String.format("%.2f", border.getCenter().getX() + updatedSize / 2.0));
        placeholders.put("minZ", String.format("%.2f", border.getCenter().getZ() - updatedSize / 2.0));
        placeholders.put("maxZ", String.format("%.2f", border.getCenter().getZ() + updatedSize / 2.0));
    }

    private String buildExpandedWorldsInfo(String sourceWorldName) {
        List<String> dependentWorlds = this.plugin.getBorderConfig().getWorldsDependingOn(sourceWorldName);
        dependentWorlds.removeIf(w -> w.equals(sourceWorldName));
        if (dependentWorlds.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String header = this.plugin.getMessagesConfig().getMessage("expanded_worlds_header", null);
        if (header != null && !header.isEmpty() && !header.contains("Message not found")) {
            sb.append(header).append("\n");
        }
        for (String worldName : dependentWorlds) {
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) continue;
            WorldBorder border = world.getWorldBorder();
            double size = border.getSize();
            HashMap<String, String> ph = new HashMap<String, String>();
            ph.put("world_name", this.plugin.getBorderConfig().getDisplayNameForWorld(sourceWorldName, worldName));
            ph.put("minX", String.format("%.2f", border.getCenter().getX() - size / 2.0));
            ph.put("maxX", String.format("%.2f", border.getCenter().getX() + size / 2.0));
            ph.put("minZ", String.format("%.2f", border.getCenter().getZ() - size / 2.0));
            ph.put("maxZ", String.format("%.2f", border.getCenter().getZ() + size / 2.0));
            String line = this.plugin.getMessagesConfig().getMessage("expanded_worlds_line", ph);
            sb.append(line).append("\n");
        }
        return sb.toString();
    }

    private boolean checkWorldBorderLimit(Player player, int weight, String worldName) {
        if (Bukkit.getWorld((String)worldName) != null) {
            WorldBorder border = Bukkit.getWorld((String)worldName).getWorldBorder();
            double oldSize = border.getSize();
            double newSize = oldSize + (double)weight;
            BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldName);
            if (worldSettings != null && newSize > (double)worldSettings.getMaxRadius()) {
                player.sendMessage(this.plugin.getMessagesConfig().getMessage("max_radius_reached", null));
                return false;
            }
            return true;
        }
        player.sendMessage("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043c\u0438\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u0443.");
        return false;
    }

    private Component parseTextComponent(String text) {
        return LegacyComponentSerializer.legacySection().deserialize(ColorParser.hex(text)).decoration(TextDecoration.ITALIC, false);
    }

    private String getDisplayName(GUIItem guiItem, ItemMeta meta, Player player) {
        String displayName = guiItem != null && guiItem.getDisplayName() != null ? guiItem.getDisplayName() : (meta.hasDisplayName() ? PlainTextComponentSerializer.plainText().serialize(meta.displayName()) : "");
        return PlaceholderAPI.setPlaceholders((Player)player, (String)displayName);
    }

    private List<String> getLore(GUIItem guiItem, ItemMeta meta) {
        if (guiItem != null && guiItem.getLore() != null) {
            return guiItem.getLore();
        }
        return meta.hasLore() ? meta.lore().stream().map(component -> PlainTextComponentSerializer.plainText().serialize(component)).collect(Collectors.toList()) : new ArrayList<String>();
    }
}

