/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.config;

import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.config.MessagesConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class BorderConfig {
    private final BorderPlus plugin;
    private boolean economyEnabled;
    private final Map<String, WorldSettings> worldSettingsMap = new HashMap<String, WorldSettings>();
    private final MessagesConfig messagesConfig;
    private boolean showTitle;
    private String preferredEconomy;
    private Sound titleSound;
    private int defaultCollectiveGoal;
    private int collectiveExpansionAmount;
    private int worldBorderExpandDuration;

    public BorderConfig(BorderPlus plugin) {
        this.plugin = plugin;
        this.messagesConfig = new MessagesConfig(plugin);
    }

    public void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.showTitle = config.getBoolean("settings.show_title", true);
        this.preferredEconomy = config.getString("settings.preferred_economy", "vault");
        this.economyEnabled = config.getBoolean("settings.economy_enabled", true);
        this.defaultCollectiveGoal = config.getInt("settings.collective_goal", 1000);
        this.collectiveExpansionAmount = config.getInt("settings.collective_expansion_amount", 100);
        this.worldBorderExpandDuration = config.getInt("settings.world_border_expand_duration", 10);
        Iterator iterator = config.getConfigurationSection("settings.worlds").getKeys(false).iterator();
        while (iterator.hasNext()) {
            HashMap<String, String> placeholders;
            String worldKey;
            String worldName = worldKey = (String)iterator.next();
            String guiName = config.getString("settings.worlds." + worldKey + ".gui");
            String collectiveGuiName = config.getString("settings.worlds." + worldKey + ".collective_gui");
            int maxRadius = config.getInt("settings.worlds." + worldKey + ".max_size", Integer.MAX_VALUE);
            String displayName = config.getString("settings.worlds." + worldKey + ".name", worldKey);
            int collectiveGoal = config.getInt("settings.worlds." + worldKey + ".collective_goal", this.defaultCollectiveGoal);
            String dependsOn = config.getString("settings.worlds." + worldKey + ".depends_on");
            Double dependsRatio = config.contains("settings.worlds." + worldKey + ".depends_ratio") ? Double.valueOf(config.getDouble("settings.worlds." + worldKey + ".depends_ratio")) : null;
            Map<String, Double> expandWorlds = this.loadExpandWorlds(config, "settings.worlds." + worldKey + ".automatically_expand_worlds", worldKey);
            if (expandWorlds.isEmpty()) {
                expandWorlds = this.loadExpandWorlds(config, "settings.worlds." + worldKey + ".expand_worlds", worldKey);
            }
            Map<String, String> expandWorldsNames = this.loadExpandWorldsNames(config, "settings.worlds." + worldKey + ".expand_worlds_names");
            if (worldName == null || guiName == null) {
                placeholders = new HashMap<String, String>();
                placeholders.put("worldKey", worldKey);
                this.plugin.getLogger().severe(this.messagesConfig.getMessage("world_load_error", placeholders));
                continue;
            }
            placeholders = new HashMap();
            placeholders.put("worldName", worldName);
            placeholders.put("guiName", guiName);
            BorderPlus.logInfo("Loading world: " + worldName + " with GUI: " + guiName);
            this.worldSettingsMap.put(worldName, new WorldSettings(worldName, guiName, collectiveGuiName, maxRadius, displayName, collectiveGoal, dependsOn, dependsRatio, expandWorlds, expandWorldsNames));
        }
    }

    private Map<String, Double> loadExpandWorlds(FileConfiguration config, String path, String sourceWorldName) {
        LinkedHashMap<String, Double> result;
        block7: {
            Object raw;
            block6: {
                result = new LinkedHashMap<String, Double>();
                if (!config.contains(path)) {
                    return result;
                }
                ConfigurationSection section = config.getConfigurationSection(path);
                if (section != null) {
                    for (String key : section.getKeys(false)) {
                        if (key.equalsIgnoreCase(sourceWorldName)) continue;
                        if (section.isDouble(key)) {
                            result.put(key, this.parseRatio(section.getDouble(key)));
                            continue;
                        }
                        if (!section.isString(key)) continue;
                        result.put(key, null);
                    }
                    return result;
                }
                raw = config.get(path);
                if (!(raw instanceof List)) break block6;
                for (Object item : (List)raw) {
                    if (!(item instanceof String) || ((String)item).equalsIgnoreCase(sourceWorldName)) continue;
                    result.put((String)item, null);
                }
                break block7;
            }
            if (!(raw instanceof Map)) break block7;
            for (Map.Entry e : ((Map)raw).entrySet()) {
                String key = String.valueOf(e.getKey());
                if (key.equalsIgnoreCase(sourceWorldName)) continue;
                Object val = e.getValue();
                double parsed = val instanceof Number ? this.parseRatio(((Number)val).doubleValue()) : Double.NaN;
                result.put(key, Double.isNaN(parsed) ? null : Double.valueOf(parsed));
            }
        }
        return result;
    }

    private Map<String, String> loadExpandWorldsNames(FileConfiguration config, String path) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (!config.contains(path)) {
            return result;
        }
        ConfigurationSection section = config.getConfigurationSection(path);
        if (section != null) {
            for (String key : section.getKeys(false)) {
                if (!section.isString(key)) continue;
                result.put(key, section.getString(key));
            }
        }
        return result;
    }

    private double parseRatio(double value) {
        if (value >= 1.0 && value < 2.0) {
            int x = (int)Math.round((value - 1.0) * 10.0);
            return x <= 0 ? 1.0 : 1.0 / (double)x;
        }
        return value;
    }

    public int getCollectiveExpansionAmount() {
        return this.collectiveExpansionAmount;
    }

    public Map<String, WorldSettings> getWorldSettingsMap() {
        return this.worldSettingsMap;
    }

    public WorldSettings getWorldSettings(String worldName) {
        return this.worldSettingsMap.get(worldName);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        return this.messagesConfig.getMessage(key, placeholders);
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public String getPreferredEconomy() {
        return this.preferredEconomy;
    }

    public boolean isEconomyEnabled() {
        return this.economyEnabled;
    }

    public Sound getTitleSound() {
        return this.titleSound;
    }

    public int getCollectiveGoal(String worldName) {
        WorldSettings settings = this.worldSettingsMap.get(worldName);
        return settings != null && settings.getCollectiveGoal() > 0 ? settings.getCollectiveGoal() : this.defaultCollectiveGoal;
    }

    public int getCollectiveGoal() {
        return this.defaultCollectiveGoal;
    }

    public int getWorldBorderExpandDuration() {
        return this.worldBorderExpandDuration;
    }

    public List<String> getWorldsDependingOn(String sourceWorldName) {
        HashSet<String> result = new HashSet<String>();
        WorldSettings source = this.worldSettingsMap.get(sourceWorldName);
        if (source != null && !source.getExpandWorlds().isEmpty()) {
            result.addAll(source.getExpandWorlds().keySet());
        }
        for (Map.Entry<String, WorldSettings> entry : this.worldSettingsMap.entrySet()) {
            if (!sourceWorldName.equals(entry.getValue().getDependsOn())) continue;
            result.add(entry.getKey());
        }
        return new ArrayList<String>(result);
    }

    public String getDisplayNameForWorld(String sourceWorldName, String worldName) {
        WorldSettings source = this.worldSettingsMap.get(sourceWorldName);
        if (source != null && source.getExpandWorldsNames().containsKey(worldName)) {
            return source.getExpandWorldsNames().get(worldName);
        }
        WorldSettings settings = this.worldSettingsMap.get(worldName);
        if (settings != null) {
            return settings.getDisplayName();
        }
        return worldName;
    }

    public static class WorldSettings {
        private static final double NETHER_RATIO = 0.125;
        private final String worldName;
        private final String guiName;
        private final String collectiveGuiName;
        private final int maxRadius;
        private final String displayName;
        private final int collectiveGoal;
        private final String dependsOn;
        private final Double dependsRatio;
        private final Map<String, Double> expandWorlds;
        private final Map<String, String> expandWorldsNames;

        public WorldSettings(String worldName, String guiName, String collectiveGuiName, int maxRadius, String displayName, int collectiveGoal, String dependsOn, Double dependsRatio, Map<String, Double> expandWorlds, Map<String, String> expandWorldsNames) {
            this.worldName = worldName;
            this.guiName = guiName;
            this.collectiveGuiName = collectiveGuiName;
            this.maxRadius = maxRadius;
            this.displayName = displayName;
            this.collectiveGoal = collectiveGoal;
            this.dependsOn = dependsOn;
            this.dependsRatio = dependsRatio;
            this.expandWorlds = expandWorlds != null ? expandWorlds : Map.of();
            this.expandWorldsNames = expandWorldsNames != null ? expandWorldsNames : Map.of();
        }

        public WorldSettings(String worldName, String guiName, int maxRadius, String displayName) {
            this(worldName, guiName, null, maxRadius, displayName, -1, null, null, Map.of(), Map.of());
        }

        public Map<String, Double> getExpandWorlds() {
            return this.expandWorlds;
        }

        public Map<String, String> getExpandWorldsNames() {
            return this.expandWorldsNames;
        }

        public String getDependsOn() {
            return this.dependsOn;
        }

        public double getExpansionRatio(World world) {
            if (this.dependsRatio != null) {
                return this.dependsRatio;
            }
            if (world == null) {
                return 1.0;
            }
            return world.getEnvironment() == World.Environment.NETHER ? 0.125 : 1.0;
        }

        public String getWorldName() {
            return this.worldName;
        }

        public String getCollectiveGuiName() {
            return this.collectiveGuiName;
        }

        public String getGuiName() {
            return this.guiName;
        }

        public int getMaxRadius() {
            return this.maxRadius;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getCollectiveGoal() {
            return this.collectiveGoal;
        }
    }
}

