/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.utils.econony;

import com.bobobo.plugins.borderplus.BorderPlus;
import net.milkbowl.vault.economy.Economy;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyHandler {
    private final BorderPlus plugin;
    private PlayerPointsAPI playerPointsAPI;
    private Economy economy;

    public EconomyHandler(BorderPlus plugin) {
        this.plugin = plugin;
    }

    public boolean setupEconomy(String economyType) {
        if (!this.plugin.getBorderConfig().isEconomyEnabled()) {
            BorderPlus.logInfo("Economy is disabled in the configuration.");
            return false;
        }
        boolean economySetup = false;
        if (economyType.equalsIgnoreCase("playerpoints")) {
            if (Bukkit.getPluginManager().isPluginEnabled("PlayerPoints")) {
                this.playerPointsAPI = PlayerPoints.getInstance().getAPI();
                BorderPlus.logInfo("\u001b[32m\u2713\u001b[0m PlayerPoints API connected successfully.");
                economySetup = true;
            } else {
                BorderPlus.logInfo("\u001b[31m\u274c PlayerPoints API not found!\u001b[0m");
            }
        } else if (economyType.equalsIgnoreCase("vault")) {
            if (this.setupVaultEconomy()) {
                BorderPlus.logInfo("\u001b[32m\u2713\u001b[0m Vault economy connected successfully.");
                economySetup = true;
            } else {
                BorderPlus.logInfo("\u001b[31m\u274c Vault not found or no economy plugin available!\u001b[0m");
            }
        } else if (economyType.equalsIgnoreCase("default")) {
            if (Bukkit.getPluginManager().isPluginEnabled("PlayerPoints")) {
                this.playerPointsAPI = PlayerPoints.getInstance().getAPI();
                BorderPlus.logInfo("\u001b[32m\u2713\u001b[0m PlayerPoints API connected successfully.");
                economySetup = true;
            } else if (this.setupVaultEconomy()) {
                BorderPlus.logInfo("\u001b[32m\u2713\u001b[0m Vault economy connected successfully.");
                economySetup = true;
            }
        } else {
            BorderPlus.logInfo("\u001b[31m\u274c Unknown economy type in config! Defaulting to Vault or PlayerPoints\u001b[0m");
            if (Bukkit.getPluginManager().isPluginEnabled("PlayerPoints")) {
                this.playerPointsAPI = PlayerPoints.getInstance().getAPI();
                BorderPlus.logInfo("\u001b[32m\u2713\u001b[0m PlayerPoints API connected as fallback.");
                economySetup = true;
            } else if (this.setupVaultEconomy()) {
                BorderPlus.logInfo("\u001b[32m\u2713\u001b[0m Vault economy connected as fallback.");
                economySetup = true;
            }
        }
        return economySetup;
    }

    private boolean setupVaultEconomy() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public PlayerPointsAPI getPlayerPointsAPI() {
        return this.playerPointsAPI;
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

