/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.config;

import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.utils.color.ColorParser;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessagesConfig {
    private final BorderPlus plugin;
    private final Map<String, String> messages = new HashMap<String, String>();
    private String language;

    public MessagesConfig(BorderPlus plugin) {
        this.plugin = plugin;
        this.language = plugin.getConfig().getString("settings.language", "en");
        this.loadMessages();
    }

    private void loadMessages() {
        YamlConfiguration config;
        ConfigurationSection messagesSection;
        File file;
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdir();
        }
        if (!(file = new File(langFolder, "messages_" + this.language + ".yml")).exists()) {
            this.plugin.saveResource("lang/messages_" + this.language + ".yml", false);
        }
        if ((messagesSection = (config = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("messages")) != null) {
            for (String key : messagesSection.getKeys(false)) {
                this.messages.put(key, config.getString("messages." + key));
            }
        } else {
            this.plugin.getLogger().severe("Could not find the 'messages' section in the messages_" + this.language + ".yml file.");
        }
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.messages.getOrDefault(key, "Message not found for key: " + key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return ColorParser.hex(message);
    }

    public void reloadMessages() {
        this.language = this.plugin.getConfig().getString("settings.language", "en");
        this.loadMessages();
    }
}

