/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.utils.gui;

import com.bobobo.plugins.borderplus.BorderPlus;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RotationStorageManager {
    private final BorderPlus plugin;
    private final File storageFile;
    private FileConfiguration storageConfig;
    private final Map<String, Map<String, Object>> currentRotations = new ConcurrentHashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Long>> lastRotationTimes = new ConcurrentHashMap<String, Map<String, Long>>();

    public RotationStorageManager(BorderPlus plugin) {
        this.plugin = plugin;
        this.storageFile = new File(plugin.getDataFolder(), "rotation_storage.yml");
        this.loadStorage();
    }

    private void loadStorage() {
        if (!this.storageFile.exists()) {
            try {
                this.storageFile.getParentFile().mkdirs();
                this.storageFile.createNewFile();
                this.storageConfig = YamlConfiguration.loadConfiguration((File)this.storageFile);
                this.saveStorage();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create rotation storage file: " + e.getMessage());
                return;
            }
        }
        this.storageConfig = YamlConfiguration.loadConfiguration((File)this.storageFile);
        this.loadCurrentRotations();
        this.loadLastRotationTimes();
    }

    private void loadCurrentRotations() {
        this.currentRotations.clear();
        if (this.storageConfig.getConfigurationSection("rotations") == null) {
            return;
        }
        for (String worldKey : this.storageConfig.getConfigurationSection("rotations").getKeys(false)) {
            HashMap<String, HashMap<String, Object>> worldRotations = new HashMap<String, HashMap<String, Object>>();
            ConfigurationSection worldSection = this.storageConfig.getConfigurationSection("rotations." + worldKey);
            if (worldSection != null) {
                for (String guiTopKey : worldSection.getKeys(false)) {
                    String onlyChild;
                    ConfigurationSection childSection;
                    Object guiName = guiTopKey;
                    ConfigurationSection guiTopSection = worldSection.getConfigurationSection(guiTopKey);
                    if (guiTopSection == null) continue;
                    ConfigurationSection baseSection = guiTopSection;
                    if (guiTopSection.getKeys(false).size() == 1 && (childSection = guiTopSection.getConfigurationSection(onlyChild = (String)guiTopSection.getKeys(false).iterator().next())) != null) {
                        guiName = guiTopKey + "." + onlyChild;
                        baseSection = childSection;
                    }
                    HashMap<String, Object> guiRotations = new HashMap<String, Object>();
                    this.collectLeafValues("", baseSection, guiRotations);
                    worldRotations.put((String)guiName, guiRotations);
                }
            }
            this.currentRotations.put(worldKey, worldRotations);
        }
    }

    private void collectLeafValues(String prefix, ConfigurationSection section, Map<String, Object> out) {
        for (String key : section.getKeys(false)) {
            String fullKey = prefix.isEmpty() ? key : prefix + "." + key;
            Object val = section.get(key);
            if (val instanceof ConfigurationSection) {
                this.collectLeafValues(fullKey, (ConfigurationSection)val, out);
                continue;
            }
            out.put(fullKey, val);
        }
    }

    private void loadLastRotationTimes() {
        this.lastRotationTimes.clear();
        if (this.storageConfig.getConfigurationSection("last_rotation") == null) {
            return;
        }
        for (String worldKey : this.storageConfig.getConfigurationSection("last_rotation").getKeys(false)) {
            HashMap<String, Long> worldTimes = new HashMap<String, Long>();
            if (this.storageConfig.getConfigurationSection("last_rotation." + worldKey) != null) {
                for (String guiKey : this.storageConfig.getConfigurationSection("last_rotation." + worldKey).getKeys(false)) {
                    long ts = this.storageConfig.getLong("last_rotation." + worldKey + "." + guiKey, 0L);
                    worldTimes.put(guiKey, ts);
                }
            }
            this.lastRotationTimes.put(worldKey, worldTimes);
        }
    }

    public void saveStorage() {
        try {
            String basePath;
            String[] parts;
            String guiKey;
            String worldKey;
            for (String string : this.storageConfig.getKeys(false)) {
                this.storageConfig.set(string, null);
            }
            for (Map.Entry entry : this.currentRotations.entrySet()) {
                worldKey = (String)entry.getKey();
                Map worldRotations = (Map)entry.getValue();
                for (Map.Entry guiEntry : worldRotations.entrySet()) {
                    guiKey = (String)guiEntry.getKey();
                    Map guiRotations = (Map)guiEntry.getValue();
                    parts = guiKey.split("\\.");
                    basePath = "rotations." + worldKey + "." + parts[0];
                    for (int i = 1; i < parts.length; ++i) {
                        basePath = basePath + "." + parts[i];
                    }
                    for (Map.Entry itemEntry : guiRotations.entrySet()) {
                        String itemKey = (String)itemEntry.getKey();
                        Object value = itemEntry.getValue();
                        this.storageConfig.set(basePath + "." + itemKey, value);
                    }
                }
            }
            for (Map.Entry entry : this.lastRotationTimes.entrySet()) {
                worldKey = (String)entry.getKey();
                Map worldTimes = (Map)entry.getValue();
                for (Map.Entry guiEntry : worldTimes.entrySet()) {
                    guiKey = (String)guiEntry.getKey();
                    Long ts = (Long)guiEntry.getValue();
                    parts = guiKey.split("\\.");
                    basePath = "last_rotation." + worldKey + "." + parts[0];
                    for (int i = 1; i < parts.length; ++i) {
                        basePath = basePath + "." + parts[i];
                    }
                    this.storageConfig.set(basePath, (Object)ts);
                }
            }
            this.storageConfig.save(this.storageFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save rotation storage: " + e.getMessage());
        }
    }

    public Map<String, Object> getCurrentRotations(String worldName, String guiFileName) {
        Map worldRotations = this.currentRotations.computeIfAbsent(worldName, k -> new HashMap());
        return (Map)worldRotations.computeIfAbsent(guiFileName, k -> new HashMap());
    }

    public void setRotation(String worldName, String guiFileName, String itemPath, Object value) {
        Map worldRotations = this.currentRotations.computeIfAbsent(worldName, k -> new HashMap());
        Map guiRotations = (Map)worldRotations.computeIfAbsent(guiFileName, k -> new HashMap());
        guiRotations.put(itemPath, value);
        this.saveStorage();
    }

    public void setRotations(String worldName, String guiFileName, Map<String, Object> rotations) {
        Map worldRotations = this.currentRotations.computeIfAbsent(worldName, k -> new HashMap());
        Map guiRotations = (Map)worldRotations.computeIfAbsent(guiFileName, k -> new HashMap());
        guiRotations.clear();
        guiRotations.putAll(rotations);
        this.saveStorage();
    }

    public boolean hasRotations(String worldName, String guiFileName) {
        if (!this.currentRotations.containsKey(worldName)) {
            return false;
        }
        Map<String, Object> worldRotations = this.currentRotations.get(worldName);
        if (!worldRotations.containsKey(guiFileName)) {
            return false;
        }
        Map guiRotations = (Map)worldRotations.get(guiFileName);
        return guiRotations != null && !guiRotations.isEmpty();
    }

    public void clearRotations(String worldName, String guiFileName) {
        if (this.currentRotations.containsKey(worldName)) {
            Map<String, Object> worldRotations = this.currentRotations.get(worldName);
            worldRotations.remove(guiFileName);
            this.saveStorage();
        }
    }

    public void reload() {
        this.loadStorage();
    }

    public Long getLastRotationTime(String worldName, String guiFileName) {
        Map<String, Long> worldTimes = this.lastRotationTimes.get(worldName);
        if (worldTimes == null) {
            return null;
        }
        return worldTimes.get(guiFileName);
    }

    public void setLastRotationTime(String worldName, String guiFileName, long epochSeconds) {
        Map worldTimes = this.lastRotationTimes.computeIfAbsent(worldName, k -> new HashMap());
        worldTimes.put(guiFileName, epochSeconds);
        this.saveStorage();
    }
}

