/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.utils.gui;

import com.bobobo.plugins.borderplus.BorderPlus;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RotationStorageManager {
    private final BorderPlus plugin;
    private final File storageFile;
    private FileConfiguration storageConfig;
    private final Map<String, Map<String, Object>> currentRotations = new ConcurrentHashMap<String, Map<String, Object>>();

    public RotationStorageManager(BorderPlus plugin) {
        this.plugin = plugin;
        this.storageFile = new File(plugin.getDataFolder(), "rotation_storage.yml");
        this.loadStorage();
    }

    private void loadStorage() {
        if (!this.storageFile.exists()) {
            try {
                this.storageFile.getParentFile().mkdirs();
                this.storageFile.createNewFile();
                this.storageConfig = YamlConfiguration.loadConfiguration((File)this.storageFile);
                this.saveStorage();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to create rotation storage file: " + e.getMessage());
                return;
            }
        }
        this.storageConfig = YamlConfiguration.loadConfiguration((File)this.storageFile);
        this.loadCurrentRotations();
    }

    private void loadCurrentRotations() {
        this.currentRotations.clear();
        if (this.storageConfig.getConfigurationSection("rotations") == null) {
            return;
        }
        for (String worldKey : this.storageConfig.getConfigurationSection("rotations").getKeys(false)) {
            HashMap worldRotations = new HashMap();
            if (this.storageConfig.getConfigurationSection("rotations." + worldKey) != null) {
                for (String guiKey : this.storageConfig.getConfigurationSection("rotations." + worldKey).getKeys(false)) {
                    HashMap<String, Object> guiRotations = new HashMap<String, Object>();
                    if (this.storageConfig.getConfigurationSection("rotations." + worldKey + "." + guiKey) != null) {
                        for (String itemKey : this.storageConfig.getConfigurationSection("rotations." + worldKey + "." + guiKey).getKeys(false)) {
                            Object value = this.storageConfig.get("rotations." + worldKey + "." + guiKey + "." + itemKey);
                            guiRotations.put(itemKey, value);
                        }
                    }
                    worldRotations.put(guiKey, guiRotations);
                }
            }
            this.currentRotations.put(worldKey, worldRotations);
        }
    }

    public void saveStorage() {
        try {
            for (String string : this.storageConfig.getKeys(false)) {
                this.storageConfig.set(string, null);
            }
            for (Map.Entry entry : this.currentRotations.entrySet()) {
                String worldKey = (String)entry.getKey();
                Map worldRotations = (Map)entry.getValue();
                for (Map.Entry guiEntry : worldRotations.entrySet()) {
                    String guiKey = (String)guiEntry.getKey();
                    Map guiRotations = (Map)guiEntry.getValue();
                    for (Map.Entry itemEntry : guiRotations.entrySet()) {
                        String itemKey = (String)itemEntry.getKey();
                        Object value = itemEntry.getValue();
                        this.storageConfig.set("rotations." + worldKey + "." + guiKey + "." + itemKey, value);
                    }
                }
            }
            this.storageConfig.save(this.storageFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save rotation storage: " + e.getMessage());
        }
    }

    public Map<String, Object> getCurrentRotations(String worldName, String guiFileName) {
        Map worldRotations = this.currentRotations.computeIfAbsent(worldName, k -> new HashMap());
        return (Map)worldRotations.computeIfAbsent(guiFileName, k -> new HashMap());
    }

    public void setRotation(String worldName, String guiFileName, String itemPath, Object value) {
        Map worldRotations = this.currentRotations.computeIfAbsent(worldName, k -> new HashMap());
        Map guiRotations = (Map)worldRotations.computeIfAbsent(guiFileName, k -> new HashMap());
        guiRotations.put(itemPath, value);
        this.saveStorage();
    }

    public void setRotations(String worldName, String guiFileName, Map<String, Object> rotations) {
        Map worldRotations = this.currentRotations.computeIfAbsent(worldName, k -> new HashMap());
        Map guiRotations = (Map)worldRotations.computeIfAbsent(guiFileName, k -> new HashMap());
        guiRotations.clear();
        guiRotations.putAll(rotations);
        this.saveStorage();
    }

    public boolean hasRotations(String worldName, String guiFileName) {
        if (!this.currentRotations.containsKey(worldName)) {
            return false;
        }
        Map<String, Object> worldRotations = this.currentRotations.get(worldName);
        if (!worldRotations.containsKey(guiFileName)) {
            return false;
        }
        Map guiRotations = (Map)worldRotations.get(guiFileName);
        return guiRotations != null && !guiRotations.isEmpty();
    }

    public void clearRotations(String worldName, String guiFileName) {
        if (this.currentRotations.containsKey(worldName)) {
            Map<String, Object> worldRotations = this.currentRotations.get(worldName);
            worldRotations.remove(guiFileName);
            this.saveStorage();
        }
    }

    public void reload() {
        this.loadStorage();
    }
}

