/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.config;

import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.config.MessagesConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;

public class BorderConfig {
    private final BorderPlus plugin;
    private boolean economyEnabled;
    private final Map<String, WorldSettings> worldSettingsMap = new HashMap<String, WorldSettings>();
    private final MessagesConfig messagesConfig;
    private boolean showTitle;
    private String preferredEconomy;
    private Sound titleSound;
    private int defaultCollectiveGoal;
    private int collectiveExpansionAmount;
    private int worldBorderExpandDuration;

    public BorderConfig(BorderPlus plugin) {
        this.plugin = plugin;
        this.messagesConfig = new MessagesConfig(plugin);
    }

    public void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.showTitle = config.getBoolean("settings.show_title", true);
        this.preferredEconomy = config.getString("settings.preferred_economy", "vault");
        this.economyEnabled = config.getBoolean("settings.economy_enabled", true);
        this.defaultCollectiveGoal = config.getInt("settings.collective_goal", 1000);
        this.collectiveExpansionAmount = config.getInt("settings.collective_expansion_amount", 100);
        this.worldBorderExpandDuration = config.getInt("settings.world_border_expand_duration", 10);
        Iterator iterator = config.getConfigurationSection("settings.worlds").getKeys(false).iterator();
        while (iterator.hasNext()) {
            HashMap<String, String> placeholders;
            String worldKey;
            String worldName = worldKey = (String)iterator.next();
            String guiName = config.getString("settings.worlds." + worldKey + ".gui");
            String collectiveGuiName = config.getString("settings.worlds." + worldKey + ".collective_gui");
            int maxRadius = config.getInt("settings.worlds." + worldKey + ".max_size", Integer.MAX_VALUE);
            String displayName = config.getString("settings.worlds." + worldKey + ".name", worldKey);
            int collectiveGoal = config.getInt("settings.worlds." + worldKey + ".collective_goal", this.defaultCollectiveGoal);
            if (worldName == null || guiName == null) {
                placeholders = new HashMap<String, String>();
                placeholders.put("worldKey", worldKey);
                this.plugin.getLogger().severe(this.messagesConfig.getMessage("world_load_error", placeholders));
                continue;
            }
            placeholders = new HashMap();
            placeholders.put("worldName", worldName);
            placeholders.put("guiName", guiName);
            BorderPlus.logInfo("Loading world: " + worldName + " with GUI: " + guiName);
            this.worldSettingsMap.put(worldName, new WorldSettings(worldName, guiName, collectiveGuiName, maxRadius, displayName, collectiveGoal));
        }
    }

    public int getCollectiveExpansionAmount() {
        return this.collectiveExpansionAmount;
    }

    public Map<String, WorldSettings> getWorldSettingsMap() {
        return this.worldSettingsMap;
    }

    public WorldSettings getWorldSettings(String worldName) {
        return this.worldSettingsMap.get(worldName);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        return this.messagesConfig.getMessage(key, placeholders);
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public String getPreferredEconomy() {
        return this.preferredEconomy;
    }

    public boolean isEconomyEnabled() {
        return this.economyEnabled;
    }

    public Sound getTitleSound() {
        return this.titleSound;
    }

    public int getCollectiveGoal(String worldName) {
        WorldSettings settings = this.worldSettingsMap.get(worldName);
        return settings != null && settings.getCollectiveGoal() > 0 ? settings.getCollectiveGoal() : this.defaultCollectiveGoal;
    }

    public int getCollectiveGoal() {
        return this.defaultCollectiveGoal;
    }

    public int getWorldBorderExpandDuration() {
        return this.worldBorderExpandDuration;
    }

    public static class WorldSettings {
        private final String worldName;
        private final String guiName;
        private final String collectiveGuiName;
        private final int maxRadius;
        private final String displayName;
        private final int collectiveGoal;

        public WorldSettings(String worldName, String guiName, String collectiveGuiName, int maxRadius, String displayName, int collectiveGoal) {
            this.worldName = worldName;
            this.guiName = guiName;
            this.collectiveGuiName = collectiveGuiName;
            this.maxRadius = maxRadius;
            this.displayName = displayName;
            this.collectiveGoal = collectiveGoal;
        }

        public WorldSettings(String worldName, String guiName, int maxRadius, String displayName) {
            this(worldName, guiName, null, maxRadius, displayName, -1);
        }

        public String getWorldName() {
            return this.worldName;
        }

        public String getCollectiveGuiName() {
            return this.collectiveGuiName;
        }

        public String getGuiName() {
            return this.guiName;
        }

        public int getMaxRadius() {
            return this.maxRadius;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getCollectiveGoal() {
            return this.collectiveGoal;
        }
    }
}

