/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.commands;

import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.config.BorderConfig;
import com.bobobo.plugins.borderplus.inventory.CustomInventoryHolder;
import com.bobobo.plugins.borderplus.utils.gui.WorldGUI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.WorldBorder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BorderCommand
implements CommandExecutor {
    private final BorderPlus plugin;

    public BorderCommand(BorderPlus plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String subCommand;
        if (args.length < 1) {
            this.sendMessage(sender, "usage");
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "open": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (args.length < 2) {
                        this.sendMessage((CommandSender)player, "usage_open");
                        return false;
                    }
                    String worldName = args[1].toLowerCase();
                    this.handleOpenCommand(player, worldName);
                    break;
                }
                this.sendMessage(sender, "only_players");
                break;
            }
            case "change": {
                if (!(sender instanceof Player)) {
                    this.sendMessage(sender, "only_players");
                    break;
                }
                Player player = (Player)sender;
                if (args.length < 2) {
                    this.sendMessage((CommandSender)player, "usage_change");
                    break;
                }
                this.handleChangeCommand(player, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "reload": {
                this.handleReloadCommand(sender);
                break;
            }
            case "collective": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (args.length < 2) {
                        player.sendMessage("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /borderplus collective <worldName>");
                        return true;
                    }
                    String worldName = args[1];
                    String permission = "borderplus.collective." + worldName;
                    if (player.hasPermission(permission)) {
                        this.openCollectiveGUI(player, worldName);
                        break;
                    }
                    this.sendMessage(sender, "no_permission");
                    break;
                }
                this.sendMessage(sender, "only_players");
                break;
            }
            case "rotategui": {
                this.handleRotateGUICommand(sender, args);
                break;
            }
            case "guistatus": {
                this.handleGUIStatusCommand(sender, args);
                break;
            }
            default: {
                this.sendMessage(sender, "usage");
            }
        }
        return true;
    }

    private void handleOpenCommand(Player player, String worldName) {
        String permission = "borderplus.open." + worldName;
        if (player.hasPermission(permission)) {
            this.openWorldGUI(player, worldName);
        } else {
            this.sendMessage((CommandSender)player, "no_permission");
        }
    }

    private void openCollectiveGUI(Player player, String worldName) {
        this.openGUI(player, "collective_" + worldName, worldName);
    }

    private void handleReloadCommand(CommandSender sender) {
        if (sender.hasPermission("borderplus.reload")) {
            this.plugin.reloadConfig();
            this.plugin.getBorderConfig().loadConfig();
            this.plugin.getGUIConfig().reloadConfigGUI();
            this.plugin.getMessagesConfig().reloadMessages();
            this.plugin.getGUIRotationManager().reload();
            this.sendMessage(sender, "reload_complete");
        } else {
            this.sendMessage(sender, "no_permission");
        }
    }

    private void handleChangeCommand(Player sender, String[] args) {
        double amount;
        if (!sender.hasPermission("borderplus.change")) {
            this.sendMessage((CommandSender)sender, "no_permission");
            return;
        }
        if (args.length == 0 || args.length > 2) {
            this.sendMessage((CommandSender)sender, "usage_change");
            return;
        }
        String worldName = sender.getWorld().getName();
        String numberArg = null;
        for (String arg : args) {
            if (this.isNumeric(arg)) {
                numberArg = arg;
                continue;
            }
            worldName = arg;
        }
        if (numberArg == null) {
            this.sendMessage((CommandSender)sender, "invalid_number");
            return;
        }
        try {
            amount = Double.parseDouble(numberArg);
        }
        catch (NumberFormatException ex) {
            this.sendMessage((CommandSender)sender, "invalid_number");
            return;
        }
        if (!this.isValidWorld((CommandSender)sender, worldName)) {
            return;
        }
        WorldBorder border = Bukkit.getWorld((String)worldName).getWorldBorder();
        border.setSize(border.getSize() + amount);
        HashMap<String, String> ph = new HashMap<String, String>();
        ph.put("amount", String.valueOf(amount));
        ph.put("world", worldName);
        this.sendMessage((CommandSender)sender, "border_changed", ph);
    }

    private boolean isNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        int start = 0;
        if (s.charAt(0) == '-') {
            start = 1;
        }
        if (start >= s.length()) {
            return false;
        }
        int dotIndex = s.indexOf(46, start);
        if (dotIndex == -1) {
            for (int i = start; i < s.length(); ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
        } else {
            int i;
            if (dotIndex == start || dotIndex == s.length() - 1) {
                return false;
            }
            for (i = start; i < dotIndex; ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
            for (i = dotIndex + 1; i < s.length(); ++i) {
                if (Character.isDigit(s.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    private void openWorldGUI(Player player, String worldName) {
        this.openGUI(player, worldName, worldName);
    }

    private void sendMessage(CommandSender sender, String messageKey) {
        this.sendMessage(sender, messageKey, null);
    }

    private void sendMessage(CommandSender sender, String messageKey, Map<String, String> placeholders) {
        String message = this.plugin.getMessagesConfig().getMessage(messageKey, placeholders);
        sender.sendMessage(message);
    }

    private void handleRotateGUICommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("borderplus.rotategui")) {
            this.sendMessage(sender, "no_permission");
            return;
        }
        if (args.length < 2) {
            this.sendMessage(sender, "command_rotategui_usage");
            return;
        }
        String worldName = args[1];
        if (!this.isValidWorld(sender, worldName)) {
            return;
        }
        BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldName);
        if (worldSettings == null) {
            this.sendMessage(sender, "command_world_settings_not_found", Map.of("world", worldName));
            return;
        }
        String guiFileName = args.length > 2 ? args[2] : worldSettings.getGuiName();
        this.plugin.getGUIRotationManager().forceRotateGUI(worldName, guiFileName);
        if (this.plugin.getGUIRotationManager().isManualRotationNotificationsEnabled()) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("world", worldSettings.getDisplayName());
            placeholders.put("gui", guiFileName);
            this.sendMessage(sender, "gui_rotated_manually", placeholders);
        }
    }

    private void handleGUIStatusCommand(CommandSender sender, String[] args) {
        Map<String, Object> rotations;
        String worldName;
        if (!sender.hasPermission("borderplus.guistatus")) {
            this.sendMessage(sender, "no_permission");
            return;
        }
        String string = args.length > 1 ? args[1] : (worldName = sender instanceof Player ? ((Player)sender).getWorld().getName() : "world");
        if (!this.isValidWorld(sender, worldName)) {
            return;
        }
        BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldName);
        if (worldSettings == null) {
            this.sendMessage(sender, "command_world_settings_not_found", Map.of("world", worldName));
            return;
        }
        this.sendMessage(sender, "command_gui_status_header", Map.of("world", worldSettings.getDisplayName()));
        this.sendMessage(sender, "command_gui_status_main", Map.of("gui", worldSettings.getGuiName()));
        if (worldSettings.getCollectiveGuiName() != null) {
            this.sendMessage(sender, "command_gui_status_collective", Map.of("gui", worldSettings.getCollectiveGuiName()));
        }
        if ((rotations = this.plugin.getGUIRotationManager().getCurrentRotations(worldName, worldSettings.getGuiName())) != null && !rotations.isEmpty()) {
            this.sendMessage(sender, "command_gui_status_rotations");
            for (Map.Entry<String, Object> entry : rotations.entrySet()) {
                this.sendMessage(sender, "command_gui_status_rotation_item", Map.of("key", entry.getKey(), "value", String.valueOf(entry.getValue())));
            }
        } else {
            this.sendMessage(sender, "command_gui_status_no_rotations");
        }
        long timeUntilNext = this.plugin.getGUIRotationManager().getTimeUntilNextRotation(worldName, worldSettings.getGuiName());
        if (timeUntilNext > 0L) {
            long minutes = timeUntilNext / 60L;
            long seconds = timeUntilNext % 60L;
            this.sendMessage(sender, "command_gui_status_next_rotation", Map.of("minutes", String.valueOf(minutes), "seconds", String.valueOf(seconds)));
        } else {
            this.sendMessage(sender, "command_gui_status_next_rotation_soon");
        }
    }

    private boolean isValidWorld(CommandSender sender, String worldName) {
        if (Bukkit.getWorld((String)worldName) == null) {
            this.sendMessage(sender, "invalid_world");
            return false;
        }
        return true;
    }

    private void openGUI(Player player, String guiKey, String worldName) {
        WorldGUI worldGUI = this.plugin.getGUIConfig().getWorldGUI(guiKey);
        if (worldGUI != null) {
            CustomInventoryHolder holder = worldGUI.getInventoryHolder();
            player.openInventory(holder.getInventory());
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("world", worldName);
            this.sendMessage((CommandSender)player, "gui_not_found", placeholders);
        }
    }
}

