/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus;

import ca.tweetzy.skulls.Skulls;
import com.bobobo.plugins.borderplus.commands.BorderCommand;
import com.bobobo.plugins.borderplus.commands.BorderCommandCompleter;
import com.bobobo.plugins.borderplus.config.BorderConfig;
import com.bobobo.plugins.borderplus.config.GUIConfig;
import com.bobobo.plugins.borderplus.config.MessagesConfig;
import com.bobobo.plugins.borderplus.db.SQLiteManager;
import com.bobobo.plugins.borderplus.listeners.MenuListener;
import com.bobobo.plugins.borderplus.placeholders.Placeholders;
import com.bobobo.plugins.borderplus.utils.bstats.bukkit.Metrics;
import com.bobobo.plugins.borderplus.utils.econony.EconomyHandler;
import com.bobobo.plugins.borderplus.utils.gui.GUIFileManager;
import com.bobobo.plugins.borderplus.utils.gui.GUIRotationManager;
import com.bobobo.plugins.borderplus.utils.upd.UP;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.arcaniax.hdb.api.DatabaseLoadEvent;
import net.milkbowl.vault.economy.Economy;
import org.black_ixx.playerpoints.PlayerPointsAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BorderPlus
extends JavaPlugin
implements Listener {
    private BorderConfig borderConfig;
    private GUIConfig guiConfig;
    private MessagesConfig messagesConfig;
    private SQLiteManager sqliteManager;
    private Map<String, Object> placeholderData;
    private Economy economy;
    private PlayerPointsAPI playerPointsAPI;
    private GUIRotationManager guiRotationManager;
    public static final String PREFIX = "\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m ";
    String version = this.getDescription().getVersion();

    public void onEnable() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            final ConsoleCommandSender console = this.getServer().getConsoleSender();
            console.sendMessage(" ");
            console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m ==============================");
            console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m The BorderPlus plugin is starting its journey on your server");
            console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m Version:\u001b[90m " + this.version + " \u001b[0m| Author: \u001b[90mb0b0b0\u001b[0m");
            console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m  ");
            console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m  Initialization of objects:");
            int pluginId = 23466;
            new Metrics(this, pluginId);
            this.saveDefaultConfig();
            this.messagesConfig = new MessagesConfig(this);
            this.borderConfig = new BorderConfig(this);
            this.borderConfig.loadConfig();
            GUIFileManager guiFileManager = new GUIFileManager(this);
            guiFileManager.checkAndCreateGUIs();
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> UP.checkVersion(this.version), 60L);
            boolean hasHeadDatabaseItems = this.checkForHeadDatabaseItems();
            boolean hasSkullItems = this.checkForSkullsItems();
            if (hasHeadDatabaseItems && Bukkit.getPluginManager().isPluginEnabled("HeadDatabase")) {
                console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m HeadDatabase detected and HDB items found. Waiting for HeadDatabase to load...");
                this.getServer().getPluginManager().registerEvents(new Listener(){

                    @EventHandler
                    public void onDatabaseLoad(DatabaseLoadEvent event) {
                        console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m HeadDatabase fully loaded. Loading GUI with HDB support.");
                        BorderPlus.this.guiConfig = new GUIConfig(BorderPlus.this);
                    }
                }, (Plugin)this);
            } else if (hasSkullItems && Bukkit.getPluginManager().isPluginEnabled("Skulls")) {
                console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m Skulls detected. Waiting for skulls to finish loading...");
                Bukkit.getScheduler().runTaskTimer((Plugin)this, task -> {
                    if (!Skulls.getSkullManager().isLoading()) {
                        console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m Skulls fully loaded. Loading GUI with Skulls support.");
                        this.guiConfig = new GUIConfig(this);
                        task.cancel();
                    }
                }, 0L, 20L);
            } else {
                if (Bukkit.getPluginManager().isPluginEnabled("HeadDatabase")) {
                    console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m HeadDatabase found, but no HDB items in GUI files. Loading GUI immediately.");
                } else {
                    console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m HeadDatabase and Skulls not found. Loading GUI immediately.");
                }
                this.guiConfig = new GUIConfig(this);
            }
            this.sqliteManager = new SQLiteManager(this);
            this.placeholderData = new HashMap<String, Object>();
            this.guiRotationManager = new GUIRotationManager(this);
            this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(this), (Plugin)this);
            Objects.requireNonNull(this.getCommand("borderplus")).setExecutor((CommandExecutor)new BorderCommand(this));
            Objects.requireNonNull(this.getCommand("borderplus")).setTabCompleter((TabCompleter)new BorderCommandCompleter(this));
            EconomyHandler economyHandler = new EconomyHandler(this);
            boolean economySetup = false;
            if (this.borderConfig.isEconomyEnabled()) {
                economySetup = economyHandler.setupEconomy(this.borderConfig.getPreferredEconomy());
                this.playerPointsAPI = economyHandler.getPlayerPointsAPI();
                this.economy = economyHandler.getEconomy();
                if (economySetup) {
                    console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[32mEconomy connected successfully.\u001b[0m");
                } else {
                    console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[31mEconomy is enabled in config but could not be set up!\u001b[0m");
                }
            } else {
                console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m Economy is disabled in the configuration.");
            }
            console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[32mBorderPlus plugin successfully loaded\u001b[0m");
            console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m ==============================");
            console.sendMessage(" ");
            new Placeholders(this).register();
        } else {
            this.logWarning();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onDisable() {
        if (this.guiRotationManager != null) {
            this.guiRotationManager.shutdown();
        }
    }

    public static void logInfo(String message) {
        Bukkit.getConsoleSender().sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m  " + message);
    }

    private void logWarning() {
        this.getServer().getConsoleSender().sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[31m========================================================\u001b[0m");
        this.getServer().getConsoleSender().sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m  Could not find PlaceholderAPI! Disabling plugin. ");
        this.getServer().getConsoleSender().sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[31m========================================================\u001b[0m");
    }

    private void logEconomyError() {
        ConsoleCommandSender console = this.getServer().getConsoleSender();
        console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[31mNeither PlayerPoints nor Vault found! Disabling plugin.\u001b[0m");
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
    }

    private boolean checkForHeadDatabaseItems() {
        for (String worldKey : this.borderConfig.getWorldSettingsMap().keySet()) {
            String guiFileName = this.borderConfig.getWorldSettings(worldKey).getGuiName();
            File configFile = new File(this.getDataFolder(), guiFileName);
            if (!configFile.exists()) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            for (String key : config.getConfigurationSection("menus.border_menu.items").getKeys(false)) {
                String materialString = config.getString("menus.border_menu.items." + key + ".material");
                if (materialString == null || !materialString.startsWith("hdb-")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkForSkullsItems() {
        for (String worldKey : this.borderConfig.getWorldSettingsMap().keySet()) {
            String guiFileName = this.borderConfig.getWorldSettings(worldKey).getGuiName();
            File configFile = new File(this.getDataFolder(), guiFileName);
            if (!configFile.exists()) continue;
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            for (String key : config.getConfigurationSection("menus.border_menu.items").getKeys(false)) {
                String materialString = config.getString("menus.border_menu.items." + key + ".material");
                if (materialString == null || !materialString.startsWith("skull-")) continue;
                return true;
            }
        }
        return false;
    }

    public BorderConfig getBorderConfig() {
        return this.borderConfig;
    }

    public GUIConfig getGUIConfig() {
        return this.guiConfig;
    }

    public SQLiteManager getSQLiteManager() {
        return this.sqliteManager;
    }

    public Map<String, Object> getPlaceholderData() {
        return this.placeholderData;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public MessagesConfig getMessagesConfig() {
        return this.messagesConfig;
    }

    public PlayerPointsAPI getPlayerPointsAPI() {
        return this.playerPointsAPI;
    }

    public GUIRotationManager getGUIRotationManager() {
        return this.guiRotationManager;
    }

    public void setPlaceholderData(String key, Object value) {
        this.placeholderData.put(key, value);
    }
}

