/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.utils.upd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.command.ConsoleCommandSender;

public class UP {
    private static final String VERSION_URL = "https://b0b0b0.dev/borderplusRaw.txt";
    private static final String PREFIX = "\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m ";
    private static final ConsoleCommandSender console = Bukkit.getConsoleSender();

    public static void checkVersion(String currentVersion) {
        try {
            String latestVersion = UP.fetchLatestVersion();
            if (latestVersion == null) {
                UP.logError("Failed to fetch the latest version. Skipping version check.");
                return;
            }
            if (!currentVersion.equalsIgnoreCase(latestVersion)) {
                console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m  ");
                UP.logWarning("You are using an outdated version!");
                UP.logWarning("Current version: \u001b[90m" + currentVersion + "\u001b[0m, latest version: \u001b[32m" + latestVersion + "\u001b[0m.");
                UP.logWarning("Please update the plugin. Choose one of the following links to download:");
                console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[36m1. Modrinth: \u001b[0mhttps://modrinth.com/plugin/borderplus");
                console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[36m2. Black-Minecraft: \u001b[0mhttps://bm.wtf/resources/6148/");
                console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[36m3. PaperMc: \u001b[0mhttps://hangar.papermc.io/b0b/BorderPlus");
                console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m  ");
            } else {
                UP.logInfo("You are using the latest version of the plugin! Version: \u001b[32m" + currentVersion + "\u001b[0m.");
            }
        }
        catch (Exception e) {
            UP.logError("Error during version check: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String fetchLatestVersion() {
        String string;
        URL url = new URL(VERSION_URL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            string = in.readLine().trim();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                UP.logError("Connection error to https://b0b0b0.dev/borderplusRaw.txt: " + e.getMessage());
                return null;
            }
        }
        in.close();
        return string;
    }

    private static void logInfo(String message) {
        console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[32m" + message + "\u001b[0m");
    }

    private static void logWarning(String message) {
        console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[33m" + message + "\u001b[0m");
    }

    private static void logError(String message) {
        console.sendMessage("\u001b[37m[\u001b[90mBorderPlus\u001b[37m]\u001b[0m \u001b[31m" + message + "\u001b[0m");
    }
}

