/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.placeholders;

import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.config.BorderConfig;
import com.bobobo.plugins.borderplus.listeners.MenuListener;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Placeholders
extends PlaceholderExpansion {
    private final BorderPlus plugin;

    public Placeholders(BorderPlus plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "borderplus";
    }

    @NotNull
    public String getAuthor() {
        return "Bobobo";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @Nullable
    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            return "";
        }
        if (identifier.startsWith("world_current_size_")) {
            String worldKey = identifier.replace("world_current_size_", "");
            World world = Bukkit.getWorld((String)worldKey);
            if (world != null) {
                double currentSize = world.getWorldBorder().getSize();
                return String.valueOf(currentSize);
            }
            return this.plugin.getBorderConfig().getMessage("world_not_found", null);
        }
        if (identifier.startsWith("world_max_diameter_")) {
            String worldName = identifier.replace("world_max_diameter_", "");
            BorderConfig.WorldSettings settings = this.plugin.getBorderConfig().getWorldSettings(worldName);
            return settings != null ? String.valueOf(settings.getMaxRadius()) : this.plugin.getBorderConfig().getMessage("not_found", null);
        }
        if (identifier.startsWith("world_max_size_")) {
            String worldName = identifier.replace("world_max_size_", "");
            BorderConfig.WorldSettings settings = this.plugin.getBorderConfig().getWorldSettings(worldName);
            return settings != null ? String.valueOf(settings.getMaxRadius() / 2) : this.plugin.getBorderConfig().getMessage("not_found", null);
        }
        if (identifier.startsWith("world_display_name_")) {
            String worldName = identifier.replace("world_display_name_", "");
            BorderConfig.WorldSettings settings = this.plugin.getBorderConfig().getWorldSettings(worldName);
            return settings != null ? settings.getDisplayName() : this.plugin.getBorderConfig().getMessage("world_not_found", null);
        }
        if (identifier.startsWith("borderplus_collective_progress_")) {
            String worldName = identifier.replace("borderplus_collective_progress_", "");
            int totalContributed = this.plugin.getSQLiteManager().getTotalContributed(worldName);
            int totalNeeded = this.plugin.getBorderConfig().getCollectiveGoal(worldName);
            int progress = totalNeeded > 0 ? (int)((double)totalContributed / (double)totalNeeded * 100.0) : 0;
            return String.valueOf(progress);
        }
        if (identifier.startsWith("progress_bar_")) {
            String worldName = identifier.replace("progress_bar_", "");
            int totalContributed = this.plugin.getSQLiteManager().getTotalContributed(worldName);
            int totalNeeded = this.plugin.getBorderConfig().getCollectiveGoal(worldName);
            int progress = (int)((double)totalContributed / (double)totalNeeded * 100.0);
            int progressBars = progress / 10;
            return MenuListener.ProgressView(progress, progressBars);
        }
        if (identifier.equalsIgnoreCase("collective_progress")) {
            int totalContributed = this.plugin.getSQLiteManager().getTotalContributed();
            int totalNeeded = 0;
            for (String worldName : this.plugin.getBorderConfig().getWorldSettingsMap().keySet()) {
                totalNeeded += this.plugin.getBorderConfig().getCollectiveGoal(worldName);
            }
            int progress = totalNeeded > 0 ? (int)((double)totalContributed / (double)totalNeeded * 100.0) : 0;
            return String.valueOf(progress);
        }
        if (identifier.equalsIgnoreCase("collective_player_contribution")) {
            int contribution = this.plugin.getSQLiteManager().getPlayerContribution(player.getName());
            return String.valueOf(contribution);
        }
        if (identifier.startsWith("collective_top_name_")) {
            try {
                int rankPosition = Integer.parseInt(identifier.replace("collective_top_name_", ""));
                List<Map.Entry<String, Integer>> topContributors = this.plugin.getSQLiteManager().getTopContributors(rankPosition);
                if (topContributors.size() >= rankPosition) {
                    return topContributors.get(rankPosition - 1).getKey();
                }
                return this.plugin.getBorderConfig().getMessage("no_data", null);
            }
            catch (NumberFormatException e) {
                return this.plugin.getBorderConfig().getMessage("invalid_position_number", null);
            }
        }
        if (identifier.startsWith("collective_top_amount_")) {
            try {
                int rankPosition = Integer.parseInt(identifier.replace("collective_top_amount_", ""));
                List<Map.Entry<String, Integer>> topContributors = this.plugin.getSQLiteManager().getTopContributors(rankPosition);
                if (topContributors.size() >= rankPosition) {
                    return String.valueOf(topContributors.get(rankPosition - 1).getValue());
                }
                return "0";
            }
            catch (NumberFormatException e) {
                return this.plugin.getBorderConfig().getMessage("invalid_position_number", null);
            }
        }
        switch (identifier.toLowerCase()) {
            case "player_rank": {
                int rank = this.plugin.getSQLiteManager().getPlayerRank(player.getName());
                return rank > 0 ? String.valueOf(rank) : this.plugin.getBorderConfig().getMessage("not_in_top", null);
            }
            case "world_name": {
                World world = player.getWorld();
                return world != null ? world.getName() : this.plugin.getBorderConfig().getMessage("world_not_found", null);
            }
            case "player_blocks": {
                int blocks = this.plugin.getSQLiteManager().getPlayerBlocks(player.getName());
                return String.valueOf(blocks);
            }
            case "player_radius": {
                int radiusBlocks = this.plugin.getSQLiteManager().getPlayerBlocks(player.getName());
                return String.valueOf(radiusBlocks / 2);
            }
        }
        if (identifier.startsWith("top_block_nick_")) {
            try {
                int rankPosition = Integer.parseInt(identifier.replace("top_block_nick_", ""));
                return this.plugin.getSQLiteManager().getTopDonorName(rankPosition);
            }
            catch (NumberFormatException e) {
                return this.plugin.getBorderConfig().getMessage("invalid_position_number", null);
            }
        }
        if (identifier.startsWith("top_block_rank_")) {
            try {
                int rankPosition = Integer.parseInt(identifier.replace("top_block_rank_", ""));
                return String.valueOf(this.plugin.getSQLiteManager().getTopDonorBlocks(rankPosition));
            }
            catch (NumberFormatException e) {
                return this.plugin.getBorderConfig().getMessage("invalid_position_number", null);
            }
        }
        if (identifier.startsWith("top_block_position_")) {
            try {
                int rankPosition = Integer.parseInt(identifier.replace("top_block_position_", ""));
                return String.valueOf(rankPosition);
            }
            catch (NumberFormatException e) {
                return this.plugin.getBorderConfig().getMessage("invalid_position_number", null);
            }
        }
        if (identifier.startsWith("top_block_radius_")) {
            try {
                int rankPosition = Integer.parseInt(identifier.replace("top_block_radius_", ""));
                int totalBlocks = this.plugin.getSQLiteManager().getTopDonorBlocks(rankPosition);
                return String.valueOf(totalBlocks / 2);
            }
            catch (NumberFormatException e) {
                return this.plugin.getBorderConfig().getMessage("invalid_position_number", null);
            }
        }
        return null;
    }
}

