/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.commands;

import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.inventory.CustomInventoryHolder;
import com.bobobo.plugins.borderplus.utils.gui.WorldGUI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.WorldBorder;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BorderCommand
implements CommandExecutor {
    private final BorderPlus plugin;

    public BorderCommand(BorderPlus plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String subCommand;
        if (args.length < 1) {
            this.sendMessage(sender, "usage");
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "open": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (args.length < 2) {
                        this.sendMessage((CommandSender)player, "usage_open");
                        return false;
                    }
                    String worldName = args[1].toLowerCase();
                    this.handleOpenCommand(player, worldName);
                    break;
                }
                this.sendMessage(sender, "only_players");
                break;
            }
            case "change": {
                if (!(sender instanceof Player)) {
                    this.sendMessage(sender, "only_players");
                    break;
                }
                Player player = (Player)sender;
                if (args.length < 2) {
                    this.sendMessage((CommandSender)player, "usage_change");
                    break;
                }
                this.handleChangeCommand(player, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "reload": {
                this.handleReloadCommand(sender);
                break;
            }
            case "collective": {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (args.length < 2) {
                        player.sendMessage("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /borderplus collective <worldName>");
                        return true;
                    }
                    String worldName = args[1];
                    String permission = "borderplus.collective." + worldName;
                    if (player.hasPermission(permission)) {
                        this.openCollectiveGUI(player, worldName);
                        break;
                    }
                    this.sendMessage(sender, "no_permission");
                    break;
                }
                this.sendMessage(sender, "only_players");
                break;
            }
            default: {
                this.sendMessage(sender, "usage");
            }
        }
        return true;
    }

    private void handleOpenCommand(Player player, String worldName) {
        String permission = "borderplus.open." + worldName;
        if (player.hasPermission(permission)) {
            this.openWorldGUI(player, worldName);
        } else {
            this.sendMessage((CommandSender)player, "no_permission");
        }
    }

    private void openCollectiveGUI(Player player, String worldName) {
        WorldGUI collectiveGUI = this.plugin.getGUIConfig().getWorldGUI("collective_" + worldName);
        if (collectiveGUI != null) {
            CustomInventoryHolder holder = collectiveGUI.getInventoryHolder();
            player.openInventory(holder.getInventory());
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("world", worldName);
            this.sendMessage((CommandSender)player, "gui_not_found", placeholders);
        }
    }

    private void handleReloadCommand(CommandSender sender) {
        if (sender.hasPermission("borderplus.reload")) {
            this.plugin.reloadConfig();
            this.plugin.getBorderConfig().loadConfig();
            this.plugin.getGUIConfig().reloadConfigGUI();
            this.plugin.getMessagesConfig().reloadMessages();
            this.sendMessage(sender, "reload_complete");
        } else {
            this.sendMessage(sender, "no_permission");
        }
    }

    private void handleChangeCommand(Player sender, String[] args) {
        double amount;
        if (!sender.hasPermission("borderplus.change")) {
            this.sendMessage((CommandSender)sender, "no_permission");
            return;
        }
        if (args.length == 0 || args.length > 2) {
            this.sendMessage((CommandSender)sender, "usage_change");
            return;
        }
        String worldName = sender.getWorld().getName();
        String numberArg = null;
        for (String arg : args) {
            if (this.isNumeric(arg)) {
                numberArg = arg;
                continue;
            }
            worldName = arg;
        }
        if (numberArg == null) {
            this.sendMessage((CommandSender)sender, "invalid_number");
            return;
        }
        try {
            amount = Double.parseDouble(numberArg);
        }
        catch (NumberFormatException ex) {
            this.sendMessage((CommandSender)sender, "invalid_number");
            return;
        }
        if (Bukkit.getWorld((String)worldName) == null) {
            this.sendMessage((CommandSender)sender, "invalid_world");
            return;
        }
        WorldBorder border = Bukkit.getWorld((String)worldName).getWorldBorder();
        border.setSize(border.getSize() + amount);
        HashMap<String, String> ph = new HashMap<String, String>();
        ph.put("amount", String.valueOf(amount));
        ph.put("world", worldName);
        this.sendMessage((CommandSender)sender, "border_changed", ph);
    }

    private boolean isNumeric(String s) {
        return s.matches("-?\\d+(\\.\\d+)?");
    }

    private void openWorldGUI(Player player, String worldName) {
        WorldGUI worldGUI = this.plugin.getGUIConfig().getWorldGUI(worldName);
        if (worldGUI != null) {
            CustomInventoryHolder holder = worldGUI.getInventoryHolder();
            player.openInventory(holder.getInventory());
        } else {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("world", worldName);
            this.sendMessage((CommandSender)player, "gui_not_found", placeholders);
        }
    }

    private void sendMessage(CommandSender sender, String messageKey) {
        this.sendMessage(sender, messageKey, null);
    }

    private void sendMessage(CommandSender sender, String messageKey, Map<String, String> placeholders) {
        String message = this.plugin.getMessagesConfig().getMessage(messageKey, placeholders);
        sender.sendMessage(message);
    }
}

