/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.inventoryframework.pane.util;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import xyz.alexcrea.inventoryframework.exception.XMLLoadException;

public interface Slot {
    @Contract(pure=true)
    public int getX(int var1);

    @Contract(pure=true)
    public int getY(int var1);

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static Slot deserialize(@NotNull Element element) {
        boolean hasX = element.hasAttribute("x");
        boolean hasY = element.hasAttribute("y");
        boolean hasIndex = element.hasAttribute("index");
        if (hasX && hasY && !hasIndex) {
            int y;
            int x;
            try {
                x = Integer.parseInt(element.getAttribute("x"));
                y = Integer.parseInt(element.getAttribute("y"));
            }
            catch (NumberFormatException exception) {
                throw new XMLLoadException("The x or y attribute does not have an integer as value");
            }
            return Slot.fromXY(x, y);
        }
        if (hasIndex && !hasX && !hasY) {
            int index;
            try {
                index = Integer.parseInt(element.getAttribute("index"));
            }
            catch (NumberFormatException exception) {
                throw new XMLLoadException("The index attribute does not have an integer as value");
            }
            return Slot.fromIndex(index);
        }
        throw new XMLLoadException("The combination of x, y and index attributes is invalid");
    }

    @NotNull
    @Contract(value="_, _ -> new", pure=true)
    public static Slot fromXY(int x, int y) {
        return new XY(x, y);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static Slot fromIndex(int index) {
        return new Indexed(index);
    }

    public static class XY
    implements Slot {
        private final int x;
        private final int y;

        private XY(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int getX(int length) {
            return this.x;
        }

        @Override
        public int getY(int length) {
            return this.y;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            XY xy = (XY)object;
            return this.x == xy.x && this.y == xy.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }
    }

    public static class Indexed
    implements Slot {
        private final int index;

        private Indexed(int index) {
            this.index = index;
        }

        @Override
        @Contract(pure=true)
        public int getX(int length) {
            if (length == 0) {
                throw new IllegalArgumentException("Length may not be zero");
            }
            return this.index % length;
        }

        @Override
        @Contract(pure=true)
        public int getY(int length) {
            if (length == 0) {
                throw new IllegalArgumentException("Length may not be zero");
            }
            return this.index / length;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Indexed indexed = (Indexed)object;
            return this.index == indexed.index;
        }

        public int hashCode() {
            return this.index;
        }
    }
}

