/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.util;

import io.delilaheve.CustomAnvil;
import io.delilaheve.util.ConfigOptions;
import io.delilaheve.util.EnchantmentUtil;
import io.delilaheve.util.ItemUtil;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.config.WorkPenaltyType;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.group.ConflictType;
import xyz.alexcrea.cuanvil.util.AnvilUseType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J(\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014J\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fJ\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lxyz/alexcrea/cuanvil/util/AnvilXpUtil;", "", "<init>", "()V", "EXCLUSIVE_PENALTY_PREFIX", "", "setAnvilInvXp", "", "inventory", "Lorg/bukkit/inventory/AnvilInventory;", "view", "Lorg/bukkit/inventory/InventoryView;", "player", "Lorg/bukkit/entity/HumanEntity;", "anvilCost", "", "ignoreRules", "", "calculatePenalty", "left", "Lorg/bukkit/inventory/ItemStack;", "right", "result", "useType", "Lxyz/alexcrea/cuanvil/util/AnvilUseType;", "exclusivePenaltyKey", "Lorg/bukkit/NamespacedKey;", "setExclusivePenalty", "resultPenalty", "findExclusivePenalty", "item", "getRightValues", "calculateLevelForXp", "xp", "calculateMinimumLevelForXp", "calculateXpForLevel", "level", "CustomAnvil"})
public final class AnvilXpUtil {
    @NotNull
    public static final AnvilXpUtil INSTANCE = new AnvilXpUtil();
    @NotNull
    public static final String EXCLUSIVE_PENALTY_PREFIX = "repair_cost";

    private AnvilXpUtil() {
    }

    public final void setAnvilInvXp(@NotNull AnvilInventory inventory, @NotNull InventoryView view, @NotNull HumanEntity player, int anvilCost, boolean ignoreRules) {
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        Intrinsics.checkNotNullParameter(view, "view");
        Intrinsics.checkNotNullParameter(player, "player");
        int finalAnvilCost = !ignoreRules && !ConfigOptions.INSTANCE.getDoRemoveCostLimit() && ConfigOptions.INSTANCE.getDoCapCost() ? Math.min(anvilCost, ConfigOptions.INSTANCE.getMaxAnvilCost()) : anvilCost;
        int maximumRepairCost = ConfigOptions.INSTANCE.getDoRemoveCostLimit() || ignoreRules ? Integer.MAX_VALUE : ConfigOptions.INSTANCE.getMaxAnvilCost() + 1;
        inventory.setMaximumRepairCost(maximumRepairCost);
        inventory.setRepairCost(finalAnvilCost);
        DependencyManager.INSTANCE.getScheduler().scheduleOnEntity((Plugin)CustomAnvil.Companion.getInstance(), (Entity)player, () -> AnvilXpUtil.setAnvilInvXp$lambda$0(inventory, maximumRepairCost, finalAnvilCost, player));
    }

    public static /* synthetic */ void setAnvilInvXp$default(AnvilXpUtil anvilXpUtil, AnvilInventory anvilInventory, InventoryView inventoryView, HumanEntity humanEntity, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        anvilXpUtil.setAnvilInvXp(anvilInventory, inventoryView, humanEntity, n, bl);
    }

    public final int calculatePenalty(@NotNull ItemStack left, @Nullable ItemStack right, @NotNull ItemStack result, @NotNull AnvilUseType useType) {
        ItemMeta itemMeta;
        int n;
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(result, "result");
        Intrinsics.checkNotNullParameter((Object)useType, "useType");
        WorkPenaltyType.WorkPenaltyPart penaltyType = ConfigOptions.INSTANCE.workPenaltyPart(useType);
        ItemMeta itemMeta2 = left.getItemMeta();
        Repairable repairable = itemMeta2 instanceof Repairable ? (Repairable)itemMeta2 : null;
        int leftPenalty = repairable != null ? repairable.getRepairCost() : 0;
        int leftExclusivePenalty = this.findExclusivePenalty(left, useType);
        if (right == null) {
            n = 0;
        } else {
            ItemMeta itemMeta3 = right.getItemMeta();
            Repairable repairable2 = itemMeta3 instanceof Repairable ? (Repairable)itemMeta3 : null;
            n = repairable2 != null ? repairable2.getRepairCost() : 0;
        }
        int rightPenalty = n;
        int rightExclusivePenalty = this.findExclusivePenalty(right, useType);
        if (penaltyType.penaltyIncrease()) {
            ItemMeta itemMeta4 = result.getItemMeta();
            if (itemMeta4 != null) {
                ItemMeta it = itemMeta4;
                boolean bl = false;
                Repairable repairable3 = it instanceof Repairable ? (Repairable)it : null;
                if (repairable3 != null) {
                    repairable3.setRepairCost(RangesKt.coerceAtLeast(leftPenalty, rightPenalty) * 2 + 1);
                }
                result.setItemMeta(it);
            }
        }
        if (penaltyType.exclusivePenaltyIncrease()) {
            int resultPenalty = RangesKt.coerceAtLeast(leftExclusivePenalty, rightExclusivePenalty) * 2 + 1;
            this.setExclusivePenalty(result, resultPenalty, useType);
        }
        Repairable repairable4 = (itemMeta = result.getItemMeta()) instanceof Repairable ? (Repairable)itemMeta : null;
        CustomAnvil.Companion.log("Calculated penalty: leftPenalty: " + leftPenalty + ", rightPenalty: " + rightPenalty + ", result penalty: " + (repairable4 != null ? Integer.valueOf(repairable4.getRepairCost()) : "none"));
        int resultSum = 0;
        if (penaltyType.penaltyAdditive()) {
            resultSum += leftPenalty + rightPenalty;
        }
        if (penaltyType.exclusivePenaltyAdditive()) {
            resultSum += leftExclusivePenalty + rightExclusivePenalty;
        }
        return resultSum;
    }

    private final NamespacedKey exclusivePenaltyKey(AnvilUseType useType) {
        return new NamespacedKey((Plugin)CustomAnvil.Companion.getInstance(), "repair_cost_" + useType.getTypeName());
    }

    private final void setExclusivePenalty(ItemStack result, int resultPenalty, AnvilUseType useType) {
        NamespacedKey key = this.exclusivePenaltyKey(useType);
        ItemMeta itemMeta = result.getItemMeta();
        Intrinsics.checkNotNull(itemMeta);
        ItemMeta meta = itemMeta;
        meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)resultPenalty);
        result.setItemMeta(meta);
    }

    private final int findExclusivePenalty(ItemStack item, AnvilUseType useType) {
        if (item == null || !item.hasItemMeta()) {
            return 0;
        }
        NamespacedKey key = this.exclusivePenaltyKey(useType);
        ItemMeta itemMeta = item.getItemMeta();
        Intrinsics.checkNotNull(itemMeta);
        ItemMeta meta = itemMeta;
        Integer n = (Integer)meta.getPersistentDataContainer().get(key, PersistentDataType.INTEGER);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public final int getRightValues(@NotNull ItemStack right, @NotNull ItemStack result) {
        Intrinsics.checkNotNullParameter(right, "right");
        Intrinsics.checkNotNullParameter(result, "result");
        int illegalPenalty = 0;
        int rightValue = 0;
        boolean rightIsFormBook = ItemUtil.INSTANCE.isEnchantedBook(right);
        Map<CAEnchantment, Integer> resultEnchs = ItemUtil.INSTANCE.findEnchantments(result);
        HashMap<CAEnchantment, Integer> resultEnchsKeys = new HashMap<CAEnchantment, Integer>(resultEnchs);
        for (Map.Entry<CAEnchantment, Integer> enchantment : ItemUtil.INSTANCE.findEnchantments(right).entrySet()) {
            if (!((Map)resultEnchsKeys).containsKey(enchantment.getKey())) {
                ((Map)resultEnchsKeys).put(enchantment.getKey(), enchantment.getValue());
                ConflictType conflictType = ConfigHolder.CONFLICT_HOLDER.getConflictManager().isConflicting((Map<CAEnchantment, Integer>)resultEnchsKeys, result, enchantment.getKey());
                resultEnchsKeys.remove(enchantment.getKey());
                if (ConflictType.ENCHANTMENT_CONFLICT != conflictType) continue;
                illegalPenalty += ConfigOptions.INSTANCE.getSacrificeIllegalCost();
                CustomAnvil.Companion.verboseLog("Big conflict. Adding illegal price penalty");
                continue;
            }
            Integer n = resultEnchs.get(enchantment.getKey());
            Intrinsics.checkNotNull(n);
            int resultLevel = ((Number)n).intValue();
            int enchantmentMultiplier = ConfigOptions.INSTANCE.enchantmentValue(enchantment.getKey(), rightIsFormBook);
            int value = resultLevel * enchantmentMultiplier;
            CustomAnvil.Companion.log("Value for " + EnchantmentUtil.INSTANCE.getEnchantmentName(enchantment.getKey()) + " level " + enchantment.getValue() + " is " + value + " (" + resultLevel + " * " + enchantmentMultiplier + ")");
            rightValue += value;
        }
        CustomAnvil.Companion.log("Calculated right values: rightValue: " + rightValue + ", illegalPenalty: " + illegalPenalty);
        return rightValue + illegalPenalty;
    }

    public final int calculateLevelForXp(int xp) {
        int n;
        if (xp <= 352) {
            n = (int)(Math.sqrt(xp + 9) - (double)3);
        } else if (xp <= 1507) {
            double inner = 0.4 * ((double)xp - 195.975);
            n = (int)(8.1 + Math.sqrt(inner));
        } else {
            double inner = 0.2222222222222222 * ((double)xp - 752.9861111111111);
            n = (int)(18.055555555555557 + Math.sqrt(inner));
        }
        return n;
    }

    public final int calculateMinimumLevelForXp(int xp) {
        return this.calculateLevelForXp(xp - 1) + 1;
    }

    public final int calculateXpForLevel(int level) {
        return level <= 16 ? level * level + 6 * level : (level <= 31 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + (double)360) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + (double)2220));
    }

    private static final void setAnvilInvXp$lambda$0(AnvilInventory $inventory, int $maximumRepairCost, int $finalAnvilCost, HumanEntity $player) {
        $inventory.setMaximumRepairCost($maximumRepairCost);
        $inventory.setRepairCost($finalAnvilCost);
        if (!($player instanceof Player)) {
            return;
        }
        if (((Player)$player).getGameMode() != GameMode.CREATIVE) {
            boolean bypassToExpensive = ConfigOptions.INSTANCE.getDoReplaceTooExpensive() && $finalAnvilCost >= 40 && $finalAnvilCost < $inventory.getMaximumRepairCost();
            DependencyManager.INSTANCE.getPacketManager().setInstantBuild((Player)$player, bypassToExpensive);
        }
        ((Player)$player).updateInventory();
    }
}

