/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.global;

import io.delilaheve.util.ConfigOptions;
import java.util.Arrays;
import java.util.Locale;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.gui.config.global.AbstractEnchantConfigGui;
import xyz.alexcrea.cuanvil.gui.config.settings.IntSettingsGui;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;

public class EnchantMergeLimitConfigGui
extends AbstractEnchantConfigGui<IntSettingsGui.IntSettingFactory> {
    private static final String SECTION_NAME = "disable-merge-over";
    private static EnchantMergeLimitConfigGui INSTANCE = null;

    @Nullable
    public static EnchantMergeLimitConfigGui getInstance() {
        return INSTANCE;
    }

    public EnchantMergeLimitConfigGui() {
        super("\u00a78Enchantment Maximum Merge Level");
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        this.init();
    }

    @Override
    public IntSettingsGui.IntSettingFactory createFactory(final CAEnchantment enchant) {
        String key = enchant.getKey().toString().toLowerCase(Locale.ROOT);
        String prettyKey = CasedStringUtil.snakeToUpperSpacedCase(key.replace(":", "_"));
        return new IntSettingsGui.IntSettingFactory(prettyKey + " Merge Limit", this, "disable-merge-over." + key, ConfigHolder.DEFAULT_CONFIG, Arrays.asList("\u00a77Maximum merge level for for " + prettyKey, "", "\u00a77For example, if set to \u00a7e2\u00a77, \u00a7alvl1 \u00a77+ \u00a7alvl1 \u00a77of will give a \u00a7alvl2", "\u00a77But \u00a7alvl2 \u00a77+ \u00a7alvl2 \u00a77will not give a \u00a7clv3\u00a77.", "\u00a77Will still not merge above max enchantment level", "\u00a7e-1 \u00a77(default) will set the merge limit to enchantment's maximum level"), -1, 255, -1, new int[]{1, 5, 10, 50, 100}){

            @Override
            public int getConfiguredValue() {
                return ConfigOptions.INSTANCE.maxBeforeMergeDisabled(enchant);
            }
        };
    }

    @Override
    public GuiItem itemFromFactory(CAEnchantment enchantment, IntSettingsGui.IntSettingFactory inventoryFactory) {
        return inventoryFactory.getItem(Material.ENCHANTED_BOOK, inventoryFactory.getTitle());
    }
}

