/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.global;

import io.delilaheve.util.ConfigOptions;
import java.util.Collections;
import java.util.Locale;
import org.bukkit.Material;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.gui.config.global.AbstractEnchantConfigGui;
import xyz.alexcrea.cuanvil.gui.config.settings.IntSettingsGui;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;

public class EnchantLimitConfigGui
extends AbstractEnchantConfigGui<IntSettingsGui.IntSettingFactory> {
    private static final String SECTION_NAME = "enchant_limits";
    private static EnchantLimitConfigGui INSTANCE = null;

    @Nullable
    public static EnchantLimitConfigGui getInstance() {
        return INSTANCE;
    }

    public EnchantLimitConfigGui() {
        super("\u00a78Enchantment Level Limit");
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        this.init();
    }

    @Override
    public IntSettingsGui.IntSettingFactory createFactory(final CAEnchantment enchant) {
        String key = enchant.getKey().toString().toLowerCase(Locale.ROOT);
        String prettyKey = CasedStringUtil.snakeToUpperSpacedCase(key.replace(":", "_"));
        return new IntSettingsGui.IntSettingFactory(prettyKey + " Limit", this, "enchant_limits." + key, ConfigHolder.DEFAULT_CONFIG, Collections.singletonList("\u00a77Maximum applied level of " + prettyKey), 0, 255, enchant.defaultMaxLevel(), new int[]{1, 5, 10, 50, 100}){

            @Override
            public int getConfiguredValue() {
                return ConfigOptions.INSTANCE.enchantLimit(enchant);
            }
        };
    }

    @Override
    public GuiItem itemFromFactory(CAEnchantment enchantment, IntSettingsGui.IntSettingFactory inventoryFactory) {
        return inventoryFactory.getItem(Material.ENCHANTED_BOOK, inventoryFactory.getTitle());
    }
}

