/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.global.AbstractEnchantConfigGui;
import xyz.alexcrea.cuanvil.gui.config.settings.EnchantCostSettingsGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;

public class EnchantCostConfigGui
extends AbstractEnchantConfigGui<EnchantCostSettingsGui.EnchantCostSettingFactory> {
    private static final String SECTION_NAME = "enchant_values";
    private static EnchantCostConfigGui INSTANCE = null;

    @Nullable
    public static EnchantCostConfigGui getInstance() {
        return INSTANCE;
    }

    public EnchantCostConfigGui() {
        super("\u00a78Enchantment Level Cost");
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        this.init();
    }

    @Override
    public EnchantCostSettingsGui.EnchantCostSettingFactory createFactory(CAEnchantment enchant) {
        String key = enchant.getKey().toString().toLowerCase(Locale.ENGLISH);
        String prettyKey = CasedStringUtil.snakeToUpperSpacedCase(key.replace(":", "_"));
        return new EnchantCostSettingsGui.EnchantCostSettingFactory(prettyKey + " Cost", (ValueUpdatableGui)this, "enchant_values." + key, (ConfigHolder)ConfigHolder.DEFAULT_CONFIG, Arrays.asList("\u00a77How many level should " + prettyKey, "\u00a77cost when applied by book or by another item."), enchant, 0, 255, 1, 10, 50);
    }

    @Override
    public GuiItem itemFromFactory(CAEnchantment enchantment, EnchantCostSettingsGui.EnchantCostSettingFactory factory) {
        int itemCost = factory.getConfiguredValue();
        int bookCost = factory.getConfiguredBookValue();
        String itemName = "\u00a7a" + factory.getTitle();
        ItemStack item = new ItemStack(Material.ENCHANTED_BOOK);
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77Item  Cost: \u00a7e" + itemCost);
        lore.add("\u00a77Book Cost: \u00a7e" + bookCost);
        List<String> displayLore = factory.getDisplayLore();
        if (!displayLore.isEmpty()) {
            lore.add("");
            lore.addAll(displayLore);
        }
        itemMeta.setDisplayName(itemName);
        itemMeta.setLore(lore);
        item.setItemMeta(itemMeta);
        return GuiGlobalItems.openSettingGuiItem(item, factory);
    }
}

