/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.enchant;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.enchant.bulk.BukkitEnchantBulkOperation;
import xyz.alexcrea.cuanvil.enchant.bulk.BulkCleanEnchantOperation;
import xyz.alexcrea.cuanvil.enchant.bulk.BulkGetEnchantOperation;
import xyz.alexcrea.cuanvil.enchant.wrapped.CABukkitEnchantment;

public class CAEnchantmentRegistry {
    private static final CAEnchantmentRegistry instance = new CAEnchantmentRegistry();
    private final HashMap<NamespacedKey, CAEnchantment> byKeyMap = new HashMap();
    private final HashMap<String, List<CAEnchantment>> byNameMap = new HashMap();
    private final SortedSet<CAEnchantment> nameSortedEnchantments = new TreeSet<CAEnchantment>(Comparator.comparing(CAEnchantment::getName));
    private final List<CAEnchantment> unoptimisedGetValues = new ArrayList<CAEnchantment>();
    private final List<CAEnchantment> unoptimisedCleanValues = new ArrayList<CAEnchantment>();
    private final List<BulkGetEnchantOperation> optimisedGetOperators = new ArrayList<BulkGetEnchantOperation>();
    private final List<BulkCleanEnchantOperation> optimisedCleanOperators = new ArrayList<BulkCleanEnchantOperation>();
    private static boolean hasWarnedRegistering = false;

    public static CAEnchantmentRegistry getInstance() {
        return instance;
    }

    private CAEnchantmentRegistry() {
    }

    public void registerBukkit() {
        for (Enchantment enchantment : Enchantment.values()) {
            this.register(new CABukkitEnchantment(enchantment));
        }
        BukkitEnchantBulkOperation bukkitOperation = new BukkitEnchantBulkOperation();
        this.optimisedGetOperators.add(bukkitOperation);
        this.optimisedCleanOperators.add(bukkitOperation);
    }

    public boolean register(@NotNull CAEnchantment enchantment) {
        if (this.byKeyMap.containsKey(enchantment.getKey())) {
            if (Objects.equals(enchantment, this.byKeyMap.get(enchantment.getKey()))) {
                return false;
            }
            if (ConfigHolder.DEFAULT_CONFIG.getConfig().getBoolean("caution_secret_do_not_log_duplicated_registered_key", false)) {
                return false;
            }
            CustomAnvil.instance.getLogger().log(Level.WARNING, "Duplicate distinct registered enchantment. This should NOT happen any time.\nIf you are a custom anvil developer: Maybe custom anvil detected your enchantment as a bukkit enchantment. you should maybe remove enchantment with the same key before registering yours", new IllegalStateException("enchantment " + String.valueOf(enchantment.getKey()) + " was already registered"));
            return false;
        }
        if (!hasWarnedRegistering && this.byNameMap.containsKey(enchantment.getName())) {
            hasWarnedRegistering = true;
            CustomAnvil.instance.getLogger().log(Level.WARNING, "Duplicate registered enchantment name. Please check that configuration is using namespace.");
        }
        this.byKeyMap.put(enchantment.getKey(), enchantment);
        this.byNameMap.putIfAbsent(enchantment.getName(), new ArrayList());
        this.byNameMap.get(enchantment.getName()).add(enchantment);
        this.nameSortedEnchantments.add(enchantment);
        if (!enchantment.isGetOptimised()) {
            this.unoptimisedGetValues.add(enchantment);
        }
        if (!enchantment.isCleanOptimised()) {
            this.unoptimisedCleanValues.add(enchantment);
        }
        return true;
    }

    public boolean unregister(@Nullable CAEnchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        this.byKeyMap.remove(enchantment.getKey());
        this.byNameMap.get(enchantment.getName()).remove(enchantment);
        this.nameSortedEnchantments.remove(enchantment);
        this.unoptimisedGetValues.remove(enchantment);
        this.unoptimisedCleanValues.remove(enchantment);
        return true;
    }

    @Nullable
    public CAEnchantment getByKey(@NotNull NamespacedKey key) {
        return this.byKeyMap.get(key);
    }

    @Deprecated(since="1.6.3")
    @Nullable
    public CAEnchantment getByName(@NotNull String name) {
        List<CAEnchantment> enchantments = this.getListByName(name);
        if (enchantments.isEmpty()) {
            return null;
        }
        return enchantments.get(0);
    }

    @NotNull
    public List<CAEnchantment> getListByName(@NotNull String name) {
        return this.byNameMap.getOrDefault(name, Collections.emptyList());
    }

    @NotNull
    public Collection<CAEnchantment> values() {
        return this.byKeyMap.values();
    }

    public Map<NamespacedKey, CAEnchantment> registeredEnchantments() {
        return Collections.unmodifiableMap(this.byKeyMap);
    }

    @NotNull
    public List<CAEnchantment> unoptimisedGetValues() {
        return this.unoptimisedGetValues;
    }

    @NotNull
    public List<CAEnchantment> unoptimisedCleanValues() {
        return this.unoptimisedCleanValues;
    }

    public List<BulkCleanEnchantOperation> getOptimisedCleanOperators() {
        return this.optimisedCleanOperators;
    }

    public List<BulkGetEnchantOperation> getOptimisedGetOperators() {
        return this.optimisedGetOperators;
    }

    public SortedSet<CAEnchantment> getNameSortedEnchantments() {
        return Collections.unmodifiableSortedSet(this.nameSortedEnchantments);
    }
}

