/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.enchant;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.enchant.CAEnchantmentRegistry;
import xyz.alexcrea.cuanvil.enchant.EnchantmentRarity;
import xyz.alexcrea.cuanvil.enchant.bulk.BulkCleanEnchantOperation;
import xyz.alexcrea.cuanvil.enchant.bulk.BulkGetEnchantOperation;
import xyz.alexcrea.cuanvil.group.EnchantConflictGroup;

public interface CAEnchantment {
    @NotNull
    public EnchantmentRarity defaultRarity();

    @NotNull
    public NamespacedKey getKey();

    @NotNull
    public String getName();

    public int defaultMaxLevel();

    public boolean isGetOptimised();

    public boolean isCleanOptimised();

    public boolean isAllowed(@NotNull HumanEntity var1);

    public void addConflict(@NotNull EnchantConflictGroup var1);

    public void removeConflict(@NotNull EnchantConflictGroup var1);

    public void clearConflict();

    @NotNull
    public Collection<EnchantConflictGroup> getConflicts();

    default public int getLevel(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 0;
        }
        return this.getLevel(item, meta);
    }

    public int getLevel(@NotNull ItemStack var1, @NotNull ItemMeta var2);

    public boolean isEnchantmentPresent(@NotNull ItemStack var1);

    public boolean isEnchantmentPresent(@NotNull ItemStack var1, @NotNull ItemMeta var2);

    public void addEnchantmentUnsafe(@NotNull ItemStack var1, int var2);

    public void removeFrom(@NotNull ItemStack var1);

    public static void clearEnchants(@NotNull ItemStack item) {
        for (BulkCleanEnchantOperation cleanOperator : CAEnchantmentRegistry.getInstance().getOptimisedCleanOperators()) {
            cleanOperator.bulkClear(item);
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        for (BulkCleanEnchantOperation cleanOperator : CAEnchantmentRegistry.getInstance().getOptimisedCleanOperators()) {
            cleanOperator.bulkClear(item, meta);
        }
        item.setItemMeta(meta);
        for (CAEnchantment enchant : CAEnchantmentRegistry.getInstance().unoptimisedCleanValues()) {
            if (!enchant.isEnchantmentPresent(item)) continue;
            enchant.removeFrom(item);
        }
    }

    public static Map<CAEnchantment, Integer> getEnchants(@NotNull ItemStack item) {
        HashMap<CAEnchantment, Integer> enchantments = new HashMap<CAEnchantment, Integer>();
        CAEnchantmentRegistry registry = CAEnchantmentRegistry.getInstance();
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return enchantments;
        }
        for (BulkGetEnchantOperation getOperator : CAEnchantmentRegistry.getInstance().getOptimisedGetOperators()) {
            getOperator.bulkGet(enchantments, item, meta);
        }
        CAEnchantment.findEnchantsFromSelectedList(item, meta, enchantments, registry.unoptimisedGetValues());
        return enchantments;
    }

    public static void findEnchantsFromSelectedList(@NotNull ItemStack item, @NotNull ItemMeta meta, @NotNull Map<CAEnchantment, Integer> enchantments, @NotNull Collection<CAEnchantment> enchantmentToTest) {
        for (CAEnchantment enchantment : enchantmentToTest) {
            if (!enchantment.isEnchantmentPresent(item, meta)) continue;
            enchantments.put(enchantment, enchantment.getLevel(item, meta));
        }
    }

    @Nullable
    public static CAEnchantment getByKey(@NotNull NamespacedKey key) {
        return CAEnchantmentRegistry.getInstance().getByKey(key);
    }

    @Deprecated(since="1.6.3")
    @Nullable
    public static CAEnchantment getByName(@NotNull String name) {
        return CAEnchantmentRegistry.getInstance().getByName(name);
    }

    public static List<CAEnchantment> getListByName(@NotNull String name) {
        return CAEnchantmentRegistry.getInstance().getListByName(name);
    }
}

