/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.dependency.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J=\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u00072\u001a\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\n0\r\"\u0006\u0012\u0002\b\u00030\nH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u001a*\u00020\u00182\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u001cJ\f\u0010\u001e\u001a\u0004\u0018\u00010\u0017*\u00020\u0018J\u0014\u0010\u001f\u001a\u00020\u001a*\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u0017R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lxyz/alexcrea/cuanvil/dependency/util/PlatformUtil;", "", "<init>", "()V", "hasClass", "", "className", "", "hasMethod", "clazz", "Ljava/lang/Class;", "name", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Z", "isPaper", "()Z", "isFolia", "legacy_mm", "Lnet/kyori/adventure/text/serializer/legacy/LegacyComponentSerializer;", "Lorg/jetbrains/annotations/NotNull;", "componentLore", "", "Lnet/kyori/adventure/text/Component;", "Lorg/bukkit/inventory/meta/ItemMeta;", "setComponentLore", "", "lore", "", "useCustomName", "componentDisplayName", "setComponentDisplayName", "component", "nms-common"})
public final class PlatformUtil {
    @NotNull
    public static final PlatformUtil INSTANCE = new PlatformUtil();
    private static final boolean isPaper = INSTANCE.hasClass("com.destroystokyo.paper.PaperConfig") || INSTANCE.hasClass("io.papermc.paper.configuration.Configuration");
    private static final boolean isFolia = INSTANCE.hasClass("io.papermc.paper.threadedregions.RegionizedServer");
    @NotNull
    private static final LegacyComponentSerializer legacy_mm;
    private static final boolean useCustomName;

    private PlatformUtil() {
    }

    private final boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private final boolean hasMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            clazz.getDeclaredMethod(name, Arrays.copyOf(parameterTypes, parameterTypes.length));
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public final boolean isPaper() {
        return isPaper;
    }

    public final boolean isFolia() {
        return isFolia;
    }

    @NotNull
    public final List<Component> componentLore(@NotNull ItemMeta $this$componentLore) {
        List list;
        Intrinsics.checkNotNullParameter($this$componentLore, "<this>");
        List lore = null;
        if (isPaper) {
            lore = $this$componentLore.lore();
        } else {
            List list2 = $this$componentLore.getLore();
            if (list2 == null) {
                return new ArrayList();
            }
            List legacyLores = list2;
            lore = new ArrayList(legacyLores.size());
            for (String legacyLore : legacyLores) {
                ((ArrayList)lore).add(legacy_mm.deserialize(legacyLore));
            }
        }
        if ((list = lore) == null) {
            list = new ArrayList();
        }
        return list;
    }

    public final void setComponentLore(@NotNull ItemMeta $this$setComponentLore, @NotNull List<? extends Component> lore) {
        Intrinsics.checkNotNullParameter($this$setComponentLore, "<this>");
        Intrinsics.checkNotNullParameter(lore, "lore");
        if (isPaper) {
            $this$setComponentLore.lore(lore);
        } else {
            ArrayList<String> legacyLore = new ArrayList<String>(lore.size());
            for (Component component : lore) {
                legacyLore.add(component == null ? null : legacy_mm.serialize(component));
            }
            $this$setComponentLore.setLore((List)legacyLore);
        }
    }

    @Nullable
    public final Component componentDisplayName(@NotNull ItemMeta $this$componentDisplayName) {
        Intrinsics.checkNotNullParameter($this$componentDisplayName, "<this>");
        if (useCustomName) {
            if (!$this$componentDisplayName.hasCustomName()) {
                return null;
            }
            return $this$componentDisplayName.customName();
        }
        if (isPaper) {
            if (!$this$componentDisplayName.hasDisplayName()) {
                return null;
            }
            return $this$componentDisplayName.displayName();
        }
        if (!$this$componentDisplayName.hasDisplayName()) {
            return null;
        }
        String string = $this$componentDisplayName.getDisplayName();
        Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
        String legacy = string;
        return legacy_mm.deserialize(legacy);
    }

    public final void setComponentDisplayName(@NotNull ItemMeta $this$setComponentDisplayName, @Nullable Component component) {
        Intrinsics.checkNotNullParameter($this$setComponentDisplayName, "<this>");
        if (useCustomName) {
            $this$setComponentDisplayName.customName(component);
        } else if (isPaper) {
            $this$setComponentDisplayName.displayName(component);
        } else {
            if (component == null) {
                $this$setComponentDisplayName.setDisplayName(null);
                return;
            }
            String string = legacy_mm.serialize(component);
            Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
            String legacy = string;
            $this$setComponentDisplayName.setDisplayName(legacy);
        }
    }

    static {
        LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacySection();
        Intrinsics.checkNotNullExpressionValue(legacyComponentSerializer, "legacySection(...)");
        legacy_mm = legacyComponentSerializer;
        useCustomName = INSTANCE.hasMethod(ItemStack.class, "customName", new Class[0]);
    }
}

