/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.dependency.plugins;

import com.jankominek.disenchantment.Disenchantment;
import com.jankominek.disenchantment.events.DisenchantClickEvent;
import com.jankominek.disenchantment.events.DisenchantEvent;
import com.jankominek.disenchantment.events.ShatterClickEvent;
import com.jankominek.disenchantment.events.ShatterEvent;
import com.jankominek.disenchantment.listeners.DisenchantClickListener;
import com.jankominek.disenchantment.listeners.ShatterClickListener;
import io.delilaheve.CustomAnvil;
import java.lang.reflect.Field;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.util.AnvilXpUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0014\u0010\u0006\u001a\u00020\u00052\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lxyz/alexcrea/cuanvil/dependency/plugins/DisenchantmentDependency;", "", "<init>", "()V", "redirectListeners", "", "unregisterStaticDisenchantmentListener", "clazz", "Lkotlin/reflect/KClass;", "testPrepareAnvil", "", "event", "Lorg/bukkit/event/inventory/PrepareAnvilEvent;", "player", "Lorg/bukkit/entity/HumanEntity;", "testAnvilResult", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "inventory", "Lorg/bukkit/inventory/AnvilInventory;", "testAnvilInventoryChange", "previous", "Lorg/bukkit/inventory/ItemStack;", "CustomAnvil"})
public final class DisenchantmentDependency {
    public DisenchantmentDependency() {
        CustomAnvil.Companion.getInstance().getLogger().info("Disenchantment Detected !");
    }

    public final void redirectListeners() {
        PrepareAnvilEvent.getHandlerList().unregister((Plugin)Disenchantment.plugin);
        try {
            this.unregisterStaticDisenchantmentListener(Reflection.getOrCreateKotlinClass(ShatterClickListener.class));
            this.unregisterStaticDisenchantmentListener(Reflection.getOrCreateKotlinClass(DisenchantClickListener.class));
        }
        catch (Exception e) {
            CustomAnvil.Companion.getInstance().getLogger().log(Level.SEVERE, "Could not initialize disenchantment supportplease report this bug to the developer", e);
        }
    }

    private final void unregisterStaticDisenchantmentListener(KClass<?> clazz) {
        Field field = JvmClassMappingKt.getJavaClass(clazz).getDeclaredField("listener");
        field.setAccessible(true);
        Object object = field.get(null);
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bukkit.event.Listener");
        Listener listener = (Listener)object;
        InventoryClickEvent.getHandlerList().unregister(listener);
    }

    public final boolean testPrepareAnvil(@NotNull PrepareAnvilEvent event, @NotNull HumanEntity player) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(player, "player");
        ItemStack previousResult = event.getResult();
        event.setResult(null);
        DisenchantEvent.onEvent((Event)((Event)event));
        if (event.getResult() != null) {
            CustomAnvil.Companion.log("Detected pre anvil item extract bypass.");
            AnvilInventory anvilInventory = event.getInventory();
            Intrinsics.checkNotNullExpressionValue(anvilInventory, "getInventory(...)");
            InventoryView inventoryView = event.getView();
            Intrinsics.checkNotNullExpressionValue(inventoryView, "getView(...)");
            AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, anvilInventory, inventoryView, player, event.getInventory().getRepairCost(), false, 16, null);
            return true;
        }
        ShatterEvent.onEvent((Event)((Event)event));
        if (event.getResult() != null) {
            CustomAnvil.Companion.log("Detected pre anvil split enchant bypass.");
            AnvilInventory anvilInventory = event.getInventory();
            Intrinsics.checkNotNullExpressionValue(anvilInventory, "getInventory(...)");
            InventoryView inventoryView = event.getView();
            Intrinsics.checkNotNullExpressionValue(inventoryView, "getView(...)");
            AnvilXpUtil.setAnvilInvXp$default(AnvilXpUtil.INSTANCE, anvilInventory, inventoryView, player, event.getInventory().getRepairCost(), false, 16, null);
            return true;
        }
        event.setResult(previousResult);
        return false;
    }

    public final boolean testAnvilResult(@NotNull InventoryClickEvent event, @NotNull AnvilInventory inventory) {
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(inventory, "inventory");
        ItemStack itemStack = inventory.getItem(2);
        ItemStack previousResultSlot = itemStack != null ? itemStack.clone() : null;
        DisenchantClickEvent.onEvent((Event)((Event)event));
        if (!this.testAnvilInventoryChange(inventory, previousResultSlot) || event.isCancelled()) {
            CustomAnvil.Companion.log("Detected anvil click item extract bypass.");
            return true;
        }
        ShatterClickEvent.onEvent((Event)((Event)event));
        if (!this.testAnvilInventoryChange(inventory, previousResultSlot) || event.isCancelled()) {
            CustomAnvil.Companion.log("Detected anvil click split enchant bypass.");
            return true;
        }
        return false;
    }

    private final boolean testAnvilInventoryChange(AnvilInventory inventory, ItemStack previous) {
        ItemStack currentResult = inventory.getItem(2);
        return Intrinsics.areEqual(currentResult, previous);
    }
}

