/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.inventoryframework.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class CSVUtil {
    private static final Pattern UNICODE_CHARACTER_PATTERN = Pattern.compile("\\\\u([0-9A-Fa-f]{4})");

    private CSVUtil() {
    }

    @NotNull
    public static List<String[]> readAll(@NotNull InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            ArrayList<String[]> strings = new ArrayList<String[]>();
            while ((line = reader.readLine()) != null) {
                int i;
                if (line.isEmpty()) continue;
                ArrayList<Integer> splittingIndices = new ArrayList<Integer>();
                char[] chars = line.toCharArray();
                boolean quote = false;
                for (int i2 = 0; i2 < chars.length; ++i2) {
                    if (chars[i2] == '\"') {
                        quote = !quote;
                        continue;
                    }
                    if (chars[i2] != ',' || quote) continue;
                    splittingIndices.add(i2);
                }
                String[] array = new String[splittingIndices.size() + 1];
                for (i = 0; i < splittingIndices.size() + 1; ++i) {
                    array[i] = line.substring(i - 1 < 0 ? 0 : (Integer)splittingIndices.get(i - 1) + 1, i == splittingIndices.size() ? line.length() : ((Integer)splittingIndices.get(i)).intValue());
                }
                for (i = 0; i < array.length; ++i) {
                    array[i] = array[i].trim();
                    if (array[i].startsWith("\"") && array[i].endsWith("\"")) {
                        array[i] = array[i].substring(1, array[i].length() - 1);
                    }
                    array[i] = array[i].replace("\"\"", "\"");
                    Matcher matcher = UNICODE_CHARACTER_PATTERN.matcher(array[i]);
                    StringBuffer buf = new StringBuffer(array[i].length());
                    while (matcher.find()) {
                        String character = String.valueOf((char)Integer.parseInt(matcher.group(1), 16));
                        matcher.appendReplacement(buf, Matcher.quoteReplacement(character));
                    }
                    matcher.appendTail(buf);
                    array[i] = buf.toString();
                }
                strings.add(array);
            }
            ArrayList<String[]> arrayList = strings;
            return arrayList;
        }
    }
}

