/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.config;

import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.util.AnvilUseType;

public class WorkPenaltyType {
    private final EnumMap<AnvilUseType, WorkPenaltyPart> partMap;

    public WorkPenaltyType(@Nullable EnumMap<AnvilUseType, WorkPenaltyPart> partMap) {
        this.partMap = new EnumMap(partMap != null ? partMap : new EnumMap(AnvilUseType.class));
    }

    public ImmutableMap<AnvilUseType, WorkPenaltyPart> getPartMap() {
        return ImmutableMap.copyOf(this.partMap);
    }

    public WorkPenaltyPart getPenaltyInfo(AnvilUseType type) {
        return this.partMap.getOrDefault((Object)type, type.getDefaultPenalty());
    }

    public boolean isPenaltyIncreasing(AnvilUseType type) {
        return this.partMap.getOrDefault((Object)((Object)type), (WorkPenaltyPart)type.getDefaultPenalty()).penaltyIncrease;
    }

    public boolean isPenaltyAdditive(AnvilUseType type) {
        return this.partMap.getOrDefault((Object)((Object)type), (WorkPenaltyPart)type.getDefaultPenalty()).penaltyAdditive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkPenaltyType)) {
            return false;
        }
        WorkPenaltyType that = (WorkPenaltyType)o;
        for (AnvilUseType type : AnvilUseType.getEntries()) {
            if (this.getPenaltyInfo(type).equals(that.getPenaltyInfo(type))) continue;
            return false;
        }
        return true;
    }

    public record WorkPenaltyPart(boolean penaltyIncrease, boolean penaltyAdditive, boolean exclusivePenaltyIncrease, boolean exclusivePenaltyAdditive) {
        public WorkPenaltyPart(boolean penaltyIncrease, boolean penaltyAdditive) {
            this(penaltyIncrease, penaltyAdditive, false, false);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof WorkPenaltyPart)) {
                return false;
            }
            WorkPenaltyPart other = (WorkPenaltyPart)obj;
            return other.penaltyIncrease == this.penaltyIncrease && other.penaltyAdditive == this.penaltyAdditive && other.exclusivePenaltyIncrease == this.exclusivePenaltyIncrease && other.exclusivePenaltyAdditive == this.exclusivePenaltyAdditive;
        }
    }
}

