/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.settings;

import io.delilaheve.CustomAnvil;
import io.delilaheve.util.ConfigOptions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.settings.IntSettingsGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalActions;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class EnchantCostSettingsGui
extends IntSettingsGui {
    protected static final String ITEM_PATH = ".item";
    protected static final String BOOK_PATH = ".book";
    private int beforeBook;
    private int nowBook;

    protected EnchantCostSettingsGui(EnchantCostSettingFactory holder, int nowItem) {
        super(holder, nowItem);
        this.step = holder.steps[0];
        this.initStaticItem();
    }

    @Override
    protected void initStepsValue() {
        int nowBook;
        super.initStepsValue();
        this.beforeBook = nowBook = ((EnchantCostSettingFactory)this.holder).getConfiguredBookValue();
        this.nowBook = nowBook;
    }

    @Override
    public Pattern getGuiPattern() {
        return new Pattern("abc13-v+0", "D0012MVP0", "B0010000S");
    }

    private void initStaticItem() {
        PatternPane pane = this.getPane();
        ItemStack bookItemstack = new ItemStack(Material.BOOK);
        ItemMeta bookMeta = bookItemstack.getItemMeta();
        assert (bookMeta != null);
        bookMeta.setDisplayName("\u00a7aCost of an Enchantment by Book");
        bookMeta.setLore(Arrays.asList("\u00a77Cost per result item level of an sacrifice enchantment", "\u00a77Only apply if sacrificed item \u00a7cis \u00a77a book"));
        bookItemstack.setItemMeta(bookMeta);
        ItemStack swordItemstack = new ItemStack(Material.WOODEN_SWORD);
        ItemMeta swordMeta = swordItemstack.getItemMeta();
        assert (swordMeta != null);
        swordMeta.addItemFlags(ItemFlag.values());
        swordMeta.setDisplayName("\u00a7aCost of an Enchantment by Item");
        swordMeta.setLore(Arrays.asList("\u00a77Cost per result item level of an sacrifice enchantment", "\u00a77Only apply if sacrificed item \u00a7cis not \u00a77a book"));
        swordItemstack.setItemMeta(swordMeta);
        pane.bindItem('1', GuiGlobalItems.backgroundItem(Material.BLACK_STAINED_GLASS_PANE));
        pane.bindItem('2', new GuiItem(bookItemstack, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance));
        pane.bindItem('3', new GuiItem(swordItemstack, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance));
    }

    @Override
    protected void prepareReturnToDefault() {
        ItemStack item = new ItemStack(Material.COMMAND_BLOCK);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        EnchantCostSettingFactory holder = (EnchantCostSettingFactory)this.holder;
        meta.setDisplayName("\u00a7eReset to default value");
        meta.setLore(Arrays.asList("\u00a77Default item  value is: \u00a7e" + holder.defaultVal, "\u00a77Default book value is: \u00a7e" + holder.defaultBookVal));
        item.setItemMeta(meta);
        this.returnToDefault = new GuiItem(item, event -> {
            event.setCancelled(true);
            this.nowBook = holder.defaultBookVal;
            this.now = holder.defaultVal;
            this.updateValueDisplay();
            this.update();
        }, (Plugin)CustomAnvil.instance);
    }

    @Override
    protected void updateValueDisplay() {
        GuiItem plusItem;
        GuiItem minusItem;
        super.updateValueDisplay();
        PatternPane pane = this.getPane();
        EnchantCostSettingFactory holder = (EnchantCostSettingFactory)this.holder;
        int nowBook = this.nowBook;
        if (nowBook > holder.min) {
            int planned = Math.max(holder.min, nowBook - this.step);
            ItemStack item = new ItemStack(Material.RED_TERRACOTTA);
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            meta.setDisplayName("\u00a7e" + nowBook + " \u00a7f-> \u00a7e" + planned + " \u00a7r(\u00a7c-" + (nowBook - planned) + "\u00a7r)");
            meta.setLore(Collections.singletonList("\u00a77Click Here to change the value"));
            item.setItemMeta(meta);
            minusItem = new GuiItem(item, this.updateNowBookConsumer(planned), (Plugin)CustomAnvil.instance);
        } else {
            minusItem = GuiGlobalItems.backgroundItem(Material.BARRIER);
        }
        pane.bindItem('M', minusItem);
        if (nowBook < holder.max) {
            int planned = Math.min(holder.max, nowBook + this.step);
            ItemStack item = new ItemStack(Material.GREEN_TERRACOTTA);
            ItemMeta meta = item.getItemMeta();
            assert (meta != null);
            meta.setDisplayName("\u00a7e" + nowBook + " \u00a7f-> \u00a7e" + planned + " \u00a7r(\u00a7a+" + (planned - nowBook) + "\u00a7r)");
            meta.setLore(Collections.singletonList("\u00a77Click Here to change the value"));
            item.setItemMeta(meta);
            plusItem = new GuiItem(item, this.updateNowBookConsumer(planned), (Plugin)CustomAnvil.instance);
        } else {
            plusItem = GuiGlobalItems.backgroundItem(Material.BARRIER);
        }
        pane.bindItem('P', plusItem);
        ItemStack nowPaper = new ItemStack(Material.PAPER);
        ItemMeta nowMeta = nowPaper.getItemMeta();
        assert (nowMeta != null);
        nowMeta.setDisplayName("\u00a7fValue: \u00a7e" + nowBook);
        if (!holder.displayLore.isEmpty()) {
            nowMeta.setLore(holder.displayLore);
        }
        nowPaper.setItemMeta(nowMeta);
        GuiItem resultItem = new GuiItem(nowPaper, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
        pane.bindItem('V', resultItem);
        GuiItem returnToDefault = this.now != holder.defaultVal || nowBook != holder.defaultBookVal ? this.returnToDefault : GuiGlobalItems.backgroundItem();
        pane.bindItem('D', returnToDefault);
    }

    protected Consumer<InventoryClickEvent> updateNowBookConsumer(int planned) {
        return event -> {
            event.setCancelled(true);
            this.nowBook = planned;
            this.updateValueDisplay();
            this.update();
        };
    }

    @Override
    protected char getMidStepChar() {
        return 'b';
    }

    @Override
    public boolean onSave() {
        this.holder.config.getConfig().set(this.holder.configPath + ITEM_PATH, (Object)this.now);
        this.holder.config.getConfig().set(this.holder.configPath + BOOK_PATH, (Object)this.nowBook);
        return this.holder.config.saveToDisk(true);
    }

    @Override
    public boolean hadChange() {
        return super.hadChange() || this.nowBook != this.beforeBook;
    }

    public static class EnchantCostSettingFactory
    extends IntSettingsGui.IntSettingFactory {
        int defaultBookVal;
        @NotNull
        CAEnchantment enchantment;

        public EnchantCostSettingFactory(@NotNull String title, ValueUpdatableGui parent, @NotNull String configPath, @NotNull ConfigHolder config, @Nullable List<String> displayLore, @NotNull CAEnchantment enchantment, int min, int max, int ... steps) {
            super(title, parent, configPath, config, displayLore, min, max, enchantment.defaultRarity().getItemValue(), steps);
            this.defaultBookVal = enchantment.defaultRarity().getBookValue();
            this.enchantment = enchantment;
        }

        @Override
        public int getConfiguredValue() {
            return ConfigOptions.INSTANCE.enchantmentValue(this.enchantment, false);
        }

        public int getConfiguredBookValue() {
            return ConfigOptions.INSTANCE.enchantmentValue(this.enchantment, true);
        }

        @Override
        public Gui create() {
            int nowItem = this.getConfiguredValue();
            return new EnchantCostSettingsGui(this, nowItem);
        }

        public List<String> getDisplayLore() {
            return this.displayLore;
        }
    }
}

