/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.list.elements;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.group.AbstractMaterialGroup;
import xyz.alexcrea.cuanvil.group.EnchantConflictGroup;
import xyz.alexcrea.cuanvil.group.EnchantConflictManager;
import xyz.alexcrea.cuanvil.group.IncludeGroup;
import xyz.alexcrea.cuanvil.group.ItemGroupManager;
import xyz.alexcrea.cuanvil.gui.config.SelectGroupContainer;
import xyz.alexcrea.cuanvil.gui.config.SelectMaterialContainer;
import xyz.alexcrea.cuanvil.gui.config.ask.ConfirmActionGui;
import xyz.alexcrea.cuanvil.gui.config.global.GroupConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.elements.MappedToListSubSettingGui;
import xyz.alexcrea.cuanvil.gui.config.settings.GroupSelectSettingGui;
import xyz.alexcrea.cuanvil.gui.config.settings.MaterialSelectSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class GroupConfigSubSettingGui
extends MappedToListSubSettingGui
implements SelectGroupContainer,
SelectMaterialContainer {
    private final GroupConfigGui parent;
    private final IncludeGroup group;
    private final PatternPane pane;
    private boolean usable = true;
    private GuiItem materialSelection;
    private GuiItem groupSelection;

    public GroupConfigSubSettingGui(@NotNull GroupConfigGui parent, @NotNull IncludeGroup group) {
        super(3, "\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(group.getName()) + " \u00a7rConfig");
        this.parent = parent;
        this.group = group;
        Pattern pattern = new Pattern("000000000", "00102000D", "B00000000");
        this.pane = new PatternPane(0, 0, 9, 3, pattern);
        this.addPane(this.pane);
        this.prepareStaticValues();
    }

    private void prepareStaticValues() {
        GuiGlobalItems.addBackItem(this.pane, this.parent);
        GuiGlobalItems.addBackgroundItem(this.pane);
        ItemStack deleteItem = new ItemStack(Material.RED_TERRACOTTA);
        ItemMeta deleteMeta = deleteItem.getItemMeta();
        deleteMeta.setDisplayName("\u00a74DELETE GROUP");
        deleteMeta.setLore(Collections.singletonList("\u00a7cCaution with this button !"));
        deleteItem.setItemMeta(deleteMeta);
        this.pane.bindItem('D', new GuiItem(deleteItem, this.openGuiAndCheckAction(), (Plugin)CustomAnvil.instance));
        String materialSelectionName = "\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(this.group.getName()) + " \u00a7rMaterials";
        ItemStack selectItem = new ItemStack(Material.DIAMOND_SWORD);
        ItemMeta selectItemMeta = selectItem.getItemMeta();
        selectItemMeta.setDisplayName(materialSelectionName);
        selectItem.setItemMeta(selectItemMeta);
        this.materialSelection = new GuiItem(selectItem, event -> {
            event.setCancelled(true);
            MaterialSelectSettingGui selectGui = new MaterialSelectSettingGui(this, materialSelectionName, this);
            selectGui.show(event.getWhoClicked());
        }, (Plugin)CustomAnvil.instance);
        String selectGroupName = "\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(this.group.getName()) + " \u00a7rGroups";
        ItemStack selectGroup = new ItemStack(Material.CHEST);
        ItemMeta selectGroupMeta = selectGroup.getItemMeta();
        selectGroupMeta.setDisplayName(selectGroupName);
        selectGroup.setItemMeta(selectGroupMeta);
        this.groupSelection = new GuiItem(selectGroup, event -> {
            event.setCancelled(true);
            GroupSelectSettingGui enchantGui = new GroupSelectSettingGui(selectGroupName, this, this, 0);
            enchantGui.show(event.getWhoClicked());
        }, (Plugin)CustomAnvil.instance);
        this.pane.bindItem('1', this.materialSelection);
        this.pane.bindItem('2', this.groupSelection);
    }

    @NotNull
    private Consumer<InventoryClickEvent> openGuiAndCheckAction() {
        ConfirmActionGui deleteGui = this.createDeleteGui();
        return event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            if (!player.hasPermission("ca.config.edit")) {
                player.closeInventory();
                player.sendMessage("\u00a7cYou do not have permission to edit the config");
                return;
            }
            if (this.testAndWarnIfUsed(player)) {
                return;
            }
            deleteGui.show(player);
        };
    }

    @NotNull
    private ConfirmActionGui createDeleteGui() {
        Supplier<Boolean> deleteSupplier = () -> {
            if (!GroupConfigSubSettingGui.getUsedLocations(this.group).isEmpty()) {
                return false;
            }
            ItemGroupManager manager = ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager();
            manager.getGroupMap().remove(this.group.getName());
            this.parent.removeGeneric(this.group);
            this.cleanAndBeUnusable();
            ConfigHolder.CUSTOM_RECIPE_HOLDER.delete(this.group.getName());
            boolean success = true;
            success = ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
            return success;
        };
        return new ConfirmActionGui("\u00a7cDelete \u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(this.group.toString()) + "\u00a7c?", "\u00a77Confirm that you want to delete this group.", this, this.parent, deleteSupplier);
    }

    public boolean testAndWarnIfUsed(HumanEntity player) {
        List<String> usedLoc = GroupConfigSubSettingGui.getUsedLocations(this.group);
        if (usedLoc.isEmpty()) {
            return false;
        }
        StringBuilder stb = new StringBuilder("\u00a7cCan't delete group " + this.group.getName() + "\n\u00a7eUsed by:");
        int maxIndex = usedLoc.size();
        int nbMore = 0;
        if (maxIndex > 10) {
            nbMore = maxIndex - 9;
            maxIndex = 9;
        }
        for (int i = 0; i < maxIndex; ++i) {
            stb.append("\n\u00a7r-\u00a7e ").append(usedLoc.get(i));
        }
        if (nbMore > 0) {
            stb.append("\u00a7cAnd ").append(nbMore).append(" More...");
        }
        player.sendMessage(stb.toString());
        return true;
    }

    public static List<String> getUsedLocations(AbstractMaterialGroup group) {
        ArrayList<String> usageList = new ArrayList<String>();
        ItemGroupManager groupManager = ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager();
        for (AbstractMaterialGroup otherGroup : groupManager.getGroupMap().values()) {
            if (!otherGroup.getGroups().contains(group)) continue;
            usageList.add("group " + otherGroup.getName());
        }
        EnchantConflictManager conflictManager = ConfigHolder.CONFLICT_HOLDER.getConflictManager();
        for (EnchantConflictGroup conflict : conflictManager.getConflictList()) {
            if (!conflict.getCantConflictGroup().getGroups().contains(group)) continue;
            usageList.add("conflict " + String.valueOf(conflict));
        }
        return usageList;
    }

    @Override
    public void updateGuiValues() {
        if (!this.usable) {
            return;
        }
        this.parent.updateValueForGeneric(this.group, true);
    }

    @Override
    public void updateLocal() {
        if (!this.usable) {
            return;
        }
        List<String> matLore = SelectMaterialContainer.getMaterialLore(this, "group", "include");
        List<String> groupLore = SelectGroupContainer.getGroupLore(this, "group", "include");
        ItemStack matSelectItem = this.materialSelection.getItem();
        ItemMeta matSelectMeta = matSelectItem.getItemMeta();
        matSelectMeta.setDisplayName("\u00a7aSelect included \u00a7eMaterials \u00a7aSettings");
        matSelectMeta.setLore(matLore);
        matSelectMeta.addItemFlags(ItemFlag.values());
        matSelectItem.setItemMeta(matSelectMeta);
        this.materialSelection.setItem(matSelectItem);
        ItemStack groupSelectItem = this.groupSelection.getItem();
        ItemMeta groupSelectMeta = groupSelectItem.getItemMeta();
        groupSelectMeta.setDisplayName("\u00a7aSelect included \u00a73Groups \u00a7aSettings");
        groupSelectMeta.setLore(groupLore);
        groupSelectItem.setItemMeta(groupSelectMeta);
        this.groupSelection.setItem(groupSelectItem);
    }

    @Override
    public void cleanAndBeUnusable() {
        this.usable = false;
        this.pane.bindItem('1', GuiGlobalItems.backgroundItem());
        this.pane.bindItem('2', GuiGlobalItems.backgroundItem());
        this.pane.bindItem('D', GuiGlobalItems.backgroundItem());
    }

    @Override
    public void show(@NotNull HumanEntity player) {
        if (!this.usable) {
            this.parent.show(player);
            return;
        }
        super.show(player);
    }

    @Override
    public Set<AbstractMaterialGroup> getSelectedGroups() {
        return this.group.getGroups();
    }

    @Override
    public boolean setSelectedGroups(Set<AbstractMaterialGroup> groups2) {
        this.updateGroup(this.group, groups2);
        return ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
    }

    private void updateGroup(@NotNull AbstractMaterialGroup group, Set<AbstractMaterialGroup> groups2) {
        group.setGroups(groups2);
        groups2 = group.getGroups();
        String[] groupNames = new String[groups2.size()];
        int index = 0;
        for (AbstractMaterialGroup otherGroup : groups2) {
            groupNames[index++] = otherGroup.getName();
        }
        ConfigHolder.ITEM_GROUP_HOLDER.getConfig().set(group.getName() + ".groups", (Object)groupNames);
        this.updateDirectReferencingGroups(group);
    }

    @Override
    public Set<AbstractMaterialGroup> illegalGroups() {
        HashSet<AbstractMaterialGroup> illegal = new HashSet<AbstractMaterialGroup>();
        for (AbstractMaterialGroup otherGroup : ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager().getGroupMap().values()) {
            if (!otherGroup.isReferencing(this.group)) continue;
            illegal.add(otherGroup);
        }
        illegal.add(this.group);
        return illegal;
    }

    @Override
    public EnumSet<Material> getSelectedMaterials() {
        return this.group.getNonGroupInheritedMaterials();
    }

    @Override
    public boolean setSelectedMaterials(EnumSet<Material> materials) {
        this.group.setNonGroupInheritedMaterials(materials);
        String[] groupNames = new String[materials.size()];
        int index = 0;
        for (Material otherGroup : materials) {
            groupNames[index++] = otherGroup.name().toLowerCase();
        }
        ConfigHolder.ITEM_GROUP_HOLDER.getConfig().set(this.group.getName() + ".items", (Object)groupNames);
        this.updateDirectReferencingGroups(this.group);
        return ConfigHolder.ITEM_GROUP_HOLDER.saveToDisk(true);
    }

    @Override
    public EnumSet<Material> illegalMaterials() {
        return EnumSet.of(Material.AIR);
    }

    private void updateDirectReferencingGroups(AbstractMaterialGroup referenceTo) {
        Collection<AbstractMaterialGroup> everyStoredGroups = ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager().getGroupMap().values();
        ArrayList<EnchantConflictGroup> everyConflicts = ConfigHolder.CONFLICT_HOLDER.getConflictManager().getConflictList();
        HashSet toUpdate = new HashSet();
        HashSet<AbstractMaterialGroup> updateFuture = new HashSet<AbstractMaterialGroup>();
        HashSet<AbstractMaterialGroup> conflictGroupPlanned = new HashSet<AbstractMaterialGroup>();
        updateFuture.add(referenceTo);
        while (!updateFuture.isEmpty()) {
            HashSet<AbstractMaterialGroup> temp = updateFuture;
            updateFuture = toUpdate;
            updateFuture.clear();
            toUpdate = temp;
            for (AbstractMaterialGroup testGroup : toUpdate) {
                for (AbstractMaterialGroup otherGroup : everyStoredGroups) {
                    if (!otherGroup.getGroups().contains(testGroup)) continue;
                    otherGroup.updateMaterials();
                    updateFuture.add(otherGroup);
                }
                for (EnchantConflictGroup everyConflict : everyConflicts) {
                    AbstractMaterialGroup conflictGroup = everyConflict.getCantConflictGroup();
                    if (!conflictGroup.getGroups().contains(testGroup)) continue;
                    conflictGroupPlanned.add(conflictGroup);
                }
                if (!(testGroup instanceof IncludeGroup)) continue;
                this.parent.updateValueForGeneric((IncludeGroup)testGroup, false);
            }
        }
        this.parent.update();
        for (AbstractMaterialGroup conflictGroup : conflictGroupPlanned) {
            conflictGroup.updateMaterials();
        }
    }
}

