/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.listener;

import io.delilaheve.CustomAnvil;
import io.delilaheve.util.ConfigOptions;
import io.delilaheve.util.ItemUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.dependency.util.PlatformUtil;
import xyz.alexcrea.cuanvil.recipe.AnvilCustomRecipe;
import xyz.alexcrea.cuanvil.util.AnvilLoreEditUtil;
import xyz.alexcrea.cuanvil.util.AnvilUseType;
import xyz.alexcrea.cuanvil.util.AnvilXpUtil;
import xyz.alexcrea.cuanvil.util.CustomRecipeUtil;
import xyz.alexcrea.cuanvil.util.MiniMessageUtil;
import xyz.alexcrea.cuanvil.util.UnitRepairUtil;
import xyz.alexcrea.cuanvil.util.config.LoreEditConfigUtil;
import xyz.alexcrea.cuanvil.util.config.LoreEditType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u0001:\u0003)*+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007JB\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JT\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u0014H\u0002JT\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u00162\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0016H\u0002J@\u0010\u001d\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J8\u0010 \u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0016H\u0002J \u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J8\u0010%\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J8\u0010&\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006,"}, d2={"Lxyz/alexcrea/cuanvil/listener/AnvilResultListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "anvilExtractionCheck", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onCustomCraft", "recipe", "Lxyz/alexcrea/cuanvil/recipe/AnvilCustomRecipe;", "player", "Lorg/bukkit/entity/Player;", "leftItem", "Lorg/bukkit/inventory/ItemStack;", "rightItem", "output", "inventory", "Lorg/bukkit/inventory/AnvilInventory;", "handleCustomCraftClick", "", "amount", "", "xpCost", "linearCost", "extractAnvilResult", "leftRemoveCount", "rightRemoveCount", "repairCost", "onUnitRepairExtract", "unitRepairResult", "", "getUnitRepairCost", "resultCopy", "resultAmount", "getFromLoreEditXpCost", "Ljava/util/concurrent/atomic/AtomicInteger;", "handleBookLoreEdit", "handlePaperLoreEdit", "getActionSlot", "Lxyz/alexcrea/cuanvil/listener/AnvilResultListener$SlotContainer;", "Companion", "SlotContainer", "SlotType", "CustomAnvil"})
@SourceDebugExtension(value={"SMAP\nAnvilResultListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnvilResultListener.kt\nxyz/alexcrea/cuanvil/listener/AnvilResultListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,568:1\n1863#2,2:569\n*S KotlinDebug\n*F\n+ 1 AnvilResultListener.kt\nxyz/alexcrea/cuanvil/listener/AnvilResultListener\n*L\n414#1:569,2\n*E\n"})
public final class AnvilResultListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final SlotContainer NO_SLOT = new SlotContainer(SlotType.NO_SLOT, 0);
    @NotNull
    private static final SlotContainer CURSOR_SLOT = new SlotContainer(SlotType.CURSOR, 0);

    @EventHandler(ignoreCancelled=true)
    public final void anvilExtractionCheck(@NotNull InventoryClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        HumanEntity humanEntity = event.getWhoClicked();
        Player player = humanEntity instanceof Player ? (Player)humanEntity : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        Inventory inventory = event.getInventory();
        AnvilInventory anvilInventory = inventory instanceof AnvilInventory ? (AnvilInventory)inventory : null;
        if (anvilInventory == null) {
            return;
        }
        AnvilInventory inventory2 = anvilInventory;
        if (event.getRawSlot() != 2) {
            return;
        }
        if (DependencyManager.INSTANCE.tryClickAnvilResultBypass(event, inventory2)) {
            return;
        }
        if (!player2.hasPermission("ca.affected")) {
            return;
        }
        ItemStack itemStack = inventory2.getItem(2);
        if (itemStack == null) {
            return;
        }
        ItemStack output = itemStack;
        ItemStack itemStack2 = inventory2.getItem(0);
        if (itemStack2 == null) {
            return;
        }
        ItemStack leftItem = itemStack2;
        ItemStack rightItem = inventory2.getItem(1);
        if (GameMode.CREATIVE != player2.getGameMode() && inventory2.getRepairCost() >= inventory2.getMaximumRepairCost()) {
            event.setResult(Event.Result.DENY);
            return;
        }
        AnvilCustomRecipe recipe = CustomRecipeUtil.INSTANCE.getCustomRecipe(leftItem, rightItem);
        if (recipe != null) {
            event.setResult(Event.Result.ALLOW);
            this.onCustomCraft(event, recipe, player2, leftItem, rightItem, output, inventory2);
            return;
        }
        if (Intrinsics.areEqual(output, inventory2.getItem(0))) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (rightItem == null) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        boolean canMerge = ItemUtil.INSTANCE.canMergeWith(leftItem, rightItem);
        if (canMerge) {
            event.setResult(Event.Result.ALLOW);
            return;
        }
        Double unitRepairResult = UnitRepairUtil.INSTANCE.getRepair(leftItem, rightItem);
        if (unitRepairResult != null) {
            this.onUnitRepairExtract(leftItem, rightItem, output, unitRepairResult, event, player2, inventory2);
            return;
        }
        if (this.handleBookLoreEdit(event, inventory2, player2, leftItem, rightItem, output)) {
            return;
        }
        if (this.handlePaperLoreEdit(event, inventory2, player2, leftItem, rightItem, output)) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }

    private final void onCustomCraft(InventoryClickEvent event, AnvilCustomRecipe recipe, Player player, ItemStack leftItem, ItemStack rightItem, ItemStack output, AnvilInventory inventory) {
        SlotContainer slotDestination;
        event.setResult(Event.Result.DENY);
        if (recipe.getLeftItem() == null) {
            return;
        }
        int amount = CustomRecipeUtil.INSTANCE.getCustomRecipeAmount(recipe, leftItem, rightItem);
        int xpCost = recipe.determineCost(amount, leftItem, output);
        int finalCost = recipe.getRemoveExactLinearXp() ? xpCost : AnvilXpUtil.INSTANCE.calculateLevelForXp(xpCost);
        CustomAnvil.Companion.log("gamemode: " + (player.getGameMode() != GameMode.CREATIVE) + ", cost: " + finalCost + ", level: " + player.getLevel() + ", result: " + (player.getTotalExperience() < finalCost) + " " + (player.getLevel() < finalCost));
        if (player.getGameMode() != GameMode.CREATIVE) {
            if (recipe.getRemoveExactLinearXp()) {
                int levelXp = AnvilXpUtil.INSTANCE.calculateXpForLevel(player.getLevel());
                int delta = AnvilXpUtil.INSTANCE.calculateXpForLevel(player.getLevel() + 1) - levelXp;
                float totalXp = (float)levelXp + player.getExp() * (float)delta;
                if (totalXp < (float)finalCost) {
                    return;
                }
            } else if (player.getLevel() < finalCost) {
                return;
            }
        }
        if ((slotDestination = this.getActionSlot(event, player)).getType() == SlotType.NO_SLOT) {
            return;
        }
        if (event.getClick() != ClickType.MIDDLE && !this.handleCustomCraftClick(event, recipe, inventory, player, leftItem, rightItem, amount, finalCost, recipe.getRemoveExactLinearXp())) {
            return;
        }
        if (slotDestination.getType() == SlotType.CURSOR) {
            player.setItemOnCursor(output);
        } else {
            player.getInventory().setItem(slotDestination.getSlot(), output);
        }
    }

    private final boolean handleCustomCraftClick(InventoryClickEvent event, AnvilCustomRecipe recipe, AnvilInventory inventory, Player player, ItemStack leftItem, ItemStack rightItem, int amount, int xpCost, boolean linearCost) {
        if (rightItem != null) {
            if (recipe.getRightItem() == null) {
                return false;
            }
            int n = rightItem.getAmount();
            ItemStack itemStack = recipe.getRightItem();
            Intrinsics.checkNotNull(itemStack);
            rightItem.setAmount(n - amount * itemStack.getAmount());
            inventory.setItem(1, rightItem);
        }
        int n = leftItem.getAmount();
        ItemStack itemStack = recipe.getLeftItem();
        Intrinsics.checkNotNull(itemStack);
        leftItem.setAmount(n - amount * itemStack.getAmount());
        inventory.setItem(0, leftItem);
        if (player.getGameMode() != GameMode.CREATIVE) {
            if (linearCost) {
                int levelXp = AnvilXpUtil.INSTANCE.calculateXpForLevel(player.getLevel());
                int delta = AnvilXpUtil.INSTANCE.calculateXpForLevel(player.getLevel() + 1) - levelXp;
                float totalXp = (float)levelXp + player.getExp() * (float)delta;
                int newLevel = AnvilXpUtil.INSTANCE.calculateLevelForXp((int)(totalXp -= (float)xpCost));
                int newLevelXp = AnvilXpUtil.INSTANCE.calculateXpForLevel(newLevel);
                int newDelta = AnvilXpUtil.INSTANCE.calculateXpForLevel(newLevel + 1) - newLevelXp;
                float xp = (totalXp - (float)newLevelXp) / (float)newDelta;
                player.setLevel(newLevel);
                player.setExp(xp / (float)newDelta);
            } else {
                player.setLevel(player.getLevel() - xpCost);
            }
        }
        int newAmount = CustomRecipeUtil.INSTANCE.getCustomRecipeAmount(recipe, leftItem, rightItem);
        CustomAnvil.Companion.verboseLog("new amount is " + newAmount);
        if (newAmount <= 0 || recipe.getExactCount()) {
            inventory.setItem(2, null);
        } else {
            ItemStack itemStack2 = recipe.getResultItem();
            Intrinsics.checkNotNull(itemStack2);
            ItemStack itemStack3 = itemStack2.clone();
            Intrinsics.checkNotNullExpressionValue(itemStack3, "clone(...)");
            ItemStack resultItem = itemStack3;
            resultItem.setAmount(resultItem.getAmount() * newAmount);
            int newXp = newAmount * newAmount;
            inventory.setRepairCost(newXp);
            event.getView().setProperty(InventoryView.Property.REPAIR_COST, newXp);
            inventory.setItem(2, resultItem);
            player.updateInventory();
        }
        return true;
    }

    static /* synthetic */ boolean handleCustomCraftClick$default(AnvilResultListener anvilResultListener, InventoryClickEvent inventoryClickEvent, AnvilCustomRecipe anvilCustomRecipe, AnvilInventory anvilInventory, Player player, ItemStack itemStack, ItemStack itemStack2, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 0x100) != 0) {
            bl = false;
        }
        return anvilResultListener.handleCustomCraftClick(inventoryClickEvent, anvilCustomRecipe, anvilInventory, player, itemStack, itemStack2, n, n2, bl);
    }

    private final boolean extractAnvilResult(InventoryClickEvent event, Player player, AnvilInventory inventory, ItemStack leftItem, int leftRemoveCount, ItemStack rightItem, int rightRemoveCount, ItemStack output, int repairCost) {
        event.setResult(Event.Result.DENY);
        event.setCancelled(true);
        if (repairCost == Integer.MIN_VALUE) {
            return false;
        }
        SlotContainer slotDestination = this.getActionSlot(event, player);
        if (slotDestination.getType() == SlotType.NO_SLOT) {
            return false;
        }
        if (event.getClick() != ClickType.MIDDLE) {
            if (leftItem != null) {
                leftItem.setAmount(leftItem.getAmount() - leftRemoveCount);
            }
            inventory.setItem(0, leftItem);
            if (rightItem != null) {
                rightItem.setAmount(rightItem.getAmount() - rightRemoveCount);
            }
            inventory.setItem(1, rightItem);
            inventory.setItem(2, null);
            player.setLevel(player.getLevel() - repairCost);
        }
        if (SlotType.CURSOR == slotDestination.getType()) {
            player.setItemOnCursor(output);
        } else {
            player.getInventory().setItem(slotDestination.getSlot(), output);
        }
        return true;
    }

    private final void onUnitRepairExtract(ItemStack leftItem, ItemStack rightItem, ItemStack output, double unitRepairResult, InventoryClickEvent event, Player player, AnvilInventory inventory) {
        ItemStack itemStack = leftItem.clone();
        Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
        ItemStack resultCopy = itemStack;
        int resultAmount = ItemUtil.INSTANCE.unitRepair(resultCopy, rightItem.getAmount(), unitRepairResult);
        int repairCost = this.getUnitRepairCost(inventory, player, leftItem, output, resultCopy, resultAmount);
        this.extractAnvilResult(event, player, inventory, null, 0, rightItem, resultAmount, resultCopy, repairCost);
    }

    private final int getUnitRepairCost(AnvilInventory inventory, Player player, ItemStack leftItem, ItemStack output, ItemStack resultCopy, int resultAmount) {
        if (player.getGameMode() == GameMode.CREATIVE) {
            return 0;
        }
        int repairCost = 0;
        ItemMeta itemMeta = leftItem.getItemMeta();
        if (itemMeta != null) {
            ItemMeta leftMeta = itemMeta;
            boolean bl = false;
            String string = leftMeta.getDisplayName();
            Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
            String leftName = string;
            ItemMeta itemMeta2 = output.getItemMeta();
            if (itemMeta2 != null) {
                ItemMeta it = itemMeta2;
                boolean bl2 = false;
                String string2 = leftName;
                String string3 = it.getDisplayName();
                Intrinsics.checkNotNullExpressionValue(string3, "getDisplayName(...)");
                if (!string2.contentEquals(string3)) {
                    repairCost += ConfigOptions.INSTANCE.getItemRenameCost();
                    String string4 = it.getDisplayName();
                    Intrinsics.checkNotNullExpressionValue(string4, "getDisplayName(...)");
                    if (StringsKt.contains$default((CharSequence)string4, '\u00a7', false, 2, null)) {
                        repairCost += ConfigOptions.INSTANCE.getUseOfColorCost();
                    }
                }
            }
        }
        repairCost += AnvilXpUtil.INSTANCE.calculatePenalty(leftItem, null, resultCopy, AnvilUseType.UNIT_REPAIR);
        repairCost += resultAmount * ConfigOptions.INSTANCE.getUnitRepairCost();
        if (!ConfigOptions.INSTANCE.getDoRemoveCostLimit() && ConfigOptions.INSTANCE.getDoCapCost()) {
            repairCost = Math.min(repairCost, ConfigOptions.INSTANCE.getMaxAnvilCost());
        }
        if (inventory.getMaximumRepairCost() <= repairCost || player.getLevel() < repairCost) {
            return Integer.MIN_VALUE;
        }
        return repairCost;
    }

    private final int getFromLoreEditXpCost(AtomicInteger xpCost, Player player, AnvilInventory inventory) {
        if (GameMode.CREATIVE == player.getGameMode()) {
            return 0;
        }
        int repairCost = xpCost.get();
        return inventory.getMaximumRepairCost() <= repairCost || player.getLevel() < repairCost ? Integer.MIN_VALUE : repairCost;
    }

    private final boolean handleBookLoreEdit(InventoryClickEvent event, AnvilInventory inventory, Player player, ItemStack leftItem, ItemStack rightItem, ItemStack output) {
        if (Material.WRITABLE_BOOK != rightItem.getType()) {
            return false;
        }
        BookMeta bookMeta = (BookMeta)rightItem.getItemMeta();
        if (bookMeta == null) {
            return false;
        }
        BookMeta bookMeta2 = bookMeta;
        Boolean bl = AnvilLoreEditUtil.INSTANCE.bookLoreEditIsAppend(leftItem, rightItem);
        if (bl == null) {
            return false;
        }
        boolean editType = bl;
        AtomicInteger xpCost = new AtomicInteger();
        if (editType) {
            if (!Intrinsics.areEqual(output, AnvilLoreEditUtil.INSTANCE.handleLoreAppendByBook((Permissible)player, leftItem, bookMeta2, xpCost))) {
                return false;
            }
            ItemStack clearedBook = null;
            if (LoreEditType.APPEND_BOOK.getDoConsume()) {
                clearedBook = null;
            } else {
                clearedBook = rightItem.clone();
                bookMeta2.setPages(Collections.emptyList());
                clearedBook.setItemMeta((ItemMeta)bookMeta2);
            }
            return this.extractAnvilResult(event, player, inventory, null, 0, clearedBook, 0, output, this.getFromLoreEditXpCost(xpCost, player, inventory));
        }
        if (!Intrinsics.areEqual(output, AnvilLoreEditUtil.INSTANCE.handleLoreRemoveByBook((Permissible)player, leftItem, xpCost))) {
            return false;
        }
        List<Component> lore = DependencyManager.INSTANCE.stripLore(leftItem);
        if (lore.isEmpty()) {
            return false;
        }
        ItemStack rightCopy = null;
        if (LoreEditType.REMOVE_BOOK.getDoConsume()) {
            rightCopy = null;
        } else {
            AnvilLoreEditUtil.INSTANCE.uncolorLines((Permissible)player, lore, LoreEditType.REMOVE_BOOK);
            StringBuilder bookPage = new StringBuilder();
            Iterable $this$forEach$iv = lore;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl2 = false;
                if (((CharSequence)bookPage).length() > 0) {
                    bookPage.append('\n');
                }
                if (it == null) continue;
                bookPage.append(MiniMessageUtil.INSTANCE.getPlain_text_mm().serialize(it));
            }
            String string = bookPage.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            String resultPage = string;
            rightCopy = rightItem.clone();
            String[] stringArray = new String[]{resultPage};
            bookMeta2.setPages(stringArray);
            rightCopy.setItemMeta((ItemMeta)bookMeta2);
        }
        return this.extractAnvilResult(event, player, inventory, null, 0, rightCopy, 0, output, this.getFromLoreEditXpCost(xpCost, player, inventory));
    }

    private final boolean handlePaperLoreEdit(InventoryClickEvent event, AnvilInventory inventory, Player player, ItemStack leftItem, ItemStack rightItem, ItemStack output) {
        if (Material.PAPER != rightItem.getType()) {
            return false;
        }
        ItemMeta itemMeta = rightItem.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        ItemMeta paperMeta = itemMeta;
        Boolean bl = AnvilLoreEditUtil.INSTANCE.paperLoreEditIsAppend(leftItem, rightItem);
        if (bl == null) {
            return false;
        }
        boolean editTypeIsAppend = bl;
        AtomicInteger xpCost = new AtomicInteger();
        if (editTypeIsAppend) {
            if (!Intrinsics.areEqual(output, AnvilLoreEditUtil.INSTANCE.handleLoreAppendByPaper((Permissible)player, leftItem, rightItem, xpCost))) {
                return false;
            }
            ItemStack paperCopy = null;
            if (LoreEditType.APPEND_PAPER.getDoConsume()) {
                paperCopy = null;
            } else {
                paperCopy = rightItem.clone();
                paperCopy.setAmount(1);
                PlatformUtil.INSTANCE.setComponentDisplayName(paperMeta, null);
                paperCopy.setItemMeta(paperMeta);
            }
            return rightItem.getAmount() > 1 ? this.extractAnvilResult(event, player, inventory, paperCopy, 0, rightItem, 1, output, this.getFromLoreEditXpCost(xpCost, player, inventory)) : this.extractAnvilResult(event, player, inventory, null, 0, paperCopy, 0, output, this.getFromLoreEditXpCost(xpCost, player, inventory));
        }
        if (!Intrinsics.areEqual(output, AnvilLoreEditUtil.INSTANCE.handleLoreRemoveByPaper((Permissible)player, leftItem, xpCost))) {
            return false;
        }
        ItemMeta leftMeta = leftItem.getItemMeta();
        if (leftMeta == null || !leftMeta.hasLore()) {
            return false;
        }
        List<Component> lore = DependencyManager.INSTANCE.stripLore(leftItem);
        if (lore.isEmpty()) {
            return false;
        }
        ItemStack rightClone = null;
        if (LoreEditType.REMOVE_PAPER.getDoConsume()) {
            rightClone = null;
        } else {
            boolean removeEnd = LoreEditConfigUtil.INSTANCE.getPaperLoreOrderIsEnd();
            Component line = removeEnd ? lore.get(lore.size() - 1) : lore.get(0);
            AtomicReference<Component> ref = new AtomicReference<Component>(line);
            AnvilLoreEditUtil.INSTANCE.uncolorLine((Permissible)player, ref, LoreEditType.REMOVE_PAPER);
            rightClone = rightItem.clone();
            rightClone.setAmount(1);
            ItemMeta itemMeta2 = rightClone.getItemMeta();
            if (itemMeta2 == null) {
                return false;
            }
            ItemMeta resultMeta = itemMeta2;
            PlatformUtil.INSTANCE.setComponentDisplayName(resultMeta, ref.get());
            rightClone.setItemMeta(resultMeta);
        }
        return rightItem.getAmount() > 1 ? this.extractAnvilResult(event, player, inventory, rightClone, 0, rightItem, 1, output, this.getFromLoreEditXpCost(xpCost, player, inventory)) : this.extractAnvilResult(event, player, inventory, null, 0, rightClone, 0, output, this.getFromLoreEditXpCost(xpCost, player, inventory));
    }

    private final SlotContainer getActionSlot(InventoryClickEvent event, Player player) {
        if (event.isShiftClick()) {
            int slotIndex;
            PlayerInventory playerInventory = player.getInventory();
            Intrinsics.checkNotNullExpressionValue(playerInventory, "getInventory(...)");
            PlayerInventory inventory = playerInventory;
            int firstEmpty = inventory.firstEmpty();
            if (firstEmpty == -1) {
                return NO_SLOT;
            }
            for (slotIndex = 8; slotIndex >= 0; --slotIndex) {
                ItemStack itemStack = inventory.getItem(slotIndex);
                if (itemStack == null || (itemStack = itemStack.getType()) == null) {
                    itemStack = Material.AIR;
                }
                if (itemStack == Material.AIR) break;
            }
            if (slotIndex >= 0) {
                return new SlotContainer(SlotType.INVENTORY, slotIndex);
            }
            for (slotIndex = 35; slotIndex >= 9; --slotIndex) {
                ItemStack itemStack = inventory.getItem(slotIndex);
                if (itemStack == null || (itemStack = itemStack.getType()) == null) {
                    itemStack = Material.AIR;
                }
                if (itemStack == Material.AIR) break;
            }
            if (slotIndex < 9) {
                return NO_SLOT;
            }
            return new SlotContainer(SlotType.INVENTORY, slotIndex);
        }
        if (player.getItemOnCursor().getType() != Material.AIR) {
            return NO_SLOT;
        }
        return CURSOR_SLOT;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lxyz/alexcrea/cuanvil/listener/AnvilResultListener$Companion;", "", "<init>", "()V", "NO_SLOT", "Lxyz/alexcrea/cuanvil/listener/AnvilResultListener$SlotContainer;", "CURSOR_SLOT", "CustomAnvil"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lxyz/alexcrea/cuanvil/listener/AnvilResultListener$SlotContainer;", "", "type", "Lxyz/alexcrea/cuanvil/listener/AnvilResultListener$SlotType;", "slot", "", "<init>", "(Lxyz/alexcrea/cuanvil/listener/AnvilResultListener$SlotType;I)V", "getType", "()Lxyz/alexcrea/cuanvil/listener/AnvilResultListener$SlotType;", "getSlot", "()I", "CustomAnvil"})
    private static final class SlotContainer {
        @NotNull
        private final SlotType type;
        private final int slot;

        public SlotContainer(@NotNull SlotType type, int slot) {
            Intrinsics.checkNotNullParameter((Object)type, "type");
            this.type = type;
            this.slot = slot;
        }

        @NotNull
        public final SlotType getType() {
            return this.type;
        }

        public final int getSlot() {
            return this.slot;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lxyz/alexcrea/cuanvil/listener/AnvilResultListener$SlotType;", "", "<init>", "(Ljava/lang/String;I)V", "CURSOR", "INVENTORY", "NO_SLOT", "CustomAnvil"})
    private static final class SlotType
    extends Enum<SlotType> {
        public static final /* enum */ SlotType CURSOR = new SlotType();
        public static final /* enum */ SlotType INVENTORY = new SlotType();
        public static final /* enum */ SlotType NO_SLOT = new SlotType();
        private static final /* synthetic */ SlotType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SlotType[] values() {
            return (SlotType[])$VALUES.clone();
        }

        public static SlotType valueOf(String value) {
            return Enum.valueOf(SlotType.class, value);
        }

        @NotNull
        public static EnumEntries<SlotType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = slotTypeArray = new SlotType[]{SlotType.CURSOR, SlotType.INVENTORY, SlotType.NO_SLOT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

