/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.global;

import java.util.Arrays;
import java.util.Collection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.group.EnchantConflictGroup;
import xyz.alexcrea.cuanvil.group.IncludeGroup;
import xyz.alexcrea.cuanvil.gui.config.list.MappedGuiListConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.elements.EnchantConflictSubSettingGui;
import xyz.alexcrea.cuanvil.util.CasedStringUtil;
import xyz.alexcrea.inventoryframework.gui.GuiItem;

public class EnchantConflictGui
extends MappedGuiListConfigGui<EnchantConflictGroup, MappedGuiListConfigGui.LazyElement<EnchantConflictSubSettingGui>> {
    private static EnchantConflictGui INSTANCE;

    @Nullable
    public static EnchantConflictGui getCurrentInstance() {
        return INSTANCE;
    }

    @NotNull
    public static EnchantConflictGui getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EnchantConflictGui();
        }
        return INSTANCE;
    }

    private EnchantConflictGui() {
        super("Conflict Config");
        this.init();
    }

    @Override
    protected EnchantConflictGroup createAndSaveNewEmptyGeneric(String name) {
        EnchantConflictGroup conflict = new EnchantConflictGroup(name, new IncludeGroup("new_group"), 0);
        ConfigHolder.CONFLICT_HOLDER.getConflictManager().addConflict(conflict);
        String[] emptyStringArray = new String[]{};
        FileConfiguration config = ConfigHolder.CONFLICT_HOLDER.getConfig();
        config.set(name + ".enchantments", (Object)emptyStringArray);
        config.set(name + ".notAffectedGroups", (Object)emptyStringArray);
        config.set(name + ".maxEnchantmentBeforeConflict", (Object)0);
        ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
        return conflict;
    }

    @Override
    public ItemStack createItemForGeneric(EnchantConflictGroup conflict) {
        ItemStack item = new ItemStack(conflict.getRepresentativeMaterial());
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.addItemFlags(ItemFlag.values());
        meta.setDisplayName("\u00a7e" + CasedStringUtil.snakeToUpperSpacedCase(conflict.toString()) + " \u00a7fConflict");
        meta.setLore(Arrays.asList("\u00a77Enchantment count:       \u00a7e" + conflict.getEnchants().size(), "\u00a77Group count:               \u00a7e" + conflict.getCantConflictGroup().getGroups().size(), "\u00a77Min enchantments count: \u00a7e" + conflict.getMinBeforeBlock()));
        item.setItemMeta(meta);
        return item;
    }

    @Override
    protected MappedGuiListConfigGui.LazyElement<EnchantConflictSubSettingGui> newInstanceOfGui(EnchantConflictGroup conflict, GuiItem item) {
        return new MappedGuiListConfigGui.LazyElement<EnchantConflictSubSettingGui>(item, () -> new EnchantConflictSubSettingGui(this, conflict));
    }

    @Override
    protected String genericDisplayedName() {
        return "conflict";
    }

    @Override
    protected Collection<EnchantConflictGroup> getEveryDisplayableInstanceOfGeneric() {
        return ConfigHolder.CONFLICT_HOLDER.getConflictManager().getConflictList();
    }
}

