/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.api;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Triple;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.dependency.DependencyManager;
import xyz.alexcrea.cuanvil.gui.config.global.UnitRepairConfigGui;
import xyz.alexcrea.cuanvil.gui.config.list.UnitRepairElementListGui;

public class UnitRepairApi {
    private static Object saveChangeTask = null;

    private UnitRepairApi() {
    }

    public static boolean addUnitRepair(@NotNull Material unit, @NotNull Material repairable) {
        return UnitRepairApi.addUnitRepair(unit, repairable, 0.25, false);
    }

    public static boolean addUnitRepair(@NotNull Material unit, @NotNull Material repairable, double value) {
        return UnitRepairApi.addUnitRepair(unit, repairable, value, false);
    }

    public static boolean addUnitRepair(@NotNull Material unit, @NotNull Material repairable, double value, boolean overrideDeleted) {
        FileConfiguration config = ConfigHolder.UNIT_REPAIR_HOLDER.getConfig();
        String path = unit.name().toLowerCase() + "." + repairable.name().toLowerCase();
        if (!overrideDeleted && ConfigHolder.UNIT_REPAIR_HOLDER.isDeleted(path)) {
            return false;
        }
        if (config.contains(path)) {
            return false;
        }
        return UnitRepairApi.setUnitRepair(unit, repairable, value);
    }

    public static boolean setUnitRepair(@NotNull Material unit, @NotNull Material repairable, double value) {
        FileConfiguration config = ConfigHolder.UNIT_REPAIR_HOLDER.getConfig();
        String repairableName = repairable.name().toLowerCase();
        String path = unit.name().toLowerCase() + "." + repairableName;
        config.set(path, (Object)value);
        UnitRepairApi.prepareSaveTask();
        UnitRepairConfigGui repairConfigGui = UnitRepairConfigGui.getCurrentInstance();
        if (repairConfigGui != null) {
            UnitRepairElementListGui elementGui = (UnitRepairElementListGui)repairConfigGui.getInstanceOrCreate(unit).getStored();
            if (elementGui != null) {
                elementGui.updateValueForGeneric(repairableName, true);
            }
            repairConfigGui.updateValueForGeneric(unit, true);
        }
        return true;
    }

    public static boolean removeUnitRepair(@NotNull Material unit, @NotNull Material repairable) {
        String unitName = unit.name();
        String repairableName = repairable.name();
        FileConfiguration config = ConfigHolder.UNIT_REPAIR_HOLDER.getConfig();
        config.set(unitName.toLowerCase() + "." + repairableName.toUpperCase(), null);
        config.set(unitName.toUpperCase() + "." + repairableName.toLowerCase(), null);
        config.set(unitName.toUpperCase() + "." + repairableName.toUpperCase(), null);
        config.set(unitName.toLowerCase() + "." + repairableName.toLowerCase(), null);
        boolean lastValue = false;
        if (config.isConfigurationSection(unitName.toLowerCase())) {
            section = config.getConfigurationSection(unitName.toLowerCase());
            if (section != null && section.getKeys(false).isEmpty()) {
                lastValue = true;
                config.set(unitName.toLowerCase(), null);
            }
        } else if (config.isConfigurationSection(unitName.toUpperCase())) {
            section = config.getConfigurationSection(unitName.toUpperCase());
            if (section != null && section.getKeys(false).isEmpty()) {
                lastValue = true;
                config.set(unitName.toUpperCase(), null);
            }
        } else {
            lastValue = true;
        }
        ConfigHolder.UNIT_REPAIR_HOLDER.delete(unitName.toLowerCase() + "." + repairableName.toLowerCase());
        UnitRepairApi.prepareSaveTask();
        UnitRepairConfigGui repairConfigGui = UnitRepairConfigGui.getCurrentInstance();
        if (repairConfigGui != null) {
            UnitRepairElementListGui elementGui = (UnitRepairElementListGui)repairConfigGui.getInstanceOrCreate(unit).getStored();
            if (elementGui != null) {
                elementGui.removeGeneric(repairableName);
            }
            if (lastValue) {
                repairConfigGui.removeGeneric(unit);
            }
        }
        return true;
    }

    private static void prepareSaveTask() {
        if (saveChangeTask != null) {
            return;
        }
        saveChangeTask = DependencyManager.scheduler.scheduleGlobally((Plugin)CustomAnvil.instance, () -> {
            ConfigHolder.UNIT_REPAIR_HOLDER.saveToDisk(true);
            saveChangeTask = null;
        });
    }

    @NotNull
    public static List<Triple<Material, Material, Double>> getUnitRepairs() {
        ArrayList<Triple<Material, Material, Double>> mutableList = new ArrayList<Triple<Material, Material, Double>>();
        FileConfiguration config = ConfigHolder.UNIT_REPAIR_HOLDER.getConfig();
        for (String unitKey : config.getKeys(false)) {
            Material unit;
            if (!config.isConfigurationSection(unitKey) || (unit = Material.getMaterial((String)unitKey.toUpperCase())) == null) continue;
            ConfigurationSection section = config.getConfigurationSection(unitKey);
            for (String repairableKey : section.getKeys(false)) {
                Material repairable;
                if (!section.isDouble(repairableKey) || (repairable = Material.getMaterial((String)repairableKey.toUpperCase())) == null) continue;
                mutableList.add(new Triple<Material, Material, Double>(unit, repairable, section.getDouble(repairableKey)));
            }
        }
        return Collections.unmodifiableList(mutableList);
    }
}

