/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.api;

import io.delilaheve.CustomAnvil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.api.ConflictAPI;
import xyz.alexcrea.cuanvil.api.EnchantmentApi;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.group.AbstractMaterialGroup;
import xyz.alexcrea.cuanvil.group.EnchantConflictGroup;
import xyz.alexcrea.cuanvil.group.IncludeGroup;
import xyz.alexcrea.cuanvil.group.ItemGroupManager;

public class ConflictBuilder {
    @Nullable
    private final Plugin source;
    @NotNull
    private String name;
    @NotNull
    private final Set<String> enchantmentNames;
    @NotNull
    private final Set<NamespacedKey> enchantmentKeys;
    @NotNull
    private final Set<String> excludedGroupNames;
    private int maxBeforeConflict;

    public ConflictBuilder(@NotNull String name, int maxBeforeConflict, @Nullable Plugin source) {
        this.source = source;
        this.name = name;
        this.enchantmentNames = new HashSet<String>();
        this.enchantmentKeys = new HashSet<NamespacedKey>();
        this.excludedGroupNames = new HashSet<String>();
        this.maxBeforeConflict = maxBeforeConflict;
    }

    public ConflictBuilder(@NotNull String name, @Nullable Plugin source) {
        this(name, 0, source);
    }

    public ConflictBuilder(@NotNull String name) {
        this(name, null);
    }

    @Nullable
    public Plugin getSource() {
        return this.source;
    }

    @NotNull
    public String getSourceName() {
        if (this.source == null) {
            return "an unknown source";
        }
        return this.source.getName();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Set<String> getEnchantmentNames() {
        return this.enchantmentNames;
    }

    @NotNull
    public Set<NamespacedKey> getEnchantmentKeys() {
        return this.enchantmentKeys;
    }

    @NotNull
    public Set<String> getExcludedGroupNames() {
        return this.excludedGroupNames;
    }

    public int getMaxBeforeConflict() {
        return this.maxBeforeConflict;
    }

    public ConflictBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ConflictBuilder setMaxBeforeConflict(int maxBeforeConflict) {
        this.maxBeforeConflict = maxBeforeConflict;
        return this;
    }

    @NotNull
    public ConflictBuilder addEnchantment(@NotNull String enchantmentName) {
        this.enchantmentNames.add(enchantmentName);
        return this;
    }

    @NotNull
    public ConflictBuilder addEnchantment(@NotNull NamespacedKey enchantmentKey) {
        this.enchantmentKeys.add(enchantmentKey);
        return this;
    }

    @NotNull
    public ConflictBuilder addEnchantment(@NotNull CAEnchantment enchantment) {
        this.addEnchantment(enchantment.getKey());
        return this;
    }

    @NotNull
    public ConflictBuilder removeEnchantment(@NotNull String enchantmentName) {
        this.enchantmentNames.remove(enchantmentName);
        return this;
    }

    @NotNull
    public ConflictBuilder removeEnchantment(@NotNull NamespacedKey enchantmentKey) {
        this.enchantmentKeys.remove(enchantmentKey);
        return this.removeEnchantment(enchantmentKey.getKey());
    }

    @NotNull
    public ConflictBuilder removeEnchantment(@NotNull CAEnchantment enchantment) {
        return this.removeEnchantment(enchantment.getKey());
    }

    @NotNull
    public ConflictBuilder addExcludedGroup(@NotNull String groupName) {
        this.excludedGroupNames.add(groupName);
        return this;
    }

    @NotNull
    public ConflictBuilder addExcludedGroup(@NotNull AbstractMaterialGroup group) {
        return this.addExcludedGroup(group.getName());
    }

    @NotNull
    public ConflictBuilder removeExcludedGroup(@NotNull String groupName) {
        this.excludedGroupNames.remove(groupName);
        return this;
    }

    @NotNull
    public ConflictBuilder removeExcludedGroup(@NotNull AbstractMaterialGroup group) {
        return this.removeExcludedGroup(group.getName());
    }

    @NotNull
    public ConflictBuilder copy() {
        ConflictBuilder copy = new ConflictBuilder(this.name, this.source);
        copy.setMaxBeforeConflict(this.maxBeforeConflict);
        for (NamespacedKey key : this.enchantmentKeys) {
            copy.addEnchantment(key);
        }
        for (String enchantName : this.enchantmentNames) {
            copy.addEnchantment(enchantName);
        }
        for (String groupName : this.excludedGroupNames) {
            copy.addExcludedGroup(groupName);
        }
        return copy;
    }

    public EnchantConflictGroup build() {
        AbstractMaterialGroup materials = this.extractGroups();
        EnchantConflictGroup conflict = new EnchantConflictGroup(this.getName(), materials, this.getMaxBeforeConflict());
        this.appendEnchantments(conflict);
        return conflict;
    }

    public boolean registerIfAbsent() {
        return ConflictAPI.addConflict(this, true);
    }

    public boolean registerIfNew() {
        return ConflictAPI.addConflict(this);
    }

    protected void appendEnchantments(@NotNull EnchantConflictGroup conflict) {
        for (String enchantmentName : this.getEnchantmentNames()) {
            if (ConflictBuilder.appendEnchantments(conflict, EnchantmentApi.getListByName(enchantmentName)) != 0) continue;
            CustomAnvil.instance.getLogger().warning("Could not find enchantment " + enchantmentName + " for conflict " + this.getName());
            ConflictAPI.logConflictOrigin(this);
        }
        for (NamespacedKey enchantmentKey : this.getEnchantmentKeys()) {
            if (ConflictBuilder.appendEnchantment(conflict, EnchantmentApi.getByKey(enchantmentKey))) continue;
            CustomAnvil.instance.getLogger().warning("Could not find enchantment " + String.valueOf(enchantmentKey) + " for conflict " + this.getName());
            ConflictAPI.logConflictOrigin(this);
        }
    }

    protected static boolean appendEnchantment(@NotNull EnchantConflictGroup conflict, @Nullable CAEnchantment enchantment) {
        if (enchantment == null) {
            return false;
        }
        conflict.addEnchantment(enchantment);
        return true;
    }

    protected static int appendEnchantments(@NotNull EnchantConflictGroup conflict, @NotNull List<CAEnchantment> enchantments) {
        int numberValid = 0;
        for (CAEnchantment enchantment : enchantments) {
            if (!ConflictBuilder.appendEnchantment(conflict, enchantment)) continue;
            ++numberValid;
        }
        return numberValid;
    }

    protected AbstractMaterialGroup extractGroups() {
        ItemGroupManager itemGroupManager = ConfigHolder.ITEM_GROUP_HOLDER.getItemGroupsManager();
        IncludeGroup group = new IncludeGroup("joinedGroup");
        for (String groupName : this.getExcludedGroupNames()) {
            AbstractMaterialGroup materialGroup = itemGroupManager.get(groupName);
            if (materialGroup == null) {
                CustomAnvil.instance.getLogger().warning("Material group " + groupName + " do not exist but is ask by conflict " + this.getName());
                ConflictAPI.logConflictOrigin(this);
                continue;
            }
            group.addToPolicy(materialGroup);
        }
        return group;
    }
}

