/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.update;

import io.delilaheve.CustomAnvil;
import org.bukkit.configuration.file.FileConfiguration;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.update.UpdateUtils;
import xyz.alexcrea.cuanvil.update.Version;

public class Update_1_21 {
    private static final Version V1_21 = new Version(1, 21);

    public static boolean handleUpdate(Version current) {
        Version version;
        if (V1_21.greaterThan(current)) {
            return false;
        }
        String oldVersion = ConfigHolder.DEFAULT_CONFIG.getConfig().getString("lowMinecraftVersion");
        if (oldVersion != null && V1_21.lesserEqual(version = Version.fromString(oldVersion))) {
            return false;
        }
        Update_1_21.doUpdate();
        return true;
    }

    private static void doUpdate() {
        CustomAnvil.instance.getLogger().info("Updating config to support 1.21 ...");
        FileConfiguration baseConfig = ConfigHolder.DEFAULT_CONFIG.getConfig();
        FileConfiguration groupConfig = ConfigHolder.ITEM_GROUP_HOLDER.getConfig();
        FileConfiguration conflictConfig = ConfigHolder.CONFLICT_HOLDER.getConfig();
        FileConfiguration unitConfig = ConfigHolder.UNIT_REPAIR_HOLDER.getConfig();
        groupConfig.set("mace.type", (Object)"include");
        UpdateUtils.addAbsentToList(groupConfig, "mace.items", "mace");
        UpdateUtils.addAbsentToList(groupConfig, "can_unbreak.groups", "mace");
        UpdateUtils.addAbsentToList(conflictConfig, "restriction_density.enchantments", "minecraft:density");
        UpdateUtils.addAbsentToList(conflictConfig, "restriction_density.notAffectedGroups", "mace", "enchanted_book");
        UpdateUtils.addAbsentToList(conflictConfig, "restriction_breach.enchantments", "minecraft:breach");
        UpdateUtils.addAbsentToList(conflictConfig, "restriction_breach.notAffectedGroups", "mace", "enchanted_book");
        UpdateUtils.addAbsentToList(conflictConfig, "restriction_wind_burst.enchantments", "minecraft:wind_burst");
        UpdateUtils.addAbsentToList(conflictConfig, "restriction_wind_burst.notAffectedGroups", "mace", "enchanted_book");
        UpdateUtils.addAbsentToList(conflictConfig, "restriction_fire_aspect.notAffectedGroups", "mace");
        UpdateUtils.addAbsentToList(conflictConfig, "restriction_smite.notAffectedGroups", "mace");
        UpdateUtils.addAbsentToList(conflictConfig, "restriction_bane_of_arthropods.notAffectedGroups", "mace");
        UpdateUtils.addAbsentToList(conflictConfig, "sword_enchant_conflict.enchantments", "minecraft:density", "minecraft:breach");
        baseConfig.set("enchant_limits.minecraft:density", (Object)5);
        baseConfig.set("enchant_limits.minecraft:breach", (Object)4);
        baseConfig.set("enchant_limits.minecraft:wind_burst", (Object)3);
        baseConfig.set("enchant_values.minecraft:density.item", (Object)2);
        baseConfig.set("enchant_values.minecraft:density.book", (Object)1);
        baseConfig.set("enchant_values.minecraft:breach.item", (Object)4);
        baseConfig.set("enchant_values.minecraft:breach.book", (Object)2);
        baseConfig.set("enchant_values.minecraft:wind_burst.item", (Object)4);
        baseConfig.set("enchant_values.minecraft:wind_burst.book", (Object)2);
        unitConfig.set("breeze_rod.mace", (Object)0.25);
        baseConfig.set("lowMinecraftVersion", (Object)V1_21.toString());
        ConfigHolder.DEFAULT_CONFIG.saveToDisk(true);
        ConfigHolder.ITEM_GROUP_HOLDER.saveToDisk(true);
        ConfigHolder.CONFLICT_HOLDER.saveToDisk(true);
        ConfigHolder.UNIT_REPAIR_HOLDER.saveToDisk(true);
        ConfigHolder.ITEM_GROUP_HOLDER.reload();
    }
}

