/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.list;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.cuanvil.gui.util.GuiSharedConstant;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.ChestGui;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.Orientable;
import xyz.alexcrea.inventoryframework.pane.OutlinePane;
import xyz.alexcrea.inventoryframework.pane.Pane;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public abstract class ElementListConfigGui<T>
extends ChestGui
implements ValueUpdatableGui {
    private final String namePrefix;
    protected PatternPane backgroundPane;
    public static final int LIST_FILLER_START_X = 1;
    public static final int LIST_FILLER_START_Y = 1;
    public static final int LIST_FILLER_LENGTH = 7;
    public static final int LIST_FILLER_HEIGHT = 4;
    protected OutlinePane firstPage;
    protected ArrayList<OutlinePane> pages;
    protected HashMap<UUID, Integer> pageMap;
    protected GuiItem goLeftItem;
    protected GuiItem goRightItem;

    protected ElementListConfigGui(@NotNull String title, Gui parent) {
        super(6, title, (Plugin)CustomAnvil.instance);
        this.namePrefix = title;
        Pattern pattern = this.getBackgroundPattern();
        this.backgroundPane = new PatternPane(0, 0, 9, 6, Pane.Priority.LOW, pattern);
        GuiGlobalItems.addBackItem(this.backgroundPane, parent);
    }

    protected Pattern getBackgroundPattern() {
        return new Pattern("111111111", "100000001", "100000001", "100000001", "100000001", "B11L1R11C");
    }

    public void init() {
        GuiGlobalItems.addBackgroundItem(this.backgroundPane);
        this.backgroundPane.bindItem('1', GuiSharedConstant.SECONDARY_BACKGROUND_ITEM);
        this.addPane(this.backgroundPane);
        this.pages = new ArrayList();
        this.pageMap = new HashMap();
        this.firstPage = this.createEmptyPage();
        this.pages.add(this.firstPage);
        this.prepareStaticValues();
        this.reloadValues();
    }

    protected void prepareStaticValues() {
        this.goLeftItem = new GuiItem(new ItemStack(Material.RED_STAINED_GLASS_PANE), event -> {
            HumanEntity viewer = event.getWhoClicked();
            UUID playerUUID = viewer.getUniqueId();
            int page = this.pageMap.getOrDefault(playerUUID, 0);
            this.pageMap.put(playerUUID, page - 1);
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(new ItemStack(Material.AIR));
            this.show(viewer);
            viewer.setItemOnCursor(cursor);
        }, (Plugin)CustomAnvil.instance);
        this.goRightItem = new GuiItem(new ItemStack(Material.LIME_STAINED_GLASS_PANE), event -> {
            HumanEntity viewer = event.getWhoClicked();
            UUID playerUUID = viewer.getUniqueId();
            int page = this.pageMap.getOrDefault(playerUUID, 0);
            this.pageMap.put(playerUUID, page + 1);
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(new ItemStack(Material.AIR));
            this.show(viewer);
            viewer.setItemOnCursor(cursor);
        }, (Plugin)CustomAnvil.instance);
        GuiItem createNew = this.prepareCreateNewItem();
        if (createNew != null) {
            this.backgroundPane.bindItem('C', createNew);
        }
    }

    protected void reloadValues() {
        this.firstPage.clear();
        this.pages.clear();
        this.pages.add(this.firstPage);
        for (T generic : this.getEveryDisplayableInstanceOfGeneric()) {
            this.updateValueForGeneric(generic, false);
        }
        this.update();
    }

    protected abstract GuiItem prepareCreateNewItem();

    protected OutlinePane createEmptyPage() {
        OutlinePane page = new OutlinePane(1, 1, 7, 4);
        page.align(OutlinePane.Alignment.BEGIN);
        page.setOrientation(Orientable.Orientation.HORIZONTAL);
        return page;
    }

    public int getPlayerPageID(UUID uuid) {
        int pageId = this.pageMap.getOrDefault(uuid, 0);
        if (pageId >= this.pages.size()) {
            pageId = this.pages.size() - 1;
        }
        return pageId;
    }

    protected void addToPage(GuiItem guiItem) {
        OutlinePane page = this.pages.get(this.pages.size() - 1);
        if (page.getItems().size() >= 28) {
            page = this.createEmptyPage();
            this.pages.add(page);
        }
        page.addItem(guiItem);
    }

    private void removeFromPage(GuiItem guiItem) {
        int pageID;
        OutlinePane page = null;
        for (pageID = 0; pageID < this.pages.size(); ++pageID) {
            OutlinePane tempPage = this.pages.get(pageID);
            if (!tempPage.getItems().contains(guiItem)) continue;
            page = tempPage;
            break;
        }
        if (page == null) {
            return;
        }
        this.removeFromPage(page, pageID, guiItem);
    }

    private void removeFromPage(OutlinePane page, int pageID, GuiItem guiItem) {
        page.removeItem(guiItem);
        if (pageID < this.pages.size() - 1) {
            OutlinePane newPage = this.pages.get(pageID + 1);
            GuiItem nextPageItem = (GuiItem)newPage.getItems().get(0);
            this.removeFromPage(newPage, pageID + 1, nextPageItem);
            OutlinePane thisPage = this.pages.get(pageID);
            thisPage.addItem(nextPageItem);
        } else if (pageID > 0 && page.getItems().isEmpty()) {
            this.pages.remove(pageID);
        }
    }

    public void placeArrow(int page, boolean customise) {
        this.addPane(this.backgroundPane);
        if (page > 0) {
            if (customise) {
                ItemStack leftItem = this.goLeftItem.getItem();
                ItemMeta leftMeta = leftItem.getItemMeta();
                leftMeta.setDisplayName("\u00a7eReturn to page " + page);
                leftItem.setItemMeta(leftMeta);
                this.goLeftItem.setItem(leftItem);
            }
            this.backgroundPane.bindItem('L', this.goLeftItem);
        } else {
            this.backgroundPane.bindItem('L', GuiSharedConstant.SECONDARY_BACKGROUND_ITEM);
        }
        if (page < this.pages.size() - 1) {
            if (customise) {
                ItemStack rightItem = this.goRightItem.getItem();
                ItemMeta rightMeta = rightItem.getItemMeta();
                rightMeta.setDisplayName("\u00a7eGo to page " + (page + 2));
                rightItem.setItemMeta(rightMeta);
                this.goRightItem.setItem(rightItem);
            }
            this.backgroundPane.bindItem('R', this.goRightItem);
        } else {
            this.backgroundPane.bindItem('R', GuiSharedConstant.SECONDARY_BACKGROUND_ITEM);
        }
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        int pageID = this.getPlayerPageID(humanEntity.getUniqueId());
        OutlinePane page = this.pages.get(pageID);
        this.getPanes().clear();
        this.placeArrow(pageID, true);
        this.addPane(page);
        StringBuilder title = new StringBuilder(this.namePrefix);
        int pagesSize = this.pages.size();
        if (pagesSize > 1) {
            title.append(" (").append(pageID + 1).append('/').append(pagesSize).append(')');
        }
        this.setTitle(title.toString());
        super.show(humanEntity);
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int pageID = this.getPlayerPageID(event.getWhoClicked().getUniqueId());
        OutlinePane page = this.pages.get(pageID);
        this.getPanes().clear();
        this.placeArrow(pageID, false);
        this.addPane(page);
        super.click(event);
    }

    public void updateValueForGeneric(T generic, boolean shouldUpdate) {
        ItemStack item = this.createItemForGeneric(generic);
        this.updateGeneric(generic, item);
        if (shouldUpdate) {
            this.update();
        }
    }

    public void removeGeneric(T generic) {
        GuiItem item = this.findGuiItemForRemoval(generic);
        if (item == null) {
            return;
        }
        this.removeFromPage(item);
        this.update();
    }

    protected abstract GuiItem findGuiItemForRemoval(T var1);

    protected abstract ItemStack createItemForGeneric(T var1);

    protected abstract void updateGeneric(T var1, ItemStack var2);

    protected abstract Collection<T> getEveryDisplayableInstanceOfGeneric();

    @Override
    public void updateGuiValues() {
        this.reloadValues();
    }

    @Override
    public Gui getConnectedGui() {
        return this;
    }
}

