/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.dependency.plugins;

import com.google.common.collect.BiMap;
import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.athlaeos.enchantssquared.enchantments.CustomEnchant;
import me.athlaeos.enchantssquared.listeners.AnvilListener;
import me.athlaeos.enchantssquared.managers.CustomEnchantManager;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.api.ConflictBuilder;
import xyz.alexcrea.cuanvil.api.EnchantmentApi;
import xyz.alexcrea.cuanvil.api.MaterialGroupApi;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.enchant.CAEnchantmentRegistry;
import xyz.alexcrea.cuanvil.enchant.bulk.EnchantSquaredBulkOperation;
import xyz.alexcrea.cuanvil.enchant.wrapped.CAEnchantSquaredEnchantment;
import xyz.alexcrea.cuanvil.group.IncludeGroup;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\"\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u0007J\b\u0010\u0016\u001a\u00020\u0007H\u0002J\u0016\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0016\u0010\u001b\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020 H\u0002J\u000e\u0010\"\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lxyz/alexcrea/cuanvil/dependency/plugins/EnchantmentSquaredDependency;", "", "enchantmentSquaredPlugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "disableAnvilListener", "", "registerEnchantments", "getEnchantmentsSquared", "item", "Lorg/bukkit/inventory/ItemStack;", "enchantments", "", "Lxyz/alexcrea/cuanvil/enchant/CAEnchantment;", "", "getKeyFromEnchant", "Lorg/bukkit/NamespacedKey;", "enchant", "Lme/athlaeos/enchantssquared/enchantments/CustomEnchant;", "getWrappedEnchant", "registerPluginConfiguration", "writeMissingGroups", "writeMaterialRestriction", "esEnchantments", "", "Lxyz/alexcrea/cuanvil/enchant/wrapped/CAEnchantSquaredEnchantment;", "writeEnchantmentConflicts", "writeConflict", "enchantment1", "enchantment2", "esGroupToCAGroup", "", "esGroup", "stripLore", "updateLore", "CustomAnvil"})
@SourceDebugExtension(value={"SMAP\nEnchantmentSquaredDependency.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantmentSquaredDependency.kt\nxyz/alexcrea/cuanvil/dependency/plugins/EnchantmentSquaredDependency\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,201:1\n216#2,2:202\n216#2,2:204\n*S KotlinDebug\n*F\n+ 1 EnchantmentSquaredDependency.kt\nxyz/alexcrea/cuanvil/dependency/plugins/EnchantmentSquaredDependency\n*L\n72#1:202,2\n90#1:204,2\n*E\n"})
public final class EnchantmentSquaredDependency {
    @NotNull
    private final Plugin enchantmentSquaredPlugin;

    public EnchantmentSquaredDependency(@NotNull Plugin enchantmentSquaredPlugin) {
        Intrinsics.checkNotNullParameter(enchantmentSquaredPlugin, "enchantmentSquaredPlugin");
        this.enchantmentSquaredPlugin = enchantmentSquaredPlugin;
        CustomAnvil.Companion.getInstance().getLogger().info("Enchantment Squared Detected !");
        CustomAnvil.Companion.getInstance().getLogger().info("Please be aware that Custom Anvil is bypassing Enchantment Squared ");
        CustomAnvil.Companion.getInstance().getLogger().info("compatible_with, disable_anvil, incompatible_vanilla_enchantments, incompatible_custom_enchantments and max_level configuration values.");
    }

    public final void disableAnvilListener() {
        PrepareAnvilEvent.getHandlerList().unregister(this.enchantmentSquaredPlugin);
        AnvilListener toRemove = null;
        for (RegisteredListener registered : InventoryClickEvent.getHandlerList().getRegisteredListeners()) {
            Listener listener;
            Intrinsics.checkNotNullExpressionValue(registered.getListener(), "getListener(...)");
            if (!(listener instanceof AnvilListener)) continue;
            toRemove = (AnvilListener)listener;
            break;
        }
        if (toRemove != null) {
            InventoryClickEvent.getHandlerList().unregister((Listener)toRemove);
        }
    }

    public final void registerEnchantments() {
        CustomAnvil.Companion.getInstance().getLogger().info("Preparing Enchantment Squared compatibility...");
        for (CustomEnchant enchant : (Set)CustomEnchantManager.getInstance().getAllEnchants().values()) {
            EnchantmentApi.registerEnchantment(new CAEnchantSquaredEnchantment(enchant));
        }
        EnchantSquaredBulkOperation bulkOpperations = new EnchantSquaredBulkOperation();
        EnchantmentApi.addBulkGet(bulkOpperations);
        EnchantmentApi.addBulkClean(bulkOpperations);
    }

    public final void getEnchantmentsSquared(@NotNull ItemStack item, @NotNull Map<CAEnchantment, Integer> enchantments) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(enchantments, "enchantments");
        Map customEnchants = CustomEnchantManager.getInstance().getItemsEnchantsFromPDC(item);
        Intrinsics.checkNotNull(customEnchants);
        Map $this$forEach$iv = customEnchants;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            CustomEnchant enchantment = (CustomEnchant)entry.getKey();
            Integer level = (Integer)entry.getValue();
            Intrinsics.checkNotNull(enchantment);
            enchantments.put(this.getWrappedEnchant(enchantment), level);
        }
    }

    @NotNull
    public final NamespacedKey getKeyFromEnchant(@NotNull CustomEnchant enchant) {
        Intrinsics.checkNotNullParameter(enchant, "enchant");
        String string = enchant.getType();
        Intrinsics.checkNotNullExpressionValue(string, "getType(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        NamespacedKey namespacedKey = NamespacedKey.fromString((String)string3, (Plugin)this.enchantmentSquaredPlugin);
        Intrinsics.checkNotNull(namespacedKey);
        return namespacedKey;
    }

    private final CAEnchantment getWrappedEnchant(CustomEnchant enchant) {
        CAEnchantment cAEnchantment = CAEnchantment.getByKey(this.getKeyFromEnchant(enchant));
        Intrinsics.checkNotNull(cAEnchantment);
        return cAEnchantment;
    }

    public final void registerPluginConfiguration() {
        CustomAnvil.Companion.getInstance().getLogger().info("Preparing Enchantment Squared config...");
        ArrayList<CAEnchantSquaredEnchantment> esEnchantments = new ArrayList<CAEnchantSquaredEnchantment>();
        BiMap biMap = CustomEnchantManager.getInstance().getAllEnchants();
        Intrinsics.checkNotNullExpressionValue(biMap, "getAllEnchants(...)");
        Map $this$forEach$iv = (Map)biMap;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            CustomEnchant enchant = (CustomEnchant)entry.getValue();
            Intrinsics.checkNotNull(enchant);
            CAEnchantment cAEnchantment = this.getWrappedEnchant(enchant);
            Intrinsics.checkNotNull(cAEnchantment, "null cannot be cast to non-null type xyz.alexcrea.cuanvil.enchant.wrapped.CAEnchantSquaredEnchantment");
            esEnchantments.add((CAEnchantSquaredEnchantment)cAEnchantment);
        }
        this.writeMissingGroups();
        this.writeMaterialRestriction((List<? extends CAEnchantSquaredEnchantment>)esEnchantments);
        this.writeEnchantmentConflicts((List<? extends CAEnchantSquaredEnchantment>)esEnchantments);
        CustomAnvil.Companion.getInstance().getLogger().info("Enchantment Squared should now work as expected !");
    }

    private final void writeMissingGroups() {
        IncludeGroup shield = new IncludeGroup("shield");
        shield.addToPolicy(Material.SHIELD);
        MaterialGroupApi.addMaterialGroup(shield);
        IncludeGroup elytra = new IncludeGroup("elytra");
        elytra.addToPolicy(Material.ELYTRA);
        MaterialGroupApi.addMaterialGroup(elytra);
        IncludeGroup trinkets = new IncludeGroup("trinkets");
        trinkets.addToPolicy(Material.ROTTEN_FLESH);
        MaterialGroupApi.addMaterialGroup(trinkets);
    }

    private final void writeMaterialRestriction(List<? extends CAEnchantSquaredEnchantment> esEnchantments) {
        for (CAEnchantSquaredEnchantment cAEnchantSquaredEnchantment : esEnchantments) {
            ConflictBuilder conflict = new ConflictBuilder("restriction_" + cAEnchantSquaredEnchantment.getKey().getKey(), (Plugin)CustomAnvil.Companion.getInstance());
            conflict.addEnchantment(cAEnchantSquaredEnchantment);
            conflict.addExcludedGroup("enchanted_book");
            for (String esGroup : cAEnchantSquaredEnchantment.enchant.getCompatibleItems()) {
                Intrinsics.checkNotNull(esGroup);
                String caGroup = this.esGroupToCAGroup(esGroup);
                if (caGroup == null) {
                    CustomAnvil.Companion.getInstance().getLogger().info("Could not find equivalent custom anvil group for " + esGroup);
                    continue;
                }
                conflict.addExcludedGroup(caGroup);
            }
            conflict.registerIfAbsent();
        }
    }

    private final void writeEnchantmentConflicts(List<? extends CAEnchantSquaredEnchantment> esEnchantments) {
        ArrayList<CAEnchantment> otherEnchants = new ArrayList<CAEnchantment>();
        otherEnchants.addAll(CAEnchantmentRegistry.getInstance().values());
        for (CAEnchantSquaredEnchantment cAEnchantSquaredEnchantment : esEnchantments) {
            Iterator iterator2;
            otherEnchants.remove(cAEnchantSquaredEnchantment);
            Intrinsics.checkNotNullExpressionValue(otherEnchants.iterator(), "iterator(...)");
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                CAEnchantment otherEnchant = (CAEnchantment)e;
                if (!cAEnchantSquaredEnchantment.enchant.conflictsWithEnchantment(otherEnchant.getName())) continue;
                this.writeConflict(cAEnchantSquaredEnchantment, otherEnchant);
            }
        }
    }

    private final void writeConflict(CAEnchantment enchantment1, CAEnchantment enchantment2) {
        ConflictBuilder conflict = new ConflictBuilder(enchantment1.getName() + "_with_" + enchantment2.getName() + "_conflict", (Plugin)CustomAnvil.Companion.getInstance());
        conflict.addEnchantment(enchantment1).addEnchantment(enchantment2);
        conflict.setMaxBeforeConflict(1);
        conflict.registerIfAbsent();
    }

    private final String esGroupToCAGroup(String esGroup) {
        return switch (esGroup) {
            case "SWORDS" -> "swords";
            case "BOWS" -> "bow";
            case "CROSSBOWS" -> "crossbow";
            case "TRIDENTS" -> "trident";
            case "HELMETS" -> "helmets";
            case "CHESTPLATES" -> "chestplate";
            case "LEGGINGS" -> "leggings";
            case "BOOTS" -> "boots";
            case "SHEARS" -> "shears";
            case "FLINTANDSTEEL" -> "flint_and_steel";
            case "FISHINGROD" -> "fishing_rod";
            case "ELYTRA", "ELYTRAS" -> "elytra";
            case "PICKAXES" -> "pickaxes";
            case "AXES" -> "axes";
            case "SHOVELS" -> "shovels";
            case "HOES" -> "hoes";
            case "SHIELDS" -> "shield";
            case "TRINKETS" -> "trinkets";
            case "ALL" -> "everything";
            default -> null;
        };
    }

    public final void stripLore(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        CustomEnchantManager.getInstance().removeAllEnchants(item);
    }

    public final void updateLore(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        CustomEnchantManager.getInstance().updateLore(item);
    }
}

