/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.util;

import io.delilaheve.CustomAnvil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.settings.SettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalActions;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.PatternPane;

public class GuiGlobalItems {
    private static final ItemStack BACK_ITEM = new ItemStack(Material.BARRIER);
    private static final Material DEFAULT_BACKGROUND_MAT;
    public static final Material DEFAULT_SAVE_ITEM;
    public static final Material DEFAULT_NO_CHANGE_ITEM;
    private static final GuiItem NO_CHANGE_ITEM;
    public static final String SETTING_ITEM_LORE_PREFIX = "\u00a77value: ";

    public static GuiItem goToGuiItem(@NotNull ItemStack item, @NotNull Gui goal) {
        return new GuiItem(item, GuiGlobalActions.openGuiAction(goal), (Plugin)CustomAnvil.instance);
    }

    public static GuiItem backItem(@NotNull Gui goal) {
        return GuiGlobalItems.goToGuiItem(BACK_ITEM, goal);
    }

    public static void addBackItem(@NotNull PatternPane target, @NotNull Gui goal) {
        target.bindItem('B', GuiGlobalItems.backItem(goal));
    }

    public static GuiItem backgroundItem(Material backgroundMat) {
        ItemStack item = new ItemStack(backgroundMat);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7c");
        item.setItemMeta(meta);
        return new GuiItem(item, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
    }

    public static GuiItem backgroundItem() {
        return GuiGlobalItems.backgroundItem(DEFAULT_BACKGROUND_MAT);
    }

    public static void addBackgroundItem(@NotNull PatternPane target, @NotNull Material backgroundMat) {
        target.bindItem('0', GuiGlobalItems.backgroundItem(backgroundMat));
    }

    public static void addBackgroundItem(@NotNull PatternPane target) {
        GuiGlobalItems.addBackgroundItem(target, DEFAULT_BACKGROUND_MAT);
    }

    public static GuiItem saveItem(@NotNull SettingGui setting, @NotNull ValueUpdatableGui goal) {
        ItemStack item = new ItemStack(DEFAULT_SAVE_ITEM);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7aSave");
        item.setItemMeta(meta);
        return new GuiItem(item, GuiGlobalActions.saveSettingAction(setting, goal), (Plugin)CustomAnvil.instance);
    }

    public static GuiItem noChangeItem() {
        return NO_CHANGE_ITEM;
    }

    public static GuiItem openSettingGuiItem(@NotNull ItemStack item, @NotNull SettingGui.SettingGuiFactory factory) {
        return new GuiItem(item, GuiGlobalActions.openSettingGuiAction(factory), (Plugin)CustomAnvil.instance);
    }

    public static GuiItem createGuiItemFromProperties(@NotNull SettingGui.SettingGuiFactory factory, @NotNull Material itemMat, @NotNull StringBuilder itemName, @NotNull Object value, @NotNull List<String> displayLore, boolean displayValuePrefix) {
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add((displayValuePrefix ? SETTING_ITEM_LORE_PREFIX : "") + String.valueOf(value));
        if (!displayLore.isEmpty()) {
            lore.add("");
            lore.addAll(displayLore);
        }
        ItemStack item = new ItemStack(itemMat);
        ItemMeta itemMeta = item.getItemMeta();
        assert (itemMeta != null);
        itemMeta.setDisplayName(itemName.toString());
        itemMeta.setLore(lore);
        itemMeta.addItemFlags(ItemFlag.values());
        item.setItemMeta(itemMeta);
        return GuiGlobalItems.openSettingGuiItem(item, factory);
    }

    public static String getConfigNameFromPath(String path) {
        int indexOfDot = path.indexOf(".");
        return path.substring(indexOfDot + 1);
    }

    public static GuiItem temporaryCloseGuiToSelectItem(Material itemMaterial, Gui openBack) {
        ItemStack item = new ItemStack(itemMaterial);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7eTemporary close this menu");
        meta.setLore(Collections.singletonList("\u00a77Allow you to chose other item then return here."));
        item.setItemMeta(meta);
        return new GuiItem(item, event -> {
            event.setCancelled(true);
            HumanEntity player = event.getWhoClicked();
            CustomAnvil.Companion.getChatListener().setListenedCallback(player, message -> {
                if (message == null) {
                    return;
                }
                openBack.show(player);
            });
            player.sendMessage("\u00a7eWrite something in chat to return to the item config menu.");
            player.closeInventory();
        }, (Plugin)CustomAnvil.instance);
    }

    static {
        ItemMeta meta = BACK_ITEM.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7cBack");
        BACK_ITEM.setItemMeta(meta);
        DEFAULT_BACKGROUND_MAT = Material.LIGHT_GRAY_STAINED_GLASS_PANE;
        DEFAULT_SAVE_ITEM = Material.LIME_DYE;
        DEFAULT_NO_CHANGE_ITEM = Material.GRAY_DYE;
        ItemStack item = new ItemStack(DEFAULT_NO_CHANGE_ITEM);
        ItemMeta meta2 = item.getItemMeta();
        assert (meta2 != null);
        meta2.setDisplayName("\u00a77No change. can't save.");
        item.setItemMeta(meta2);
        NO_CHANGE_ITEM = new GuiItem(item, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
    }
}

